/* The following code was generated by JFlex 1.3.5 on 8/14/08 11:45 AM */

/*
 * This file is part of the Polyglot extensible compiler framework.
 *
 * Copyright (c) 2000-2006 Polyglot project group, Cornell University
 * 
 */

/* Java 1.4 scanner for JFlex.
 * Based on JLS, 2ed, Chapter 3.
 */

package polyglot.qq;

import java_cup.runtime.Symbol;
import polyglot.lex.Lexer;
import polyglot.lex.*;
import polyglot.ast.*;
import polyglot.util.Position;
import polyglot.util.InternalCompilerError;
import java.util.*;
import java.io.StringReader;
import java.math.BigInteger;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.3.5
 * on 8/14/08 11:45 AM from the specification file
 * <tt>file:/Users/nystrom/work/polyglot/workspaces/new/polyglot/polyglot/tmp/polyglot/src/polyglot/qq/qq.flex</tt>
 */
public class Lexer_c implements Lexer {

  /** This character denotes the end of file */
  final public static int YYEOF = -1;

  /** initial size of the lookahead buffer */
  final private static int YY_BUFFERSIZE = 16384;

  /** lexical states */
  final public static int END_OF_LINE_COMMENT = 4;
  final public static int STRING = 1;
  final public static int YYINITIAL = 0;
  final public static int CHARACTER = 2;
  final public static int TRADITIONAL_COMMENT = 3;

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\11\5\1\3\1\1\1\0\1\3\1\2\16\5\4\0\1\3\1\57"+
    "\1\34\1\0\1\4\1\20\1\63\1\33\1\44\1\45\1\32\1\65"+
    "\1\53\1\15\1\13\1\31\1\6\3\17\4\12\2\7\1\62\1\52"+
    "\1\56\1\54\1\55\1\61\1\0\3\11\1\25\1\22\1\27\5\4"+
    "\1\30\1\26\5\4\1\23\1\24\3\4\1\10\2\4\1\50\1\16"+
    "\1\51\1\66\1\4\1\0\1\41\1\70\1\11\1\67\1\14\1\40"+
    "\5\4\1\42\1\4\1\43\3\4\1\36\1\21\1\35\1\37\2\4"+
    "\1\10\2\4\1\46\1\64\1\47\1\60\41\5\2\0\4\4\4\0"+
    "\1\4\2\0\1\5\7\0\1\4\4\0\1\4\5\0\27\4\1\0"+
    "\37\4\1\0\u013f\4\31\0\162\4\4\0\14\4\16\0\5\4\11\0"+
    "\1\4\21\0\130\5\5\0\23\5\12\0\1\4\13\0\1\4\1\0"+
    "\3\4\1\0\1\4\1\0\24\4\1\0\54\4\1\0\46\4\1\0"+
    "\5\4\4\0\202\4\1\0\4\5\3\0\105\4\1\0\46\4\2\0"+
    "\2\4\6\0\20\4\41\0\46\4\2\0\1\4\7\0\47\4\11\0"+
    "\21\5\1\0\27\5\1\0\3\5\1\0\1\5\1\0\2\5\1\0"+
    "\1\5\13\0\33\4\5\0\3\4\15\0\4\5\14\0\6\5\13\0"+
    "\32\4\5\0\13\4\16\5\7\0\12\5\4\0\2\4\1\5\143\4"+
    "\1\0\1\4\10\5\1\0\6\5\2\4\2\5\1\0\4\5\2\4"+
    "\12\5\3\4\2\0\1\4\17\0\1\5\1\4\1\5\36\4\33\5"+
    "\2\0\3\4\60\0\46\4\13\5\1\4\u014f\0\3\5\66\4\2\0"+
    "\1\5\1\4\20\5\2\0\1\4\4\5\3\0\12\4\2\5\2\0"+
    "\12\5\21\0\3\5\1\0\10\4\2\0\2\4\2\0\26\4\1\0"+
    "\7\4\1\0\1\4\3\0\4\4\2\0\1\5\1\4\7\5\2\0"+
    "\2\5\2\0\3\5\11\0\1\5\4\0\2\4\1\0\3\4\2\5"+
    "\2\0\12\5\4\4\15\0\3\5\1\0\6\4\4\0\2\4\2\0"+
    "\26\4\1\0\7\4\1\0\2\4\1\0\2\4\1\0\2\4\2\0"+
    "\1\5\1\0\5\5\4\0\2\5\2\0\3\5\13\0\4\4\1\0"+
    "\1\4\7\0\14\5\3\4\14\0\3\5\1\0\11\4\1\0\3\4"+
    "\1\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4\2\0\1\5"+
    "\1\4\10\5\1\0\3\5\1\0\3\5\2\0\1\4\17\0\2\4"+
    "\2\5\2\0\12\5\1\0\1\4\17\0\3\5\1\0\10\4\2\0"+
    "\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4\2\0"+
    "\1\5\1\4\6\5\3\0\2\5\2\0\3\5\10\0\2\5\4\0"+
    "\2\4\1\0\3\4\4\0\12\5\1\0\1\4\20\0\1\5\1\4"+
    "\1\0\6\4\3\0\3\4\1\0\4\4\3\0\2\4\1\0\1\4"+
    "\1\0\2\4\3\0\2\4\3\0\3\4\3\0\10\4\1\0\3\4"+
    "\4\0\5\5\3\0\3\5\1\0\4\5\11\0\1\5\17\0\11\5"+
    "\11\0\1\4\7\0\3\5\1\0\10\4\1\0\3\4\1\0\27\4"+
    "\1\0\12\4\1\0\5\4\4\0\7\5\1\0\3\5\1\0\4\5"+
    "\7\0\2\5\11\0\2\4\4\0\12\5\22\0\2\5\1\0\10\4"+
    "\1\0\3\4\1\0\27\4\1\0\12\4\1\0\5\4\2\0\1\5"+
    "\1\4\7\5\1\0\3\5\1\0\4\5\7\0\2\5\7\0\1\4"+
    "\1\0\2\4\4\0\12\5\22\0\2\5\1\0\10\4\1\0\3\4"+
    "\1\0\27\4\1\0\20\4\4\0\6\5\2\0\3\5\1\0\4\5"+
    "\11\0\1\5\10\0\2\4\4\0\12\5\22\0\2\5\1\0\22\4"+
    "\3\0\30\4\1\0\11\4\1\0\1\4\2\0\7\4\3\0\1\5"+
    "\4\0\6\5\1\0\1\5\1\0\10\5\22\0\2\5\15\0\60\4"+
    "\1\5\2\4\7\5\4\0\10\4\10\5\1\0\12\5\47\0\2\4"+
    "\1\0\1\4\2\0\2\4\1\0\1\4\2\0\1\4\6\0\4\4"+
    "\1\0\7\4\1\0\3\4\1\0\1\4\1\0\1\4\2\0\2\4"+
    "\1\0\4\4\1\5\2\4\6\5\1\0\2\5\1\4\2\0\5\4"+
    "\1\0\1\4\1\0\6\5\2\0\12\5\2\0\2\4\42\0\1\4"+
    "\27\0\2\5\6\0\12\5\13\0\1\5\1\0\1\5\1\0\1\5"+
    "\4\0\2\5\10\4\1\0\42\4\6\0\24\5\1\0\2\5\4\4"+
    "\4\0\10\5\1\0\44\5\11\0\1\5\71\0\42\4\1\0\5\4"+
    "\1\0\2\4\1\0\7\5\3\0\4\5\6\0\12\5\6\0\6\4"+
    "\4\5\106\0\46\4\12\0\51\4\7\0\132\4\5\0\104\4\5\0"+
    "\122\4\6\0\7\4\1\0\77\4\1\0\1\4\1\0\4\4\2\0"+
    "\7\4\1\0\1\4\1\0\4\4\2\0\47\4\1\0\1\4\1\0"+
    "\4\4\2\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0"+
    "\1\4\1\0\4\4\2\0\7\4\1\0\7\4\1\0\27\4\1\0"+
    "\37\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0\47\4\1\0"+
    "\23\4\16\0\11\5\56\0\125\4\14\0\u026c\4\2\0\10\4\12\0"+
    "\32\4\5\0\113\4\3\0\3\4\17\0\15\4\1\0\4\4\3\5"+
    "\13\0\22\4\3\5\13\0\22\4\2\5\14\0\15\4\1\0\3\4"+
    "\1\0\2\5\14\0\64\4\40\5\3\0\1\4\3\0\2\4\1\5"+
    "\2\0\12\5\41\0\3\5\2\0\12\5\6\0\130\4\10\0\51\4"+
    "\1\5\126\0\35\4\3\0\14\5\4\0\14\5\12\0\12\5\36\4"+
    "\2\0\5\4\u038b\0\154\4\224\0\234\4\4\0\132\4\6\0\26\4"+
    "\2\0\6\4\2\0\46\4\2\0\6\4\2\0\10\4\1\0\1\4"+
    "\1\0\1\4\1\0\1\4\1\0\37\4\2\0\65\4\1\0\7\4"+
    "\1\0\1\4\3\0\3\4\1\0\7\4\3\0\4\4\2\0\6\4"+
    "\4\0\15\4\5\0\3\4\1\0\7\4\17\0\4\5\32\0\5\5"+
    "\20\0\2\4\23\0\1\4\13\0\4\5\6\0\6\5\1\0\1\4"+
    "\15\0\1\4\40\0\22\4\36\0\15\5\4\0\1\5\3\0\6\5"+
    "\27\0\1\4\4\0\1\4\2\0\12\4\1\0\1\4\3\0\5\4"+
    "\6\0\1\4\1\0\1\4\1\0\1\4\1\0\4\4\1\0\3\4"+
    "\1\0\7\4\3\0\3\4\5\0\5\4\26\0\44\4\u0e81\0\3\4"+
    "\31\0\11\4\6\5\1\0\5\4\2\0\5\4\4\0\126\4\2\0"+
    "\2\5\2\0\3\4\1\0\137\4\5\0\50\4\4\0\136\4\21\0"+
    "\30\4\70\0\20\4\u0200\0\u19b6\4\112\0\u51a6\4\132\0\u048d\4\u0773\0"+
    "\u2ba4\4\u215c\0\u012e\4\2\0\73\4\225\0\7\4\14\0\5\4\5\0"+
    "\1\4\1\5\12\4\1\0\15\4\1\0\5\4\1\0\1\4\1\0"+
    "\2\4\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4\2\0"+
    "\66\4\50\0\15\4\3\0\20\5\20\0\4\5\17\0\2\4\30\0"+
    "\3\4\31\0\1\4\6\0\5\4\1\0\207\4\2\0\1\5\4\0"+
    "\1\4\13\0\12\5\7\0\32\4\4\0\1\4\1\0\32\4\12\0"+
    "\132\4\3\0\6\4\2\0\6\4\2\0\6\4\2\0\3\4\3\0"+
    "\2\4\3\0\2\4\22\0\3\5\4\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    57,   114,   171,   228,   285,   285,   342,   399,   456, 
      513,   570,   627,   684,   741,   798,   285,   285,   855,   912, 
      969,   285,   285,   285,   285,   285,   285,   285,   285,  1026, 
     1083,  1140,  1197,   285,   285,   285,  1254,  1311,  1368,  1425, 
     1482,   285,  1539,  1596,   285,  1653,   285,  1710,  1767,   285, 
     1824,   285,  1881,  1938,  1995,  2052,  2109,  2166,   285,   285, 
      285,   285,   285,   285,   285,   285,   285,   285,   285,   285, 
     2223,   285,   285,   285,   285,   285,  2280,  2337,  2394,   285, 
      285,  2451,   285,  2508,   285,   285,   285,   285,   285,   285, 
      285,   285,   285,  2565,  2622,   285,   285,   285,   285,   285, 
      285,   285,   285,   285,   285,   285,   285,   285,   285,   285, 
      285,   285,  2679,  2736,  2793,   285,   285,   285,   285,   285, 
      285,  2850,  2907,  2964,   285,  3021,   285,   285,   285,   399, 
     3078,   399,   285,   399
  };

  /** 
   * The packed transition table of the DFA (part 0)
   */
  final private static String yy_packed0 = 
    "\1\6\1\7\1\10\1\7\1\11\1\6\1\12\1\13"+
    "\2\11\1\13\1\14\1\11\1\15\1\6\1\13\1\16"+
    "\10\11\1\17\1\20\1\21\1\22\1\23\2\11\1\24"+
    "\2\11\1\25\1\26\1\27\1\30\1\31\1\32\1\33"+
    "\1\34\1\35\1\36\1\37\1\40\1\41\1\42\1\43"+
    "\1\44\1\45\1\46\1\47\1\50\2\11\1\51\1\52"+
    "\1\53\13\51\1\54\15\51\1\55\34\51\1\56\1\57"+
    "\1\60\13\56\1\61\14\56\1\62\35\56\32\7\1\63"+
    "\37\7\1\64\1\65\66\7\72\0\1\7\73\0\7\11"+
    "\1\0\1\11\2\0\1\11\1\0\10\11\4\0\7\11"+
    "\23\0\2\11\6\0\1\66\1\67\1\70\1\0\1\66"+
    "\1\71\1\72\2\0\1\66\2\0\1\72\2\0\1\73"+
    "\1\0\1\74\1\75\7\0\1\74\1\0\1\75\24\0"+
    "\1\73\7\0\2\13\2\0\1\13\1\71\1\72\2\0"+
    "\1\13\2\0\1\72\2\0\1\73\1\0\1\74\1\75"+
    "\7\0\1\74\1\0\1\75\24\0\1\73\7\0\2\71"+
    "\2\0\1\71\4\0\1\71\66\0\1\76\36\0\1\77"+
    "\35\0\1\100\1\101\1\102\1\103\1\104\1\105\1\106"+
    "\1\107\23\0\1\110\45\0\1\111\1\112\21\0\1\113"+
    "\70\0\1\114\20\0\7\11\1\0\1\11\2\0\1\11"+
    "\1\0\10\11\4\0\1\11\1\115\5\11\23\0\2\11"+
    "\4\0\7\11\1\0\1\11\2\0\1\11\1\0\10\11"+
    "\4\0\4\11\1\116\2\11\23\0\2\11\4\0\7\11"+
    "\1\0\1\11\2\0\1\11\1\0\10\11\4\0\2\11"+
    "\1\117\4\11\23\0\2\11\54\0\1\120\70\0\1\121"+
    "\1\122\67\0\1\123\1\0\1\124\66\0\1\125\70\0"+
    "\1\126\6\0\1\127\61\0\1\130\7\0\1\131\60\0"+
    "\1\132\10\0\1\133\57\0\1\134\14\0\1\51\2\0"+
    "\13\51\1\0\15\51\1\0\34\51\1\0\1\52\67\0"+
    "\1\135\1\0\4\135\1\136\3\135\1\137\3\135\1\140"+
    "\1\136\13\135\1\141\1\142\1\143\1\144\1\135\1\145"+
    "\2\135\1\146\24\135\1\147\1\56\2\0\13\56\1\0"+
    "\14\56\1\0\35\56\1\0\1\57\67\0\1\135\1\0"+
    "\4\135\1\136\3\135\1\137\3\135\1\150\1\136\13\135"+
    "\1\151\1\152\1\153\1\154\1\135\1\155\2\135\1\156"+
    "\24\135\1\157\31\0\1\64\40\0\1\64\75\0\1\66"+
    "\1\67\2\0\1\66\1\71\1\72\2\0\1\66\2\0"+
    "\1\72\5\0\1\160\11\0\1\160\34\0\2\67\2\0"+
    "\1\67\1\71\1\72\2\0\1\67\2\0\1\72\54\0"+
    "\2\161\1\0\2\161\1\0\1\161\2\0\1\161\2\0"+
    "\1\161\2\0\1\161\1\0\1\161\10\0\2\161\25\0"+
    "\2\161\6\0\2\71\2\0\1\71\1\0\1\72\2\0"+
    "\1\71\2\0\1\72\2\0\1\73\1\0\1\74\10\0"+
    "\1\74\26\0\1\73\7\0\2\162\2\0\1\162\2\0"+
    "\1\163\1\0\1\162\45\0\1\163\25\0\1\164\1\165"+
    "\1\166\1\167\1\170\1\171\45\0\7\11\1\0\1\11"+
    "\2\0\1\11\1\0\10\11\4\0\2\11\1\172\4\11"+
    "\23\0\2\11\4\0\7\11\1\0\1\11\2\0\1\11"+
    "\1\0\10\11\4\0\5\11\1\173\1\11\23\0\2\11"+
    "\4\0\7\11\1\0\1\11\2\0\1\11\1\0\10\11"+
    "\4\0\5\11\1\174\1\11\23\0\2\11\54\0\1\175"+
    "\1\176\67\0\1\177\22\0\1\137\3\0\1\137\4\0"+
    "\1\137\57\0\1\200\3\0\1\200\4\0\1\200\57\0"+
    "\2\161\1\0\2\161\1\0\1\161\2\0\1\161\2\0"+
    "\1\161\2\0\1\161\1\0\1\161\1\201\7\0\2\161"+
    "\1\201\24\0\2\161\6\0\2\162\2\0\1\162\4\0"+
    "\1\162\5\0\1\73\1\0\1\74\10\0\1\74\26\0"+
    "\1\73\7\0\2\162\2\0\1\162\4\0\1\162\55\0"+
    "\7\11\1\0\1\202\2\0\1\11\1\0\10\11\4\0"+
    "\7\11\23\0\2\11\4\0\7\11\1\0\1\11\2\0"+
    "\1\11\1\0\1\203\7\11\4\0\7\11\23\0\2\11"+
    "\4\0\7\11\1\0\1\11\2\0\1\11\1\0\10\11"+
    "\4\0\5\11\1\204\1\11\23\0\2\11\54\0\1\205"+
    "\20\0\7\11\1\0\1\206\2\0\1\11\1\0\10\11"+
    "\4\0\7\11\23\0\2\11";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack();


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     0,  0,  0,  0,  0,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     9,  9,  1,  1,  1,  9,  9,  9,  9,  9,  9,  9,  9,  1,  1,  1, 
     1,  9,  9,  9,  1,  1,  1,  1,  1,  9,  1,  1,  9,  1,  9,  1, 
     1,  9,  1,  9,  1,  1,  0,  0,  1,  0,  9,  9,  9,  9,  9,  9, 
     9,  9,  9,  9,  9,  9,  0,  9,  9,  9,  9,  9,  1,  1,  1,  9, 
     9,  1,  9,  1,  9,  9,  9,  9,  9,  9,  9,  9,  9,  1,  1,  9, 
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9, 
     1,  1,  0,  9,  9,  9,  9,  9,  9,  1,  1,  1,  9,  1,  9,  9, 
     9,  1,  1,  1,  9,  1
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[YY_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL = true;

  /** yy_atEOF == true <=> the scanner is at the EOF */
  private boolean yy_atEOF;

  /* user code: */
    StringBuffer sb = new StringBuffer();
    String file;
    String path;
    HashMap keywords;
    LinkedList subst;

    public Lexer_c(String s, Position pos, List subst) {
        this(new EscapedUnicodeReader(new StringReader(s)));
        if (pos != null) {
            this.file = pos.toString() + ": quasiquote(" + stringSubst(s ,subst) + ")";
            this.path = pos.path();
        }
        else {
            this.file = "quasiquote(" + stringSubst(s ,subst) + ")";
            this.path = null;
        }

        this.subst = new LinkedList(subst);
        this.keywords = new HashMap();
        init_keywords();
    }

    private String stringSubst(String s, List subst) {
        StringBuffer sb = new StringBuffer();
        Iterator j = subst.iterator();
        for (int i = 0; i < s.length(); i++) {
            if (s.charAt(i) == '%' && j.hasNext()) {
                i++;
                sb.append(j.next());
            }
            else {
                sb.append(s.charAt(i));
            }
        }
        return sb.toString();
    }

    private void error(String msg, Position pos) {
       throw new InternalCompilerError(msg, pos);
    }

    protected String substKind(char kind) { return substKind(kind, false); }

    protected String substKind(char kind, boolean list) {
        switch (kind) {
            case 's': return "String";
            case 'E': return "Expr";
            case 'S': return "Stmt";
            case 'T': return "TypeNode";
            case 'D': return "ClassDecl";
            case 'M': return "ClassMember";
            case 'F': return "Formal";
            default:
                error("Bad quasiquoting substitution type: \"" + kind + "\".",
                      pos());
                return null;
        }
    }

    public Token substList(char kind) {
        if (subst.isEmpty()) {
            error("Not enough arguments to quasiquoter.", pos());
        }

        Object o = subst.removeFirst();
        String expected = substKind(kind, true);

        if (o instanceof List) {
            List l = (List) o;

            for (Iterator i = l.iterator(); i.hasNext(); ) {
                Object p = i.next();

                switch (kind) {
                    case 'E':
                        if (p instanceof Expr) continue;
                        break;
                    case 'S':
                        if (p instanceof Stmt) continue;
                        break;
                    case 'T':
                        if (p instanceof TypeNode) continue;
                        break;
                    case 'D':
                        if (p instanceof ClassDecl) continue;
                        break;
                    case 'M':
                        if (p instanceof ClassMember) continue;
                        break;
                    case 'F':
                        if (p instanceof Formal) continue;
                        break;
                    default:
                        break;
                }

                error("Bad quasiquoting substitution: expected List of " + expected + ".", pos());
            }

            return new QQListToken(pos(), l, sym.COMMA_LIST);
        }
        else {
            error("Bad quasiquoting substitution: expected List of " + expected + ".", pos());
            return null;
        }
    }

    public Token subst(char kind) {
        if (subst.isEmpty()) {
            error("Not enough arguments to quasiquoter.", pos());
        }               
                    
        Object o = subst.removeFirst();
        String expected = substKind(kind);
                    
        switch (kind) { 
            case 's': { 
                if (o instanceof String) {
                    String s = (String) o;
                    return new Identifier(pos(), s, sym.IDENTIFIER);
                }   
                break;  
            }           
            case 'E': {
                if (o instanceof Expr) { 
                    Expr e = (Expr) o;
                    return new QQNodeToken(pos(), e, sym.COMMA_EXPR);
                }       
                break;
            }
            case 'S': {                if (o instanceof Stmt) {
                    Stmt s = (Stmt) o;
                    return new QQNodeToken(pos(), s, sym.COMMA_STMT);
                }
                break;
            }
            case 'T': {                if (o instanceof TypeNode) {
                    TypeNode t = (TypeNode) o;
                    return new QQNodeToken(pos(), t, sym.COMMA_TYPE);
                }
                break;
            }
            case 'D': {
                if (o instanceof ClassDecl) {
                    ClassDecl d = (ClassDecl) o;
                    return new QQNodeToken(pos(), d, sym.COMMA_DECL);
                }
                break;
            }
            case 'M': {
                if (o instanceof ClassMember) {
                    ClassMember m = (ClassMember) o;
                    return new QQNodeToken(pos(), m, sym.COMMA_MEMB);
                }
                break;
            }
            case 'F': {
                if (o instanceof Formal) {
                    Formal f = (Formal) o;
                    return new QQNodeToken(pos(), f, sym.COMMA_FORM);
                }
                break;
            }
            default:
                // error: should be caught in substKind
                return null;
        }

        error("Bad quasiquoting substitution: expected " + expected + ".", pos());
        return null;
    }

    protected void init_keywords() {
        keywords.put("abstract",      new Integer(sym.ABSTRACT));
        keywords.put("assert",        new Integer(sym.ASSERT));
        keywords.put("boolean",       new Integer(sym.BOOLEAN));
        keywords.put("break",         new Integer(sym.BREAK));
        keywords.put("byte",          new Integer(sym.BYTE));
        keywords.put("case",          new Integer(sym.CASE));
        keywords.put("catch",         new Integer(sym.CATCH));
        keywords.put("char",          new Integer(sym.CHAR));
        keywords.put("class",         new Integer(sym.CLASS));
        keywords.put("const",         new Integer(sym.CONST));
        keywords.put("continue",      new Integer(sym.CONTINUE));
        keywords.put("default",       new Integer(sym.DEFAULT));
        keywords.put("do",            new Integer(sym.DO));
        keywords.put("double",        new Integer(sym.DOUBLE));
        keywords.put("else",          new Integer(sym.ELSE));
        keywords.put("extends",       new Integer(sym.EXTENDS));
        keywords.put("final",         new Integer(sym.FINAL));
        keywords.put("finally",       new Integer(sym.FINALLY));
        keywords.put("float",         new Integer(sym.FLOAT));
        keywords.put("for",           new Integer(sym.FOR));
        keywords.put("goto",          new Integer(sym.GOTO));
        keywords.put("if",            new Integer(sym.IF));
        keywords.put("implements",    new Integer(sym.IMPLEMENTS));
        keywords.put("import",        new Integer(sym.IMPORT));
        keywords.put("instanceof",    new Integer(sym.INSTANCEOF));
        keywords.put("int",           new Integer(sym.INT));
        keywords.put("interface",     new Integer(sym.INTERFACE));
        keywords.put("long",          new Integer(sym.LONG));
        keywords.put("native",        new Integer(sym.NATIVE));
        keywords.put("new",           new Integer(sym.NEW));
        keywords.put("package",       new Integer(sym.PACKAGE));
        keywords.put("private",       new Integer(sym.PRIVATE));
        keywords.put("protected",     new Integer(sym.PROTECTED));
        keywords.put("public",        new Integer(sym.PUBLIC));
        keywords.put("return",        new Integer(sym.RETURN));
        keywords.put("short",         new Integer(sym.SHORT));
        keywords.put("static",        new Integer(sym.STATIC));
        keywords.put("strictfp",      new Integer(sym.STRICTFP));
        keywords.put("super",         new Integer(sym.SUPER));
        keywords.put("switch",        new Integer(sym.SWITCH));
        keywords.put("synchronized",  new Integer(sym.SYNCHRONIZED));
        keywords.put("this",          new Integer(sym.THIS));
        keywords.put("throw",         new Integer(sym.THROW));
        keywords.put("throws",        new Integer(sym.THROWS));
        keywords.put("transient",     new Integer(sym.TRANSIENT));
        keywords.put("try",           new Integer(sym.TRY));
        keywords.put("void",          new Integer(sym.VOID));
        keywords.put("volatile",      new Integer(sym.VOLATILE));
        keywords.put("while",         new Integer(sym.WHILE));
    }

    public String file() {
        return file;
    }

    public String path() {
        return path;
    }

    private Position pos() {
        return new Position(path, file, yyline+1, yycolumn, yyline+1,
                            yycolumn + yytext().length());
    }

    private Position pos(int len) {
        return new Position(path, file, yyline+1, yycolumn-len-1, yyline+1,
                            yycolumn+1);
    }

    private Token key(int symbol) {
        return new Keyword(pos(), yytext(), symbol);
    }

    private Token op(int symbol) {
        return new Operator(pos(), yytext(), symbol);
    }

    private Token id() {
        return new Identifier(pos(), yytext(), sym.IDENTIFIER);
    }

    private Token int_lit(String s, int radix) {
        BigInteger x = new BigInteger(s, radix);
        boolean boundary = (radix == 10 && s.equals("2147483648"));
        int bits = radix == 10 ? 31 : 32;
        if (x.bitLength() > bits && ! boundary) {
            error("Integer literal \"" + yytext() + "\" out of range.", pos());
            return null;
        }
        return new IntegerLiteral(pos(), x.intValue(),
                boundary ? sym.INTEGER_LITERAL_BD : sym.INTEGER_LITERAL);
    }

    private Token long_lit(String s, int radix) {
        BigInteger x = new BigInteger(s, radix);
        boolean boundary = (radix == 10 && s.equals("9223372036854775808"));
        int bits = radix == 10 ? 63 : 64;
        if (x.bitLength() > bits && ! boundary) {
            error("Long literal \"" + yytext() + "\" out of range.", pos());
            return null;
        }
        return new LongLiteral(pos(), x.longValue(),
                boundary ? sym.LONG_LITERAL_BD : sym.LONG_LITERAL);
    }

    private Token float_lit(String s) {
        try {
            Float x = Float.valueOf(s);
	    boolean zero = true;
	    for (int i = 0; i < s.length(); i++) {
		if ('1' <= s.charAt(i) && s.charAt(i) <= '9') {
		    zero = false;
		    break;
		}
	    }
	    if (x.isInfinite() || x.isNaN() || (x.floatValue() == 0 && ! zero)) {
		error("Illegal float literal \"" + yytext() + "\"", pos());
		return null;
	    }
            return new FloatLiteral(pos(), x.floatValue(), sym.FLOAT_LITERAL);
        }
        catch (NumberFormatException e) {
            error("Illegal float literal \"" + yytext() + "\"", pos());
            return null;
        }
    }

    private Token double_lit(String s) {
        try {
            Double x = Double.valueOf(s);
	    boolean zero = true;
	    for (int i = 0; i < s.length(); i++) {
		if ('1' <= s.charAt(i) && s.charAt(i) <= '9') {
		    zero = false;
		    break;
		}
	    }
	    if (x.isInfinite() || x.isNaN() || (x.floatValue() == 0 && ! zero)) {
		error("Illegal double literal \"" + yytext() + "\"", pos());
		return null;
	    }
            return new DoubleLiteral(pos(), x.doubleValue(), sym.DOUBLE_LITERAL);
        }
        catch (NumberFormatException e) {
            error("Illegal double literal \"" + yytext() + "\"", pos());
            return null;
        }
    }

    private Token char_lit(String s) {
        if (s.length() == 1) {
            char x = s.charAt(0);
            return new CharacterLiteral(pos(), x, sym.CHARACTER_LITERAL);
        }
        else {
            error("Illegal character literal \'" + s + "\'", pos(s.length()));
            return null;
        }
    }

    private Token boolean_lit(boolean x) {
        return new BooleanLiteral(pos(), x, sym.BOOLEAN_LITERAL);
    }

    private Token null_lit() {
        return new NullLiteral(pos(), sym.NULL_LITERAL);
    }

    private Token string_lit() {
        return new StringLiteral(pos(sb.length()), sb.toString(),
                                 sym.STRING_LITERAL);
    }

    private String chop(int i, int j) {
        return yytext().substring(i,yylength()-j);
    }

    private String chop(int j) {
        return chop(0, j);
    }

    private String chop() {
        return chop(0, 1);
    }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Lexer_c(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Lexer_c(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the split, compressed DFA transition table.
   *
   * @return the unpacked transition table
   */
  private static int [] yy_unpack() {
    int [] trans = new int[3135];
    int offset = 0;
    offset = yy_unpack(yy_packed0, offset, trans);
    return trans;
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the index of the last entry
   */
  private static int yy_unpack(String packed, int offset, int [] trans) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1772) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   IOException  if any I/O-Error occurs
   */
  private boolean yy_refill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if (numRead < 0) {
      return true;
    }
    else {
      yy_endRead+= numRead;  
      return false;
    }
  }


  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */

    if (yy_reader != null)
      yy_reader.close();
  }


  /**
   * Closes the current stream, and resets the
   * scanner to read from a new input stream.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>YY_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  final public void yyreset(java.io.Reader reader) throws java.io.IOException {
    yyclose();
    yy_reader = reader;
    yy_atBOL  = true;
    yy_atEOF  = false;
    yy_endRead = yy_startRead = 0;
    yy_currentPos = yy_markedPos = yy_pushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    yy_lexical_state = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  final public char yycharat(int pos) {
    return yy_buffer[yy_startRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    String message;
    try {
      message = YY_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = YY_ERROR_MSG[YY_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number)  {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public Token nextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;

    // cached fields:
    int yy_currentPos_l;
    int yy_startRead_l;
    int yy_markedPos_l;
    int yy_endRead_l = yy_endRead;
    char [] yy_buffer_l = yy_buffer;
    char [] yycmap_l = yycmap;

    int [] yytrans_l = yytrans;
    int [] yy_rowMap_l = yy_rowMap;
    byte [] yy_attr_l = YY_ATTRIBUTE;

    while (true) {
      yy_markedPos_l = yy_markedPos;

      boolean yy_r = false;
      for (yy_currentPos_l = yy_startRead; yy_currentPos_l < yy_markedPos_l;
                                                             yy_currentPos_l++) {
        switch (yy_buffer_l[yy_currentPos_l]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          yy_r = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          yy_r = true;
          break;
        case '\n':
          if (yy_r)
            yy_r = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          yy_r = false;
          yycolumn++;
        }
      }

      if (yy_r) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean yy_peek;
        if (yy_markedPos_l < yy_endRead_l)
          yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        else if (yy_atEOF)
          yy_peek = false;
        else {
          boolean eof = yy_refill();
          yy_markedPos_l = yy_markedPos;
          yy_buffer_l = yy_buffer;
          if (eof) 
            yy_peek = false;
          else 
            yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        }
        if (yy_peek) yyline--;
      }
      yy_action = -1;

      yy_startRead_l = yy_currentPos_l = yy_currentPos = 
                       yy_startRead = yy_markedPos_l;

      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {

          if (yy_currentPos_l < yy_endRead_l)
            yy_input = yy_buffer_l[yy_currentPos_l++];
          else if (yy_atEOF) {
            yy_input = YYEOF;
            break yy_forAction;
          }
          else {
            // store back cached positions
            yy_currentPos  = yy_currentPos_l;
            yy_markedPos   = yy_markedPos_l;
            boolean eof = yy_refill();
            // get translated positions and possibly new buffer
            yy_currentPos_l  = yy_currentPos;
            yy_markedPos_l   = yy_markedPos;
            yy_buffer_l      = yy_buffer;
            yy_endRead_l     = yy_endRead;
            if (eof) {
              yy_input = YYEOF;
              break yy_forAction;
            }
            else {
              yy_input = yy_buffer_l[yy_currentPos_l++];
            }
          }
          int yy_next = yytrans_l[ yy_rowMap_l[yy_state] + yycmap_l[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = yy_attr_l[yy_state];
          if ( (yy_attributes & 1) == 1 ) {
            yy_action = yy_state; 
            yy_markedPos_l = yy_currentPos_l; 
            if ( (yy_attributes & 8) == 8 ) break yy_forAction;
          }

        }
      }

      // store back cached position
      yy_markedPos = yy_markedPos_l;

      switch (yy_action) {

        case 45: 
          {  sb.append( yytext() );  }
        case 135: break;
        case 40: 
          {  sb.append( yytext() );  }
        case 136: break;
        case 120: 
          {  return substList('F');  }
        case 137: break;
        case 119: 
          {  return substList('M');  }
        case 138: break;
        case 118: 
          {  return substList('D');  }
        case 139: break;
        case 117: 
          {  return substList('T');  }
        case 140: break;
        case 116: 
          {  return substList('S');  }
        case 141: break;
        case 115: 
          {  return substList('E');  }
        case 142: break;
        case 46: 
        case 47: 
          {  yybegin(YYINITIAL);
                                  error("Unclosed character literal",
                                             pos(sb.length()));  }
        case 143: break;
        case 49: 
          {  yybegin(YYINITIAL);
                                   Token t = char_lit(sb.toString());
                                   if (t != null) return t;  }
        case 144: break;
        case 6: 
        case 7: 
          {  /* ignore */  }
        case 145: break;
        case 50: 
          {  /* ignore */  }
        case 146: break;
        case 133: 
          {  return boolean_lit(false);  }
        case 147: break;
        case 129: 
          {  return boolean_lit(true);   }
        case 148: break;
        case 28: 
          {  return op(sym.COMMA);      }
        case 149: break;
        case 27: 
          {  return op(sym.SEMICOLON);  }
        case 150: break;
        case 11: 
          {  return op(sym.DOT);        }
        case 151: break;
        case 21: 
          {  return op(sym.LPAREN);     }
        case 152: break;
        case 22: 
          {  return op(sym.RPAREN);     }
        case 153: break;
        case 23: 
          {  return op(sym.LBRACE);     }
        case 154: break;
        case 24: 
          {  return op(sym.RBRACE);     }
        case 155: break;
        case 25: 
          {  return op(sym.LBRACK);     }
        case 156: break;
        case 26: 
          {  return op(sym.RBRACK);     }
        case 157: break;
        case 131: 
          {  return null_lit();  }
        case 158: break;
        case 41: 
        case 42: 
          {  yybegin(YYINITIAL);
                                   error("Unclosed string literal",
                                              pos(sb.length()));  }
        case 159: break;
        case 110: 
          {  sb.append('\b');  }
        case 160: break;
        case 109: 
          {  sb.append('\n');  }
        case 161: break;
        case 108: 
          {  sb.append('\f');  }
        case 162: break;
        case 107: 
          {  sb.append('\r');  }
        case 163: break;
        case 106: 
          {  sb.append('\t');  }
        case 164: break;
        case 105: 
          {  sb.append('\"');  }
        case 165: break;
        case 104: 
          {  sb.append('\'');  }
        case 166: break;
        case 103: 
          {  sb.append('\\');  }
        case 167: break;
        case 63: 
          {  return subst('s');  }
        case 168: break;
        case 64: 
          {  return subst('E');  }
        case 169: break;
        case 65: 
          {  return subst('S');  }
        case 170: break;
        case 66: 
          {  return subst('T');  }
        case 171: break;
        case 67: 
          {  return subst('D');  }
        case 172: break;
        case 68: 
          {  return subst('M');  }
        case 173: break;
        case 69: 
          {  return subst('F');  }
        case 174: break;
        case 93: 
        case 94: 
        case 127: 
          {  try {
                                       int x = Integer.parseInt(chop(1,0), 8);
                                       sb.append((char) x);
                                   }
                                   catch (NumberFormatException e) {
                                       error("Illegal octal escape \""
                                                  + yytext() + "\"", pos());
                                   }
                                  }
        case 175: break;
        case 72: 
          {  yybegin(END_OF_LINE_COMMENT);  }
        case 176: break;
        case 51: 
        case 52: 
          {  yybegin(YYINITIAL);  }
        case 177: break;
        case 73: 
          {  yybegin(TRADITIONAL_COMMENT);  }
        case 178: break;
        case 8: 
        case 18: 
        case 19: 
        case 20: 
        case 76: 
        case 77: 
        case 78: 
        case 121: 
        case 122: 
        case 123: 
        case 130: 
          {  Integer i = (Integer) keywords.get(yytext());
                    if (i == null) return id();
                    else return key(i.intValue());  }
        case 179: break;
        case 16: 
          {  yybegin(CHARACTER); sb.setLength(0);  }
        case 180: break;
        case 132: 
          {  return op(sym.URSHIFTEQ);   }
        case 181: break;
        case 126: 
          {  return op(sym.LSHIFTEQ);    }
        case 182: break;
        case 125: 
          {  return op(sym.URSHIFT);     }
        case 183: break;
        case 124: 
          {  return op(sym.RSHIFTEQ);    }
        case 184: break;
        case 39: 
          {  return op(sym.XOR);         }
        case 185: break;
        case 38: 
          {  return op(sym.PLUS);        }
        case 186: break;
        case 37: 
          {  return op(sym.OR);          }
        case 187: break;
        case 36: 
          {  return op(sym.AND);         }
        case 188: break;
        case 35: 
          {  return op(sym.COLON);       }
        case 189: break;
        case 34: 
          {  return op(sym.QUESTION);    }
        case 190: break;
        case 33: 
          {  return op(sym.COMP);        }
        case 191: break;
        case 32: 
          {  return op(sym.NOT);         }
        case 192: break;
        case 31: 
          {  return op(sym.LT);          }
        case 193: break;
        case 30: 
          {  return op(sym.GT);          }
        case 194: break;
        case 29: 
          {  return op(sym.EQ);          }
        case 195: break;
        case 14: 
          {  return op(sym.DIV);         }
        case 196: break;
        case 13: 
          {  return op(sym.MOD);         }
        case 197: break;
        case 12: 
          {  return op(sym.MINUS);       }
        case 198: break;
        case 15: 
          {  return op(sym.MULT);        }
        case 199: break;
        case 61: 
          {  return op(sym.MINUSMINUS);  }
        case 200: break;
        case 62: 
          {  return op(sym.MINUSEQ);     }
        case 201: break;
        case 71: 
          {  return op(sym.MODEQ);       }
        case 202: break;
        case 74: 
          {  return op(sym.DIVEQ);       }
        case 203: break;
        case 75: 
          {  return op(sym.MULTEQ);      }
        case 204: break;
        case 79: 
          {  return op(sym.EQEQ);        }
        case 205: break;
        case 80: 
          {  return op(sym.GTEQ);        }
        case 206: break;
        case 81: 
          {  return op(sym.RSHIFT);      }
        case 207: break;
        case 82: 
          {  return op(sym.LTEQ);        }
        case 208: break;
        case 83: 
          {  return op(sym.LSHIFT);      }
        case 209: break;
        case 84: 
          {  return op(sym.NOTEQ);       }
        case 210: break;
        case 85: 
          {  return op(sym.ANDEQ);       }
        case 211: break;
        case 86: 
          {  return op(sym.ANDAND);      }
        case 212: break;
        case 87: 
          {  return op(sym.OREQ);        }
        case 213: break;
        case 88: 
          {  return op(sym.OROR);        }
        case 214: break;
        case 89: 
          {  return op(sym.PLUSEQ);      }
        case 215: break;
        case 90: 
          {  return op(sym.PLUSPLUS);    }
        case 216: break;
        case 91: 
          {  return op(sym.XOREQ);       }
        case 217: break;
        case 102: 
          {  sb.append( '\b' );  }
        case 218: break;
        case 101: 
          {  sb.append( '\n' );  }
        case 219: break;
        case 100: 
          {  sb.append( '\f' );  }
        case 220: break;
        case 99: 
          {  sb.append( '\r' );  }
        case 221: break;
        case 98: 
          {  sb.append( '\t' );  }
        case 222: break;
        case 97: 
          {  sb.append( '\"' );  }
        case 223: break;
        case 96: 
          {  sb.append( '\'' );  }
        case 224: break;
        case 95: 
          {  sb.append( '\\' );  }
        case 225: break;
        case 128: 
          {  Token t = long_lit(chop(2,1), 16);
                                   if (t != null) return t;  }
        case 226: break;
        case 112: 
          {  Token t = int_lit(chop(2,0), 16);
                                   if (t != null) return t;  }
        case 227: break;
        case 111: 
          {  Token t = long_lit(chop(), 8);
                                   if (t != null) return t;  }
        case 228: break;
        case 44: 
          {  yybegin(YYINITIAL);
                                   return string_lit();  }
        case 229: break;
        case 9: 
        case 10: 
          {  Token t = int_lit(yytext(), 10);
                                   if (t != null) return t;  }
        case 230: break;
        case 5: 
        case 43: 
        case 48: 
          {  error("Illegal character \"" +
                                              yytext() + "\"", pos());  }
        case 231: break;
        case 17: 
          {  yybegin(STRING); sb.setLength(0);  }
        case 232: break;
        case 53: 
          {  Token t = int_lit(yytext(), 8);
                                   if (t != null) return t;  }
        case 233: break;
        case 56: 
        case 113: 
          {  Token t = double_lit(yytext());
                                   if (t != null) return t;  }
        case 234: break;
        case 58: 
          {  Token t = double_lit(chop());
                                   if (t != null) return t;  }
        case 235: break;
        case 59: 
          {  Token t = float_lit(chop());
                                   if (t != null) return t;  }
        case 236: break;
        case 60: 
          {  Token t = long_lit(chop(), 10);
                                   if (t != null) return t;  }
        case 237: break;
        case 92: 
          {  error("Illegal escape character \"" +
                                              yytext() + "\"", pos());  }
        case 238: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
              {     return new EOF(pos(), sym.EOF);
 }
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }


}
