/*-
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 2002-2010 Oracle.  All rights reserved.
 *
 */

package com.sleepycat.je.rep.utilint;

import java.util.concurrent.CountDownLatch;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;

public class WaitForReplicaListener implements StateChangeListener {
    CountDownLatch waitForReplica = new CountDownLatch(1);

    public void stateChange(StateChangeEvent stateChangeEvent) {
        if (stateChangeEvent.getState().equals
            (ReplicatedEnvironment.State.REPLICA)) {
            waitForReplica.countDown();
        }
    }
    
    public void awaitReplica()
        throws InterruptedException {

        waitForReplica.await();
    }
}
