/**
 * Copyright (C) 2010 Fabric project group, Cornell University
 *
 * This file is part of Fabric.
 *
 * Fabric is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Fabric is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 */
package sif.html;

import sif.servlet.HTMLWriter;
import fabric.lang.security.Label;

/**
 * @author andru
 *
 * A NodeList is a sequence of HTML nodes acting as a single node.
 */
public final class NodeList extends Node {
    final Node[] children;

    public static NodeList EMPTY(Label L, Label E) {
        return new NodeList(L, E, new Node[0]);
    }

    private NodeList(Label L, Label E, Node[] children) {
        super(L, E);
        this.children = children;
    }   
    public NodeList(Label L, Label E, Label cL, Label cE, Node n1) {
        super(L, E);
        this.children = new Node[] { n1 };
    }	
    public NodeList(Label L, Label E, 
            Label cL, Label cE, Node n1, 
            Label cL2, Label cE2, Node n2) {
        super(L, E);
        this.children = new Node[] { n1, n2 };
    }
    public NodeList(Label L, Label E, 
            Label cL, Label cE, Node n1, 
            Label cL2, Label cE2, Node n2, 
            Label cL3, Label cE3, Node n3) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3 };
    }
    public NodeList(Label L, Label E, 
            Label cL, Label cE, Node n1, 
            Label cL2, Label cE2, Node n2, 
            Label cL3, Label cE3, Node n3, 
            Label cL4, Label cE4, Node n4) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4 };
    }

    public NodeList(Label L, Label E, 
            Label cL, Label cE, Node n1, 
            Label cL2, Label cE2, Node n2, 
            Label cL3, Label cE3, Node n3, 
            Label cL4, Label cE4, Node n4, 
            Label cL5, Label cE5, Node n5) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5 };
    }
    public NodeList(Label L, Label E, 
            Label cL, Label cE, Node n1, 
            Label cL2, Label cE2, Node n2, 
            Label cL3, Label cE3, Node n3, 
            Label cL4, Label cE4, Node n4, 
            Label cL5, Label cE5, Node n5, 
            Label cL6, Label cE6, Node n6) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6 };
    }
    public NodeList(Label L, Label E, 
            Label cL, Label cE, Node n1, 
            Label cL2, Label cE2, Node n2, 
            Label cL3, Label cE3, Node n3, 
            Label cL4, Label cE4, Node n4, 
            Label cL5, Label cE5, Node n5, 
            Label cL6, Label cE6, Node n6, 
            Label cL7, Label cE7, Node n7) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6, n7 };
    }
    public NodeList(Label L, Label E, 
            Label cL, Label cE, Node n1, 
            Label cL2, Label cE2, Node n2, 
            Label cL3, Label cE3, Node n3, 
            Label cL4, Label cE4, Node n4, 
            Label cL5, Label cE5, Node n5, 
            Label cL6, Label cE6, Node n6, 
            Label cL7, Label cE7, Node n7, 
            Label cL8, Label cE8, Node n8) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6, n7, n8 };
    }
    public NodeList(Label L, Label E, 
            Label cL, Label cE, Node n1, 
            Label cL2, Label cE2, Node n2, 
            Label cL3, Label cE3, Node n3, 
            Label cL4, Label cE4, Node n4, 
            Label cL5, Label cE5, Node n5, 
            Label cL6, Label cE6, Node n6, 
            Label cL7, Label cE7, Node n7, 
            Label cL8, Label cE8, Node n8, 
            Label cL9, Label cE9, Node n9) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6, n7, n8, n9 };
    }
    
    public NodeList(Label L, Label E, Node n1) {
        super(L, E);
        this.children = new Node[] { n1 };
    }
    public NodeList(Label L, Label E, Node n1, Node n2) {
        super(L, E);
        this.children = new Node[] { n1, n2 };
    }
    public NodeList(Label L, Label E, Node n1, Node n2, Node n3) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3 };
    }
    public NodeList(Label L, Label E, Node n1, Node n2, Node n3, Node n4) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4 };
    }
    public NodeList(Label L, Label E, Node n1, Node n2, Node n3, Node n4, Node n5) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5 };
    }
    public NodeList(Label L, Label E, 
            Node n1, Node n2, Node n3, Node n4, Node n5, Node n6) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6 };
    }
    public NodeList(Label L, Label E, 
            Node n1, Node n2, Node n3, Node n4, Node n5, Node n6, Node n7) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6, n7 };
    }
    public NodeList(Label L, Label E, 
            Node n1, Node n2, Node n3, Node n4, Node n5, Node n6, Node n7, Node n8) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6, n7, n8 };
    }
    public NodeList(Label L, Label E, 
            Node n1, Node n2, Node n3, Node n4, Node n5, Node n6, Node n7, Node n8, Node n9) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6, n7, n8, n9 };
    }

    public NodeList(Label L, Label E, Label cL, Label cE, Node n1, Node n2) {
        super(L, E);
        this.children = new Node[] { n1, n2 };
    }
    public NodeList(Label L, Label E, Label cL, Label cE, Node n1, Node n2, Node n3) {

        super(L, E);
        this.children = new Node[] { n1, n2, n3 };
    }
    public NodeList(Label L, Label E, Label cL, Label cE, Node n1, Node n2, Node n3, Node n4) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4 };
    }

    public NodeList(Label L, Label E, Label cL, Label cE, Node n1, Node n2, Node n3, Node n4, Node n5) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5 };
    }
    public NodeList(Label L, Label E, 
            Label cL, Label cE,
            Node n1, Node n2, Node n3, Node n4, Node n5, Node n6) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6 };
    }
    public NodeList(Label L, Label E, 
            Label cL, Label cE, 
            Node n1, Node n2, Node n3, Node n4, Node n5, Node n6, Node n7) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6, n7 };
    }
    public NodeList(Label L, Label E, 
            Label cL, Label cE, 
            Node n1, Node n2, Node n3, Node n4, Node n5, Node n6, Node n7, Node n8) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6, n7, n8 };
    }
    public NodeList(Label L, Label E, 
            Label cL, Label cE, 
            Node n1, Node n2, Node n3, Node n4, Node n5, Node n6, Node n7, Node n8, Node n9) {
        super(L, E);
        this.children = new Node[] { n1, n2, n3, n4, n5, n6, n7, n8, n9 };
    }

    void writeImpl(HTMLWriter w) {
        for (int i = 0; i < children.length; i++) {
            if (children[i] != null) {
                w.begin();
                children[i].write(w, this);
                w.end();              
            }
        }
    }
        
    public final NodeList append(Label cL, Label cE, Node n2) {
        return append(L, E, cL, cE, n2);
    }
    public final NodeList append(Node n2) {
        return append(L, E, L, E, n2);
    }
    public final NodeList append(Label rL, Label rE, Label cL, Label cE, Node n2) {
        Node[] newChildren = new Node[children.length + 1];
        System.arraycopy(children, 0, newChildren, 0, children.length);
        newChildren[children.length] = n2;
        return new NodeList(rL, rE, newChildren);
    }

    public static boolean jif$Instanceof(Label l, Label e, Object o) {
        return (o instanceof NodeList) && Node.jif$Instanceof(l, e, o);
    }

    public static NodeList jif$cast$sif_html_NodeList(Label l, Label e, Object o) {
        if (o == null) return null; 
        if (jif$Instanceof(l, e, o))
            return (NodeList)o;
        throw new ClassCastException();
    }

}
