/* The following code was generated by JFlex 1.3.5 on 30/08/10 7:13 PM */

/* Java 1.4 scanner for JFlex.
 * Based on JLS, 2ed, Chapter 3.
 */

package fabric.parse;

import java_cup.runtime.Symbol;
import polyglot.lex.Lexer;
import polyglot.lex.*;
import polyglot.util.Position;
import polyglot.util.ErrorQueue;
import polyglot.util.ErrorInfo;
import polyglot.frontend.FileSource;
import java.util.HashMap;
import java.math.BigInteger;


@SuppressWarnings("all")

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.3.5
 * on 30/08/10 7:13 PM from the specification file
 * <tt>file:/home/jed/work/fabric/tmp/fabric/src/compiler/fabric/parse/fabric.flex</tt>
 */
public class Lexer_c implements Lexer {

  /** This character denotes the end of file */
  final public static int YYEOF = -1;

  /** initial size of the lookahead buffer */
  final private static int YY_BUFFERSIZE = 16384;

  /** lexical states */
  final public static int END_OF_LINE_COMMENT = 4;
  final public static int STRING = 1;
  final public static int YYINITIAL = 0;
  final public static int CHARACTER = 2;
  final public static int TRADITIONAL_COMMENT = 3;

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\11\5\1\3\1\1\1\0\1\3\1\2\16\5\4\0\1\3\1\51"+
    "\1\23\1\0\1\4\1\61\1\55\1\22\1\36\1\37\1\21\1\57"+
    "\1\45\1\15\1\13\1\20\1\6\3\17\4\12\2\7\1\54\1\44"+
    "\1\50\1\46\1\47\1\53\1\35\3\11\1\64\1\14\1\63\5\4"+
    "\1\62\13\4\1\10\2\4\1\42\1\16\1\43\1\60\1\4\1\0"+
    "\1\31\1\73\1\11\1\64\1\27\1\30\5\4\1\32\1\4\1\34"+
    "\3\4\1\25\1\33\1\24\1\26\2\4\1\10\2\4\1\40\1\56"+
    "\1\41\1\52\41\5\2\0\4\4\4\0\1\4\2\0\1\5\7\0"+
    "\1\4\4\0\1\4\5\0\27\4\1\0\37\4\1\0\u013f\4\31\0"+
    "\162\4\4\0\14\4\16\0\5\4\11\0\1\4\21\0\130\5\5\0"+
    "\23\5\12\0\1\4\13\0\1\4\1\0\3\4\1\0\1\4\1\0"+
    "\24\4\1\0\54\4\1\0\46\4\1\0\5\4\4\0\202\4\1\0"+
    "\4\5\3\0\105\4\1\0\46\4\2\0\2\4\6\0\20\4\41\0"+
    "\46\4\2\0\1\4\7\0\47\4\11\0\21\5\1\0\27\5\1\0"+
    "\3\5\1\0\1\5\1\0\2\5\1\0\1\5\13\0\33\4\5\0"+
    "\3\4\15\0\4\5\14\0\6\5\13\0\32\4\5\0\13\4\16\5"+
    "\7\0\12\5\4\0\2\4\1\5\143\4\1\0\1\4\10\5\1\0"+
    "\6\5\2\4\2\5\1\0\4\5\2\4\12\5\3\4\2\0\1\4"+
    "\17\0\1\5\1\4\1\5\36\4\33\5\2\0\3\4\60\0\46\4"+
    "\13\5\1\4\u014f\0\3\5\66\4\2\0\1\5\1\4\20\5\2\0"+
    "\1\4\4\5\3\0\12\4\2\5\2\0\12\5\21\0\3\5\1\0"+
    "\10\4\2\0\2\4\2\0\26\4\1\0\7\4\1\0\1\4\3\0"+
    "\4\4\2\0\1\5\1\4\7\5\2\0\2\5\2\0\3\5\11\0"+
    "\1\5\4\0\2\4\1\0\3\4\2\5\2\0\12\5\4\4\15\0"+
    "\3\5\1\0\6\4\4\0\2\4\2\0\26\4\1\0\7\4\1\0"+
    "\2\4\1\0\2\4\1\0\2\4\2\0\1\5\1\0\5\5\4\0"+
    "\2\5\2\0\3\5\13\0\4\4\1\0\1\4\7\0\14\5\3\4"+
    "\14\0\3\5\1\0\11\4\1\0\3\4\1\0\26\4\1\0\7\4"+
    "\1\0\2\4\1\0\5\4\2\0\1\5\1\4\10\5\1\0\3\5"+
    "\1\0\3\5\2\0\1\4\17\0\2\4\2\5\2\0\12\5\1\0"+
    "\1\4\17\0\3\5\1\0\10\4\2\0\2\4\2\0\26\4\1\0"+
    "\7\4\1\0\2\4\1\0\5\4\2\0\1\5\1\4\6\5\3\0"+
    "\2\5\2\0\3\5\10\0\2\5\4\0\2\4\1\0\3\4\4\0"+
    "\12\5\1\0\1\4\20\0\1\5\1\4\1\0\6\4\3\0\3\4"+
    "\1\0\4\4\3\0\2\4\1\0\1\4\1\0\2\4\3\0\2\4"+
    "\3\0\3\4\3\0\10\4\1\0\3\4\4\0\5\5\3\0\3\5"+
    "\1\0\4\5\11\0\1\5\17\0\11\5\11\0\1\4\7\0\3\5"+
    "\1\0\10\4\1\0\3\4\1\0\27\4\1\0\12\4\1\0\5\4"+
    "\4\0\7\5\1\0\3\5\1\0\4\5\7\0\2\5\11\0\2\4"+
    "\4\0\12\5\22\0\2\5\1\0\10\4\1\0\3\4\1\0\27\4"+
    "\1\0\12\4\1\0\5\4\2\0\1\5\1\4\7\5\1\0\3\5"+
    "\1\0\4\5\7\0\2\5\7\0\1\4\1\0\2\4\4\0\12\5"+
    "\22\0\2\5\1\0\10\4\1\0\3\4\1\0\27\4\1\0\20\4"+
    "\4\0\6\5\2\0\3\5\1\0\4\5\11\0\1\5\10\0\2\4"+
    "\4\0\12\5\22\0\2\5\1\0\22\4\3\0\30\4\1\0\11\4"+
    "\1\0\1\4\2\0\7\4\3\0\1\5\4\0\6\5\1\0\1\5"+
    "\1\0\10\5\22\0\2\5\15\0\60\4\1\5\2\4\7\5\4\0"+
    "\10\4\10\5\1\0\12\5\47\0\2\4\1\0\1\4\2\0\2\4"+
    "\1\0\1\4\2\0\1\4\6\0\4\4\1\0\7\4\1\0\3\4"+
    "\1\0\1\4\1\0\1\4\2\0\2\4\1\0\4\4\1\5\2\4"+
    "\6\5\1\0\2\5\1\4\2\0\5\4\1\0\1\4\1\0\6\5"+
    "\2\0\12\5\2\0\2\4\42\0\1\4\27\0\2\5\6\0\12\5"+
    "\13\0\1\5\1\0\1\5\1\0\1\5\4\0\2\5\10\4\1\0"+
    "\42\4\6\0\24\5\1\0\2\5\4\4\4\0\10\5\1\0\44\5"+
    "\11\0\1\5\71\0\42\4\1\0\5\4\1\0\2\4\1\0\7\5"+
    "\3\0\4\5\6\0\12\5\6\0\6\4\4\5\106\0\46\4\12\0"+
    "\51\4\7\0\132\4\5\0\104\4\5\0\122\4\6\0\7\4\1\0"+
    "\77\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0\1\4\1\0"+
    "\4\4\2\0\47\4\1\0\1\4\1\0\4\4\2\0\37\4\1\0"+
    "\1\4\1\0\4\4\2\0\7\4\1\0\1\4\1\0\4\4\2\0"+
    "\7\4\1\0\7\4\1\0\27\4\1\0\37\4\1\0\1\4\1\0"+
    "\4\4\2\0\7\4\1\0\47\4\1\0\23\4\16\0\11\5\56\0"+
    "\125\4\14\0\u026c\4\2\0\10\4\12\0\32\4\5\0\113\4\3\0"+
    "\3\4\17\0\15\4\1\0\4\4\3\5\13\0\22\4\3\5\13\0"+
    "\22\4\2\5\14\0\15\4\1\0\3\4\1\0\2\5\14\0\64\4"+
    "\40\5\3\0\1\4\3\0\2\4\1\5\2\0\12\5\41\0\3\5"+
    "\2\0\12\5\6\0\130\4\10\0\51\4\1\5\126\0\35\4\3\0"+
    "\14\5\4\0\14\5\12\0\12\5\36\4\2\0\5\4\u038b\0\154\4"+
    "\224\0\234\4\4\0\132\4\6\0\26\4\2\0\6\4\2\0\46\4"+
    "\2\0\6\4\2\0\10\4\1\0\1\4\1\0\1\4\1\0\1\4"+
    "\1\0\37\4\2\0\65\4\1\0\7\4\1\0\1\4\3\0\3\4"+
    "\1\0\7\4\3\0\4\4\2\0\6\4\4\0\15\4\5\0\3\4"+
    "\1\0\7\4\17\0\4\5\32\0\5\5\20\0\2\4\23\0\1\4"+
    "\13\0\4\5\6\0\6\5\1\0\1\4\15\0\1\4\40\0\22\4"+
    "\36\0\15\5\4\0\1\5\3\0\6\5\27\0\1\4\4\0\1\4"+
    "\2\0\12\4\1\0\1\4\3\0\5\4\6\0\1\4\1\0\1\4"+
    "\1\0\1\4\1\0\4\4\1\0\3\4\1\0\7\4\3\0\3\4"+
    "\5\0\5\4\26\0\44\4\14\0\1\67\1\0\1\70\u0100\0\1\65"+
    "\1\66\17\0\1\71\1\72\u0d5f\0\3\4\31\0\11\4\6\5\1\0"+
    "\5\4\2\0\5\4\4\0\126\4\2\0\2\5\2\0\3\4\1\0"+
    "\137\4\5\0\50\4\4\0\136\4\21\0\30\4\70\0\20\4\u0200\0"+
    "\u19b6\4\112\0\u51a6\4\132\0\u048d\4\u0773\0\u2ba4\4\u215c\0\u012e\4\2\0"+
    "\73\4\225\0\7\4\14\0\5\4\5\0\1\4\1\5\12\4\1\0"+
    "\15\4\1\0\5\4\1\0\1\4\1\0\2\4\1\0\2\4\1\0"+
    "\154\4\41\0\u016b\4\22\0\100\4\2\0\66\4\50\0\15\4\3\0"+
    "\20\5\20\0\4\5\17\0\2\4\30\0\3\4\31\0\1\4\6\0"+
    "\5\4\1\0\207\4\2\0\1\5\4\0\1\4\13\0\12\5\7\0"+
    "\32\4\4\0\1\4\1\0\32\4\12\0\132\4\3\0\6\4\2\0"+
    "\6\4\2\0\6\4\2\0\3\4\3\0\2\4\3\0\2\4\22\0"+
    "\3\5\4\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    60,   120,   180,   240,   300,   300,   360,   420,   480, 
      540,   600,   660,   720,   780,   300,   300,   840,   900,   960, 
      300,   300,   300,   300,   300,   300,   300,   300,   300,  1020, 
     1080,  1140,  1200,   300,   300,   300,  1260,  1320,  1380,  1440, 
     1500,   300,   300,   300,   300,   300,   300,  1560,   300,  1620, 
     1680,   300,  1740,   300,  1800,  1860,   300,  1920,   300,  1980, 
     2040,  2100,  2160,  2220,  2280,   300,   300,   300,   300,   300, 
      300,   300,   300,   300,  2340,  2400,  2460,   300,   300,  2520, 
      300,  2580,   300,   300,   300,   300,   300,   300,   300,   300, 
      300,   300,  2640,  2700,   300,   300,   300,   300,   300,   300, 
      300,   300,   300,   300,   300,   300,   300,   300,   300,   300, 
      300,  2760,  2820,  2880,  2940,  3000,  3060,   300,  3120,   300, 
      300,   300,   420,  3180,   420,   300,   420
  };

  /** 
   * The packed transition table of the DFA (part 0)
   */
  final private static String yy_packed0 = 
    "\1\6\1\7\1\10\1\7\1\11\1\6\1\12\1\13"+
    "\2\11\1\13\1\14\1\11\1\15\1\6\1\13\1\16"+
    "\1\17\1\20\1\21\1\22\3\11\1\23\3\11\1\24"+
    "\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\3\11\1\52\1\53"+
    "\1\54\1\55\1\56\1\57\1\11\1\60\1\61\1\62"+
    "\13\60\1\63\4\60\1\64\50\60\1\65\1\66\1\67"+
    "\13\65\1\70\3\65\1\71\51\65\21\7\1\72\53\7"+
    "\1\73\1\74\71\7\75\0\1\7\76\0\7\11\1\0"+
    "\1\11\2\0\1\11\4\0\11\11\25\0\3\11\6\0"+
    "\1\11\6\0\1\75\1\76\1\77\1\0\1\75\1\100"+
    "\1\101\2\0\1\75\7\0\1\101\1\102\1\0\1\103"+
    "\27\0\1\103\1\102\1\104\15\0\2\13\2\0\1\13"+
    "\1\100\1\101\2\0\1\13\7\0\1\101\1\102\1\0"+
    "\1\103\27\0\1\103\1\102\1\104\15\0\2\100\2\0"+
    "\1\100\4\0\1\100\71\0\1\105\30\0\1\106\45\0"+
    "\1\107\1\110\24\0\1\111\73\0\1\112\31\0\7\11"+
    "\1\0\1\11\2\0\1\11\4\0\1\11\1\113\7\11"+
    "\25\0\3\11\6\0\1\11\4\0\7\11\1\0\1\11"+
    "\2\0\1\11\4\0\5\11\1\114\3\11\25\0\3\11"+
    "\6\0\1\11\4\0\7\11\1\0\1\11\2\0\1\11"+
    "\4\0\2\11\1\115\6\11\25\0\3\11\6\0\1\11"+
    "\46\0\1\116\73\0\1\117\1\120\72\0\1\121\1\0"+
    "\1\122\71\0\1\123\73\0\1\124\6\0\1\125\64\0"+
    "\1\126\7\0\1\127\63\0\1\130\10\0\1\131\62\0"+
    "\1\132\73\0\1\133\25\0\1\60\2\0\13\60\1\0"+
    "\4\60\1\0\50\60\1\0\1\61\72\0\1\134\1\0"+
    "\4\134\1\135\3\134\1\136\3\134\1\137\1\135\2\134"+
    "\1\140\1\141\1\142\1\143\2\134\1\144\3\134\1\145"+
    "\36\134\1\146\1\65\2\0\13\65\1\0\3\65\1\0"+
    "\51\65\1\0\1\66\72\0\1\134\1\0\4\134\1\135"+
    "\3\134\1\136\3\134\1\147\1\135\2\134\1\150\1\151"+
    "\1\152\1\153\2\134\1\154\3\134\1\155\36\134\1\156"+
    "\20\0\1\73\54\0\1\73\100\0\1\75\1\76\2\0"+
    "\1\75\1\100\1\101\2\0\1\75\7\0\1\101\2\0"+
    "\1\157\27\0\1\157\17\0\2\76\2\0\1\76\1\100"+
    "\1\101\2\0\1\76\7\0\1\101\52\0\2\160\1\0"+
    "\2\160\1\0\1\160\2\0\1\160\7\0\3\160\31\0"+
    "\2\160\6\0\1\160\6\0\2\100\2\0\1\100\1\0"+
    "\1\101\2\0\1\100\7\0\1\101\1\102\32\0\1\102"+
    "\1\104\15\0\2\161\2\0\1\161\2\0\1\162\1\0"+
    "\1\161\37\0\1\162\20\0\7\11\1\0\1\11\2\0"+
    "\1\11\4\0\2\11\1\163\6\11\25\0\3\11\6\0"+
    "\1\11\4\0\7\11\1\0\1\11\2\0\1\11\4\0"+
    "\6\11\1\164\2\11\25\0\3\11\6\0\1\11\4\0"+
    "\7\11\1\0\1\11\2\0\1\11\4\0\6\11\1\165"+
    "\2\11\25\0\3\11\6\0\1\11\46\0\1\166\1\167"+
    "\72\0\1\170\33\0\1\136\3\0\1\136\4\0\1\136"+
    "\62\0\1\171\3\0\1\171\4\0\1\171\62\0\2\160"+
    "\1\0\2\160\1\0\1\160\2\0\1\160\7\0\3\160"+
    "\1\172\27\0\1\172\2\160\6\0\1\160\6\0\2\161"+
    "\2\0\1\161\4\0\1\161\10\0\1\102\32\0\1\102"+
    "\1\104\15\0\2\161\2\0\1\161\4\0\1\161\60\0"+
    "\7\11\1\0\1\11\2\0\1\11\4\0\3\11\1\173"+
    "\5\11\25\0\3\11\6\0\1\11\4\0\7\11\1\0"+
    "\1\11\2\0\1\11\4\0\7\11\1\174\1\11\25\0"+
    "\3\11\6\0\1\11\4\0\7\11\1\0\1\11\2\0"+
    "\1\11\4\0\6\11\1\175\2\11\25\0\3\11\6\0"+
    "\1\11\46\0\1\176\31\0\7\11\1\0\1\11\2\0"+
    "\1\11\4\0\3\11\1\177\5\11\25\0\3\11\6\0"+
    "\1\11";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack();


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     0,  0,  0,  0,  0,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  9, 
     9,  1,  1,  1,  9,  9,  9,  9,  9,  9,  9,  9,  9,  1,  1,  1, 
     1,  9,  9,  9,  1,  1,  1,  1,  1,  9,  9,  9,  9,  9,  9,  1, 
     9,  1,  1,  9,  1,  9,  1,  1,  9,  1,  9,  1,  1,  0,  0,  1, 
     0,  9,  9,  9,  9,  9,  9,  9,  9,  9,  1,  1,  1,  9,  9,  1, 
     9,  1,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  1,  1,  9,  9, 
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  1, 
     1,  0,  1,  1,  1,  9,  1,  9,  9,  9,  1,  1,  1,  9,  1
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[YY_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL = true;

  /** yy_atEOF == true <=> the scanner is at the EOF */
  private boolean yy_atEOF;

  /* user code: */
    StringBuffer sb = new StringBuffer();
    String file;
    String path;
    ErrorQueue eq;
    HashMap keywords;

    public Lexer_c(java.io.InputStream in, FileSource file, ErrorQueue eq) {
        this(new java.io.BufferedReader(new java.io.InputStreamReader(in)),
             file, eq);
    }

    public Lexer_c(java.io.Reader reader, FileSource file, ErrorQueue eq) {
        this(reader);
        this.file = file.name();
        this.path = file.path();
        this.eq = eq;
        this.keywords = new HashMap();
        init_keywords();
    }

    protected void init_keywords() {
        keywords.put("abstract",      new Integer(sym.ABSTRACT));
        keywords.put("assert",        new Integer(sym.ASSERT));
        keywords.put("boolean",       new Integer(sym.BOOLEAN));
        keywords.put("break",         new Integer(sym.BREAK));
        keywords.put("byte",          new Integer(sym.BYTE));
        keywords.put("case",          new Integer(sym.CASE));
        keywords.put("catch",         new Integer(sym.CATCH));
        keywords.put("char",          new Integer(sym.CHAR));
        keywords.put("class",         new Integer(sym.CLASS));
        keywords.put("const",         new Integer(sym.CONST));
        keywords.put("continue",      new Integer(sym.CONTINUE));
        keywords.put("default",       new Integer(sym.DEFAULT));
        keywords.put("do",            new Integer(sym.DO));
        keywords.put("double",        new Integer(sym.DOUBLE));
        keywords.put("else",          new Integer(sym.ELSE));
        keywords.put("extends",       new Integer(sym.EXTENDS));
        keywords.put("final",         new Integer(sym.FINAL));
        keywords.put("finally",       new Integer(sym.FINALLY));
        keywords.put("float",         new Integer(sym.FLOAT));
        keywords.put("for",           new Integer(sym.FOR));
        keywords.put("goto",          new Integer(sym.GOTO));
        keywords.put("if",            new Integer(sym.IF));
        keywords.put("implements",    new Integer(sym.IMPLEMENTS));
        keywords.put("import",        new Integer(sym.IMPORT));
        keywords.put("instanceof",    new Integer(sym.INSTANCEOF));
        keywords.put("int",           new Integer(sym.INT));
        keywords.put("interface",     new Integer(sym.INTERFACE));
        keywords.put("long",          new Integer(sym.LONG));
        keywords.put("native",        new Integer(sym.NATIVE));
        keywords.put("new",           new Integer(sym.NEW));
        keywords.put("package",       new Integer(sym.PACKAGE));
        keywords.put("private",       new Integer(sym.PRIVATE));
        keywords.put("protected",     new Integer(sym.PROTECTED));
        keywords.put("public",        new Integer(sym.PUBLIC));
        keywords.put("return",        new Integer(sym.RETURN));
        keywords.put("short",         new Integer(sym.SHORT));
        keywords.put("static",        new Integer(sym.STATIC));
        keywords.put("strictfp",      new Integer(sym.STRICTFP));
        keywords.put("super",         new Integer(sym.SUPER));
        keywords.put("switch",        new Integer(sym.SWITCH));
        keywords.put("synchronized",  new Integer(sym.SYNCHRONIZED));
        keywords.put("this",          new Integer(sym.THIS));
        keywords.put("throw",         new Integer(sym.THROW));
        keywords.put("throws",        new Integer(sym.THROWS));
        keywords.put("transient",     new Integer(sym.TRANSIENT));
        keywords.put("try",           new Integer(sym.TRY));
        keywords.put("void",          new Integer(sym.VOID));
        keywords.put("volatile",      new Integer(sym.VOLATILE));
        keywords.put("while",         new Integer(sym.WHILE));

        /* Jif-specific keywords */    
        keywords.put("actsFor",       new Integer(sym.ACTSFOR));
        keywords.put("actsfor",       new Integer(sym.ACTSFOR_LOWER));
        keywords.put("equiv",         new Integer(sym.EQUIV));
        keywords.put("authority",     new Integer(sym.AUTHORITY));
        keywords.put("caller",        new Integer(sym.CALLER));
        keywords.put("covariant",     new Integer(sym.COVARIANT));
        keywords.put("invariant",     new Integer(sym.INVARIANT));
        keywords.put("declassify",    new Integer(sym.DECLASSIFY));
        keywords.put("endorse",       new Integer(sym.ENDORSE));
        keywords.put("to",            new Integer(sym.TO));
        keywords.put("label",         new Integer(sym.LABEL));
        keywords.put("principal",     new Integer(sym.PRINCIPAL));
        keywords.put("where",         new Integer(sym.WHERE));
        keywords.put("meet",          new Integer(sym.MEET));

        /* Fabric-specific keywords */
        keywords.put("atomic",        new Integer(sym.ATOMIC));
        keywords.put("worker$",       new Integer(sym.WORKER));
        keywords.put("nonfabric",     new Integer(sym.NONFABRIC));
    }

    public String file() {
        return file;
    }
    public String path() {
        return path;
    }

    private Position pos() {
        return new Position(path, file, yyline+1, yycolumn, yyline+1,
                            yycolumn + yytext().length());
    }

    private Position pos(int len) {
        return new Position(path, file, yyline+1, yycolumn-len-1, yyline+1,
                            yycolumn+1);
    }

    private Token key(int symbol) {
        return new Keyword(pos(), yytext(), symbol);
    }

    private Token op(int symbol) {
        return new Operator(pos(), yytext(), symbol);
    }

    private Token id() {
        return new Identifier(pos(), yytext(), sym.IDENTIFIER);
    }

    private Token int_lit(String s, int radix) {
        BigInteger x = new BigInteger(s, radix);
        boolean boundary = (radix == 10 && s.equals("2147483648"));
        int bits = radix == 10 ? 31 : 32;
        if (x.bitLength() > bits && ! boundary) {
            eq.enqueue(ErrorInfo.LEXICAL_ERROR, "Integer literal \"" +
                        yytext() + "\" out of range.", pos());
        }
        return new IntegerLiteral(pos(), x.intValue(),
                boundary ? sym.INTEGER_LITERAL_BD : sym.INTEGER_LITERAL);
    }

    private Token long_lit(String s, int radix) {
        BigInteger x = new BigInteger(s, radix);
        boolean boundary = (radix == 10 && s.equals("9223372036854775808"));
        int bits = radix == 10 ? 63 : 64;
        if (x.bitLength() > bits && ! boundary) {
            eq.enqueue(ErrorInfo.LEXICAL_ERROR, "Long literal \"" +
                        yytext() + "\" out of range.", pos());
        }
        return new LongLiteral(pos(), x.longValue(),
                boundary ? sym.LONG_LITERAL_BD : sym.LONG_LITERAL);
    }

    private Token float_lit(String s) {
        try {
            Float x = Float.valueOf(s);
            boolean zero = true;
            for (int i = 0; i < s.length(); i++) {
                if ('1' <= s.charAt(i) && s.charAt(i) <= '9') {
                    zero = false;
                    break;
                }
                if (s.charAt(i) == 'e' || s.charAt(i) == 'E') {
                    break; // 0e19 is still 0
                }
            }
            if (x.isInfinite() || x.isNaN() || (x.floatValue() == 0 && ! zero)) {
                eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                           "Illegal float literal \"" + yytext() + "\"", pos());
            }
            return new FloatLiteral(pos(), x.floatValue(), sym.FLOAT_LITERAL);
        } catch (NumberFormatException e) {
            eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                       "Illegal float literal \"" + yytext() + "\"", pos());
            return new FloatLiteral(pos(), 0f, sym.FLOAT_LITERAL);
        }
    }

    private Token double_lit(String s) {
        try {
            Double x = Double.valueOf(s);
            boolean zero = true;
            for (int i = 0; i < s.length(); i++) {
                if ('1' <= s.charAt(i) && s.charAt(i) <= '9') {
                    zero = false;
                    break;
                }
                if (s.charAt(i) == 'e' || s.charAt(i) == 'E') {
                    break; // 0e19 is still 0
                }
            }
            if (x.isInfinite() || x.isNaN() || (x.doubleValue() == 0 && ! zero)) {
                eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                           "Illegal double literal \"" + yytext() + "\"", pos());
            }
            return new DoubleLiteral(pos(), x.doubleValue(), sym.DOUBLE_LITERAL);
        }
        catch (NumberFormatException e) {
            eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                       "Illegal double literal \"" + yytext() + "\"", pos());
            return new DoubleLiteral(pos(), 0., sym.DOUBLE_LITERAL);
        }
    }

    private Token char_lit(String s) {
        if (s.length() == 1) {
            char x = s.charAt(0);
            return new CharacterLiteral(pos(), x, sym.CHARACTER_LITERAL);
        }
        else {
            eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                       "Illegal character literal \'" + s + "\'", pos(s.length()));
            return new CharacterLiteral(pos(), '\0', sym.CHARACTER_LITERAL);
        }
    }

    private Token boolean_lit(boolean x) {
        return new BooleanLiteral(pos(), x, sym.BOOLEAN_LITERAL);
    }

    private Token null_lit() {
        return new NullLiteral(pos(), sym.NULL_LITERAL);
    }

    private Token string_lit() {
        return new StringLiteral(pos(sb.length()), sb.toString(),
                                 sym.STRING_LITERAL);
    }

    private String chop(int i, int j) {
        return yytext().substring(i,yylength()-j);
    }

    private String chop(int j) {
        return chop(0, j);
    }

    private String chop() {
        return chop(0, 1);
    }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Lexer_c(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Lexer_c(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the split, compressed DFA transition table.
   *
   * @return the unpacked transition table
   */
  private static int [] yy_unpack() {
    int [] trans = new int[3240];
    int offset = 0;
    offset = yy_unpack(yy_packed0, offset, trans);
    return trans;
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the index of the last entry
   */
  private static int yy_unpack(String packed, int offset, int [] trans) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1784) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   IOException  if any I/O-Error occurs
   */
  private boolean yy_refill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if (numRead < 0) {
      return true;
    }
    else {
      yy_endRead+= numRead;  
      return false;
    }
  }


  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */

    if (yy_reader != null)
      yy_reader.close();
  }


  /**
   * Closes the current stream, and resets the
   * scanner to read from a new input stream.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>YY_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  final public void yyreset(java.io.Reader reader) throws java.io.IOException {
    yyclose();
    yy_reader = reader;
    yy_atBOL  = true;
    yy_atEOF  = false;
    yy_endRead = yy_startRead = 0;
    yy_currentPos = yy_markedPos = yy_pushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    yy_lexical_state = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  final public char yycharat(int pos) {
    return yy_buffer[yy_startRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    String message;
    try {
      message = YY_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = YY_ERROR_MSG[YY_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number)  {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public Token nextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;

    // cached fields:
    int yy_currentPos_l;
    int yy_startRead_l;
    int yy_markedPos_l;
    int yy_endRead_l = yy_endRead;
    char [] yy_buffer_l = yy_buffer;
    char [] yycmap_l = yycmap;

    int [] yytrans_l = yytrans;
    int [] yy_rowMap_l = yy_rowMap;
    byte [] yy_attr_l = YY_ATTRIBUTE;

    while (true) {
      yy_markedPos_l = yy_markedPos;

      boolean yy_r = false;
      for (yy_currentPos_l = yy_startRead; yy_currentPos_l < yy_markedPos_l;
                                                             yy_currentPos_l++) {
        switch (yy_buffer_l[yy_currentPos_l]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          yy_r = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          yy_r = true;
          break;
        case '\n':
          if (yy_r)
            yy_r = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          yy_r = false;
          yycolumn++;
        }
      }

      if (yy_r) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean yy_peek;
        if (yy_markedPos_l < yy_endRead_l)
          yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        else if (yy_atEOF)
          yy_peek = false;
        else {
          boolean eof = yy_refill();
          yy_markedPos_l = yy_markedPos;
          yy_buffer_l = yy_buffer;
          if (eof) 
            yy_peek = false;
          else 
            yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        }
        if (yy_peek) yyline--;
      }
      yy_action = -1;

      yy_startRead_l = yy_currentPos_l = yy_currentPos = 
                       yy_startRead = yy_markedPos_l;

      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {

          if (yy_currentPos_l < yy_endRead_l)
            yy_input = yy_buffer_l[yy_currentPos_l++];
          else if (yy_atEOF) {
            yy_input = YYEOF;
            break yy_forAction;
          }
          else {
            // store back cached positions
            yy_currentPos  = yy_currentPos_l;
            yy_markedPos   = yy_markedPos_l;
            boolean eof = yy_refill();
            // get translated positions and possibly new buffer
            yy_currentPos_l  = yy_currentPos;
            yy_markedPos_l   = yy_markedPos;
            yy_buffer_l      = yy_buffer;
            yy_endRead_l     = yy_endRead;
            if (eof) {
              yy_input = YYEOF;
              break yy_forAction;
            }
            else {
              yy_input = yy_buffer_l[yy_currentPos_l++];
            }
          }
          int yy_next = yytrans_l[ yy_rowMap_l[yy_state] + yycmap_l[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = yy_attr_l[yy_state];
          if ( (yy_attributes & 1) == 1 ) {
            yy_action = yy_state; 
            yy_markedPos_l = yy_currentPos_l; 
            if ( (yy_attributes & 8) == 8 ) break yy_forAction;
          }

        }
      }

      // store back cached position
      yy_markedPos = yy_markedPos_l;

      switch (yy_action) {

        case 47: 
          {  sb.append( yytext() );  }
        case 128: break;
        case 52: 
          {  sb.append( yytext() );  }
        case 129: break;
        case 66: 
          {  return long_lit(chop(), 10);  }
        case 130: break;
        case 42: 
          {  return op(sym.JOIN);  }
        case 131: break;
        case 41: 
          {  return op(sym.MEET);  }
        case 132: break;
        case 91: 
          {  eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                              "Illegal escape character \"" +
                                              yytext() + "\"", pos());  }
        case 133: break;
        case 6: 
        case 7: 
          {  /* ignore */  }
        case 134: break;
        case 57: 
          {  /* ignore */  }
        case 135: break;
        case 126: 
          {  return boolean_lit(false);  }
        case 136: break;
        case 122: 
          {  return boolean_lit(true);   }
        case 137: break;
        case 43: 
          {  return op(sym.LEFTARROW);  }
        case 138: break;
        case 28: 
          {  return op(sym.COMMA);      }
        case 139: break;
        case 27: 
          {  return op(sym.SEMICOLON);  }
        case 140: break;
        case 11: 
          {  return op(sym.DOT);        }
        case 141: break;
        case 20: 
          {  return op(sym.AT);         }
        case 142: break;
        case 21: 
          {  return op(sym.LPAREN);     }
        case 143: break;
        case 22: 
          {  return op(sym.RPAREN);     }
        case 144: break;
        case 23: 
          {  return op(sym.LBRACE);     }
        case 145: break;
        case 24: 
          {  return op(sym.RBRACE);     }
        case 146: break;
        case 25: 
          {  return op(sym.LBRACK);     }
        case 147: break;
        case 26: 
          {  return op(sym.RBRACK);     }
        case 148: break;
        case 45: 
          {  return op(sym.TOP);       }
        case 149: break;
        case 46: 
          {  return op(sym.BOTTOM);    }
        case 150: break;
        case 124: 
          {  return null_lit();  }
        case 151: break;
        case 63: 
        case 112: 
          {  return double_lit(yytext());  }
        case 152: break;
        case 110: 
          {  return long_lit(chop(), 8);  }
        case 153: break;
        case 109: 
          {  sb.append('\b');  }
        case 154: break;
        case 108: 
          {  sb.append('\n');  }
        case 155: break;
        case 107: 
          {  sb.append('\f');  }
        case 156: break;
        case 106: 
          {  sb.append('\r');  }
        case 157: break;
        case 105: 
          {  sb.append('\t');  }
        case 158: break;
        case 104: 
          {  sb.append('\"');  }
        case 159: break;
        case 103: 
          {  sb.append('\'');  }
        case 160: break;
        case 102: 
          {  sb.append('\\');  }
        case 161: break;
        case 111: 
          {  return int_lit(chop(2,0), 16);  }
        case 162: break;
        case 5: 
        case 50: 
        case 55: 
          {  eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                              "Illegal character \"" +
                                              yytext() + "\"", pos());  }
        case 163: break;
        case 65: 
          {  return float_lit(chop());  }
        case 164: break;
        case 67: 
          {  return double_lit(chop());  }
        case 165: break;
        case 70: 
          {  yybegin(END_OF_LINE_COMMENT);  }
        case 166: break;
        case 58: 
        case 59: 
          {  yybegin(YYINITIAL);  }
        case 167: break;
        case 71: 
          {  yybegin(TRADITIONAL_COMMENT);  }
        case 168: break;
        case 8: 
        case 17: 
        case 18: 
        case 19: 
        case 74: 
        case 75: 
        case 76: 
        case 114: 
        case 115: 
        case 116: 
        case 123: 
          {  Integer i = (Integer) keywords.get(yytext());
                    if (i == null) return id();
                    else return key(i.intValue());  }
        case 169: break;
        case 15: 
          {  yybegin(CHARACTER); sb.setLength(0);  }
        case 170: break;
        case 125: 
          {  return op(sym.URSHIFTEQ);   }
        case 171: break;
        case 119: 
          {  return op(sym.LSHIFTEQ);    }
        case 172: break;
        case 118: 
          {  return op(sym.URSHIFT);     }
        case 173: break;
        case 117: 
          {  return op(sym.RSHIFTEQ);    }
        case 174: break;
        case 44: 
          {  return op(sym.RIGHTARROW);  }
        case 175: break;
        case 40: 
          {  return op(sym.MOD);         }
        case 176: break;
        case 39: 
          {  return op(sym.XOR);         }
        case 177: break;
        case 38: 
          {  return op(sym.PLUS);        }
        case 178: break;
        case 37: 
          {  return op(sym.OR);          }
        case 179: break;
        case 36: 
          {  return op(sym.AND);         }
        case 180: break;
        case 35: 
          {  return op(sym.COLON);       }
        case 181: break;
        case 34: 
          {  return op(sym.QUESTION);    }
        case 182: break;
        case 33: 
          {  return op(sym.COMP);        }
        case 183: break;
        case 32: 
          {  return op(sym.NOT);         }
        case 184: break;
        case 31: 
          {  return op(sym.LT);          }
        case 185: break;
        case 30: 
          {  return op(sym.GT);          }
        case 186: break;
        case 29: 
          {  return op(sym.EQ);          }
        case 187: break;
        case 14: 
          {  return op(sym.MULT);        }
        case 188: break;
        case 13: 
          {  return op(sym.DIV);         }
        case 189: break;
        case 12: 
          {  return op(sym.MINUS);       }
        case 190: break;
        case 68: 
          {  return op(sym.MINUSMINUS);  }
        case 191: break;
        case 69: 
          {  return op(sym.MINUSEQ);     }
        case 192: break;
        case 72: 
          {  return op(sym.DIVEQ);       }
        case 193: break;
        case 73: 
          {  return op(sym.MULTEQ);      }
        case 194: break;
        case 77: 
          {  return op(sym.EQEQ);        }
        case 195: break;
        case 78: 
          {  return op(sym.GTEQ);        }
        case 196: break;
        case 79: 
          {  return op(sym.RSHIFT);      }
        case 197: break;
        case 80: 
          {  return op(sym.LTEQ);        }
        case 198: break;
        case 81: 
          {  return op(sym.LSHIFT);      }
        case 199: break;
        case 82: 
          {  return op(sym.NOTEQ);       }
        case 200: break;
        case 83: 
          {  return op(sym.ANDEQ);       }
        case 201: break;
        case 84: 
          {  return op(sym.ANDAND);      }
        case 202: break;
        case 85: 
          {  return op(sym.OREQ);        }
        case 203: break;
        case 86: 
          {  return op(sym.OROR);        }
        case 204: break;
        case 87: 
          {  return op(sym.PLUSEQ);      }
        case 205: break;
        case 88: 
          {  return op(sym.PLUSPLUS);    }
        case 206: break;
        case 89: 
          {  return op(sym.XOREQ);       }
        case 207: break;
        case 90: 
          {  return op(sym.MODEQ);       }
        case 208: break;
        case 121: 
          {  return long_lit(chop(2,1), 16);  }
        case 209: break;
        case 101: 
          {  sb.append( '\b' );  }
        case 210: break;
        case 100: 
          {  sb.append( '\n' );  }
        case 211: break;
        case 99: 
          {  sb.append( '\f' );  }
        case 212: break;
        case 98: 
          {  sb.append( '\r' );  }
        case 213: break;
        case 97: 
          {  sb.append( '\t' );  }
        case 214: break;
        case 96: 
          {  sb.append( '\"' );  }
        case 215: break;
        case 95: 
          {  sb.append( '\'' );  }
        case 216: break;
        case 94: 
          {  sb.append( '\\' );  }
        case 217: break;
        case 9: 
        case 10: 
          {  return int_lit(yytext(), 10);  }
        case 218: break;
        case 60: 
          {  return int_lit(yytext(), 8);  }
        case 219: break;
        case 92: 
        case 93: 
        case 120: 
          {  try {
                                       int x = Integer.parseInt(chop(1,0), 8);
                                       sb.append((char) x);
                                   }
                                   catch (NumberFormatException e) {
                                       eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                                  "Illegal octal escape \""
                                                  + yytext() + "\"", pos());
                                   }
                                  }
        case 220: break;
        case 16: 
          {  yybegin(STRING); sb.setLength(0);  }
        case 221: break;
        case 48: 
        case 49: 
          {  yybegin(YYINITIAL);
                                   eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                              "Unclosed string literal",
                                              pos(sb.length()));  }
        case 222: break;
        case 51: 
          {  yybegin(YYINITIAL);
                                   return string_lit();  }
        case 223: break;
        case 53: 
        case 54: 
          {  yybegin(YYINITIAL);
                                  eq.enqueue(ErrorInfo.LEXICAL_ERROR,
                                             "Unclosed character literal",
                                             pos(sb.length()));  }
        case 224: break;
        case 56: 
          {  yybegin(YYINITIAL);
                                   return char_lit(sb.toString());  }
        case 225: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
              {     return new EOF(pos(), sym.EOF);
 }
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }


}
