/**
 * Copyright (C) 2010 Fabric project group, Cornell University
 *
 * This file is part of Fabric.
 *
 * Fabric is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Fabric is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 */
package fabil.visit;

import polyglot.ast.Expr;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.visit.AscriptionVisitor;

public class ArrayInitializerTypeFixer extends AscriptionVisitor {

  public ArrayInitializerTypeFixer(Job job, TypeSystem ts, NodeFactory nf) {
    super(job, ts, nf);
  }

  /*
   * (non-Javadoc)
   * 
   * @see polyglot.visit.AscriptionVisitor#ascribe(polyglot.ast.Expr,
   *      polyglot.types.Type)
   */
  @Override
  public Expr ascribe(Expr e, Type toType) {
    if (e.type().isNull()) e = e.type(toType);
    return e;
  }

}
