/**
 * Copyright (C) 2010 Fabric project group, Cornell University
 *
 * This file is part of Fabric.
 *
 * Fabric is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Fabric is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 */
package fabil.ast;

import java.util.List;

import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.TypeChecker;
import fabil.types.FabILTypeSystem;

public class StoreGetter_c extends Expr_c implements StoreGetter {

  public StoreGetter_c(Position pos) {
    super(pos);
  }

  @SuppressWarnings("rawtypes")
  @Override
  public List acceptCFG(CFGBuilder v, List succs) {
    return succs;
  }

  public Term firstChild() {
    return null;
  }
  
  /** Type check the expression. */
  @Override
  public Node typeCheck(TypeChecker tc) {
    FabILTypeSystem fts = (FabILTypeSystem) tc.typeSystem();
    return type(fts.Store());
  }  
  
}