/*
 * Decompiled with CFR 0.152.
 */
package fabric.tools.storebrowser;

import fabric.tools.storebrowser.DataProvider;
import fabric.tools.storebrowser.FabricDataProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class StoreBrowser
extends JFrame
implements TreeSelectionListener {
    private static final boolean useSystemLookAndFeel = false;
    private JTree tree;
    private JEditorPane infoPane;
    private DataProvider dataProvider;
    private Set<DefaultMutableTreeNode> childrenEnumerated;

    private Component createNavTree() {
        this.childrenEnumerated = new HashSet<DefaultMutableTreeNode>();
        Object root = this.dataProvider.getRoot();
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(root);
        this.addChildren(top);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        return new JScrollPane(this.tree);
    }

    private Component createInfoPane() {
        this.infoPane = new JEditorPane();
        this.infoPane.setEditable(false);
        return new JScrollPane(this.infoPane);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(65);
        menu.getAccessibleContext().setAccessibleDescription("Hello");
        menuBar.add(menu);
        return menuBar;
    }

    public StoreBrowser(DataProvider dataProvider) {
        super("Fabric Browser");
        this.dataProvider = dataProvider;
        Component treeView = this.createNavTree();
        Component infoView = this.createInfoPane();
        this.setLayout(new GridLayout(1, 0));
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(treeView);
        splitPane.setBottomComponent(infoView);
        Dimension minimumSize = new Dimension(100, 50);
        infoView.setMinimumSize(minimumSize);
        treeView.setMinimumSize(minimumSize);
        splitPane.setDividerLocation(400);
        splitPane.setPreferredSize(new Dimension(400, 500));
        this.add(splitPane);
        this.setJMenuBar(this.createMenuBar());
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StoreBrowser.createAndShowGUI(args);
            }
        });
    }

    private void addChildren(DefaultMutableTreeNode n) {
        if (!this.childrenEnumerated.contains(n)) {
            this.childrenEnumerated.add(n);
            List<Object> children = this.dataProvider.getChildrenForNode(n.getUserObject());
            for (Object obj : children) {
                n.add(new DefaultMutableTreeNode(obj));
            }
        }
    }

    private static void createAndShowGUI(String[] args) {
        String clientName = null;
        String storeName = null;
        long onum = -1L;
        if (args.length > 0) {
            clientName = args[0];
        }
        if (args.length > 1) {
            storeName = args[1];
        }
        if (args.length > 2) {
            onum = Long.parseLong(args[2]);
        }
        if (clientName == null) {
            clientName = JOptionPane.showInputDialog("Please enter client name");
        }
        if (storeName == null) {
            storeName = JOptionPane.showInputDialog("Please enter store name");
        }
        StoreBrowser frame = onum > 0L ? new StoreBrowser(new FabricDataProvider(clientName, storeName, onum)) : new StoreBrowser(new FabricDataProvider(clientName, storeName));
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode selected = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        this.addChildren(selected);
        this.infoPane.setText(this.dataProvider.getDescriptionForNode(selected.getUserObject()));
    }
}

