/*
 * Decompiled with CFR 0.152.
 */
package fabric.tools.storebrowser;

import fabric.lang.Object;
import fabric.tools.storebrowser.DataProvider;
import fabric.util.Map;
import fabric.worker.Store;
import fabric.worker.Worker;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class FabricDataProvider
implements DataProvider {
    StoreObject store;

    List<java.lang.Object> generateError(String msg, Throwable ex) {
        return Arrays.asList(new ErrorObject(msg, ex));
    }

    public FabricDataProvider(String clientName, String storeName) {
        try {
            Worker.initialize((String)clientName);
            this.store = new StoreObject(storeName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public FabricDataProvider(String clientName, String storeName, long onum) {
        try {
            Worker.initialize((String)clientName);
            this.store = new StoreObject(storeName, onum);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public java.lang.Object getRoot() {
        return this.store;
    }

    @Override
    public List<java.lang.Object> getChildrenForNode(final java.lang.Object obj) {
        return (List)Worker.runInSubTransaction((Worker.Code)new Worker.Code<List<java.lang.Object>>(){

            public List<java.lang.Object> run() {
                Getter g = (Getter)obj;
                return g.getChildren();
            }
        });
    }

    @Override
    public String getDescriptionForNode(final java.lang.Object obj) {
        return (String)Worker.runInSubTransaction((Worker.Code)new Worker.Code<String>(){

            public String run() {
                Getter g = (Getter)obj;
                return g.getValue();
            }
        });
    }

    class StoreObject
    extends Getter {
        Store s;
        List<java.lang.Object> rootObjects;

        StoreObject(String storeName) {
            this.s = Worker.getWorker().getStore(storeName);
            this.rootObjects = new LinkedList<java.lang.Object>();
            Worker.runInSubTransaction((Worker.Code)new Worker.Code<Void>(){

                public Void run() {
                    Map m = StoreObject.this.s.getRoot();
                    for (Object key : m.keySet()) {
                        String keyStr = key.toString();
                        StoreObject.this.rootObjects.add(new RootObject(keyStr, m.get(key)));
                    }
                    return null;
                }
            });
        }

        StoreObject(String storeName, long onum) {
            this.s = Worker.getWorker().getStore(storeName);
            String name = "fab://" + storeName + "/" + onum;
            Object._Proxy obj = new Object._Proxy(this.s, onum);
            DataObject dataObj = new DataObject(name, obj, obj.getClass());
            this.rootObjects = new LinkedList<java.lang.Object>();
            this.rootObjects.add(dataObj);
        }

        @Override
        public List<java.lang.Object> getChildren() {
            return Collections.unmodifiableList(this.rootObjects);
        }

        @Override
        public String getValue() {
            return this.s.name();
        }

        public String toString() {
            return "fab://" + this.s.name();
        }
    }

    class RootObject
    extends Getter {
        Object obj;
        String key;

        public RootObject(String key, Object val) {
            this.obj = val.fetch();
            this.key = key;
        }

        public String toString() {
            return "\"" + this.key + "\"" + " : " + this.obj.getClass();
        }

        @Override
        public List<java.lang.Object> getChildren() {
            return this.getChildrenForObject(this.obj);
        }

        @Override
        public String getValue() {
            return this.key;
        }
    }

    class ErrorObject
    extends Getter {
        String msg;
        Throwable ex;

        ErrorObject(String msg, Throwable ex) {
            this.msg = msg;
            this.ex = ex;
        }

        @Override
        public List<java.lang.Object> getChildren() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.msg;
        }

        @Override
        public String getValue() {
            return this.ex.getMessage();
        }
    }

    class DataObject
    extends Getter {
        java.lang.Object obj;
        String fieldName;
        Class t;

        DataObject(String fieldName, java.lang.Object val, Class t) {
            if (val != null && val instanceof Object) {
                Object fabObj = (Object)val;
                this.obj = fabObj.fetch();
                this.t = this.obj.getClass();
            } else {
                this.obj = val;
                this.t = t;
            }
            this.fieldName = fieldName;
        }

        public String toString() {
            if (this.t.isPrimitive()) {
                return this.fieldName + " = " + this.obj.toString();
            }
            if (this.obj != null && this.obj instanceof String) {
                return this.fieldName + " = \"" + this.obj.toString() + "\"";
            }
            return this.fieldName + " : " + this.t;
        }

        @Override
        public String getValue() {
            return this.obj == null ? "null" : this.obj.toString();
        }

        @Override
        public List<java.lang.Object> getChildren() {
            if (this.t.isPrimitive() || this.obj != null && this.obj instanceof String) {
                return Collections.emptyList();
            }
            return this.getChildrenForObject(this.obj);
        }
    }

    abstract class Getter {
        Getter() {
        }

        protected List<java.lang.Object> getChildrenForObject(java.lang.Object obj) {
            if (obj == null) {
                return Collections.emptyList();
            }
            try {
                Class<?> c = obj.getClass();
                LinkedList<java.lang.Object> toReturn = new LinkedList<java.lang.Object>();
                if (c.getDeclaringClass() != null && Map.class.isAssignableFrom(c.getDeclaringClass())) {
                    Map m = (Map)((Object)obj).$getProxy();
                    for (Object key : m.keySet()) {
                        String keyStr = key.toString();
                        toReturn.add(new RootObject(keyStr, m.get(key)));
                    }
                } else {
                    for (Field f : c.getDeclaredFields()) {
                        f.setAccessible(true);
                        toReturn.add(new DataObject(f.getName(), f.get(obj), f.getType()));
                    }
                }
                return toReturn;
            }
            catch (Exception ex) {
                return FabricDataProvider.this.generateError("Exception: " + ex.getMessage(), ex);
            }
        }

        abstract List<java.lang.Object> getChildren();

        abstract String getValue();
    }
}

