/*
 * Decompiled with CFR 0.152.
 */
package fabric.tools.classloader;

import fabric.common.exceptions.UsageError;
import fabric.lang.Codebase;
import fabric.lang.FClass;
import fabric.lang.Object;
import fabric.lang.WrappedJavaInlineable;
import fabric.lang.arrays.byteArray;
import fabric.lang.security.IntegPolicy;
import fabric.lang.security.Label;
import fabric.lang.security.LabelUtil;
import fabric.lang.security.NodePrincipal;
import fabric.lang.security.Principal;
import fabric.util.HashMap;
import fabric.util.Iterator;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CodebaseTool {
    private String baseName;

    public static void main(String[] args) throws IOException, UsageError, GeneralSecurityException {
        if (args.length < 2) {
            CodebaseTool.showUsage();
            return;
        }
        Worker.initialize((String)args[1]);
        String action = args[0];
        if (action.equals("import")) {
            CodebaseTool.handleImport(args);
        } else if (action.equals("export")) {
            CodebaseTool.handleExport(args);
        } else {
            System.err.println("Unrecognized action");
            CodebaseTool.showUsage();
            return;
        }
        System.exit(0);
    }

    private static void handleImport(String[] args) throws IOException {
        if (args.length != 5) {
            System.err.println("Incorrect number of arguments");
            CodebaseTool.showUsage();
            return;
        }
        String storeName = args[2];
        long onum = Long.parseLong(args[3]);
        String baseName = args[4];
        File f = new File(baseName);
        f.mkdirs();
        CodebaseTool tool = new CodebaseTool(baseName);
        RemoteStore s = Worker.getWorker().getStore(storeName);
        LinkedList<Codebase> codebases = new LinkedList<Codebase>();
        codebases.add((Codebase)Object._Proxy.$getProxy((java.lang.Object)tool.getObjectByOid((Store)s, onum)));
        tool.loadCode(codebases);
    }

    private static void handleExport(String[] args) throws IOException {
        if (args.length < 5) {
            System.err.println("Incorrect number of arguments");
            CodebaseTool.showUsage();
            return;
        }
        String baseName = args[2];
        String storeName = args[3];
        RemoteStore s = Worker.getWorker().getStore(storeName);
        CodebaseTool tool = new CodebaseTool(baseName);
        LinkedList<String> rootClasses = new LinkedList<String>();
        for (int i = 4; i < args.length; ++i) {
            rootClasses.add(args[i]);
        }
        Codebase c = tool.storeCode(rootClasses, (Store)s);
        if (c != null) {
            System.out.println("Done storing codebase");
            Worker.runInSubTransaction((Worker.Code)new Worker.Code<Void>((Store)s, c){
                final /* synthetic */ Store val$s;
                final /* synthetic */ Codebase val$c;
                {
                    this.val$s = store;
                    this.val$c = codebase;
                }

                public Void run() {
                    this.val$s.getRoot().put(WrappedJavaInlineable.$wrap((java.lang.Object)"latestCodebase"), (Object)this.val$c);
                    return null;
                }
            });
            System.out.println("Codebase stored to " + tool.getOid((Object)c));
        }
    }

    public CodebaseTool(String basename) {
        this.baseName = basename;
    }

    private void loadCode(final List<Codebase> codebases) {
        Worker.runInSubTransaction((Worker.Code)new Worker.Code<Void>(){

            public Void run() {
                LinkedList<Codebase> codebasesToLoad = new LinkedList<Codebase>(codebases);
                HashSet<Codebase> codebasesLoaded = new HashSet<Codebase>();
                try {
                    while (!codebasesToLoad.isEmpty()) {
                        Codebase current = (Codebase)codebasesToLoad.remove();
                        codebasesLoaded.add(current);
                        Iterator i = current.getClasses().keySet().iterator();
                        while (i.hasNext()) {
                            String className = i.next().toString();
                            FClass cls = current.getClass(className);
                            if (cls.getBytecode().getLength() != 0) {
                                CodebaseTool.this.toFile(cls);
                            }
                            if (!codebasesLoaded.contains(cls.getCodebase())) continue;
                            codebasesToLoad.add(cls.getCodebase());
                            codebasesLoaded.add(current);
                        }
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
                return null;
            }
        });
    }

    private Label getClassLabel(Store s, String className) {
        NodePrincipal p = Worker.getWorker().getPrincipal();
        return LabelUtil._Proxy.toLabel((Store)s, (IntegPolicy)LabelUtil._Proxy.writerPolicy((Store)s, (Principal)p, (Principal)p));
    }

    private Label getCodebaseLabel(Store s) {
        NodePrincipal p = Worker.getWorker().getPrincipal();
        return LabelUtil._Proxy.toLabel((Store)s, (IntegPolicy)LabelUtil._Proxy.writerPolicy((Store)s, (Principal)p, (Principal)p));
    }

    private Codebase storeCode(final List<String> rootClasses, final Store s) throws IOException {
        return (Codebase)Worker.runInSubTransaction((Worker.Code)new Worker.Code<Codebase>(){

            public Codebase run() {
                try {
                    LinkedList<String> classesToCreate = new LinkedList<String>(rootClasses);
                    Label cl = CodebaseTool.this.getCodebaseLabel(s);
                    HashMap classes = (HashMap)new HashMap._Impl(s, cl).$getProxy();
                    HashSet<FClass> toSetCodebase = new HashSet<FClass>();
                    HashSet<String> seenClasses = new HashSet<String>();
                    while (!classesToCreate.isEmpty()) {
                        String[] dependencies;
                        String currentClass = (String)classesToCreate.remove();
                        seenClasses.add(currentClass);
                        String filename = CodebaseTool.this.classNameToFile(currentClass);
                        Label l = CodebaseTool.this.getClassLabel(s, currentClass);
                        byte[] bytecode = CodebaseTool.this.readFile(filename);
                        FClass c = (FClass)new FClass._Impl(s, l, currentClass, CodebaseTool.this.toByteArray(s, l, bytecode)).$getProxy();
                        System.out.println("Crseating class " + currentClass + " at " + CodebaseTool.this.getOid((Object)c));
                        classes.put(WrappedJavaInlineable.$wrap((java.lang.Object)currentClass), (Object)c);
                        toSetCodebase.add(c);
                        if (!CodebaseTool.this.fileExists(filename + ".fabproperties")) {
                            System.out.println(currentClass + " does not contain a .fabproperties file");
                            return null;
                        }
                        Properties classProperties = CodebaseTool.this.readProperties(filename + ".fabproperties");
                        for (String dep : dependencies = classProperties.containsKey("dependencies") ? classProperties.getProperty("dependencies").split(",") : new String[]{}) {
                            if (seenClasses.contains(dep)) continue;
                            seenClasses.add(dep);
                            String file = CodebaseTool.this.classNameToFile(dep);
                            if (!CodebaseTool.this.fileExists(file)) continue;
                            byte[] fileBytecode = CodebaseTool.this.readFile(file);
                            Properties p = CodebaseTool.this.readProperties(file + ".fabproperties");
                            String oid = p.getProperty("oid");
                            FClass depClass = null;
                            if (oid != null) {
                                depClass = (FClass)Object._Proxy.$getProxy((java.lang.Object)CodebaseTool.this.getObjectByOid(oid));
                            }
                            if (depClass == null || !CodebaseTool.this.arrEquals(fileBytecode, depClass.getBytecode())) {
                                classesToCreate.add(dep);
                                continue;
                            }
                            classes.put(WrappedJavaInlineable.$wrap((java.lang.Object)dep), (Object)depClass);
                        }
                    }
                    Codebase codebase = (Codebase)new Codebase._Impl(s, cl, (fabric.util.Map)classes).$getProxy();
                    for (FClass c : toSetCodebase) {
                        c.setCodebase(codebase);
                    }
                    return codebase;
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                    return null;
                }
            }
        });
    }

    private fabric.util.Map toFabMap(Map m, Store s, Label l) {
        fabric.util.Map mn = (fabric.util.Map)new HashMap._Impl(s, l).$getProxy();
        for (java.lang.Object obj : m.keySet()) {
            mn.put(WrappedJavaInlineable.$wrap(obj), WrappedJavaInlineable.$wrap(m.get(obj)));
        }
        return mn;
    }

    private String classNameToFile(String name) {
        return name.replaceAll("\\.", File.separator) + ".class";
    }

    private boolean arrEquals(byte[] a, byteArray b) {
        if (a == null != (b == null)) {
            return false;
        }
        if (a.length != b.getLength()) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b.get(i)) continue;
            return false;
        }
        return true;
    }

    private Object getObjectByOid(Store s, long onum) {
        return new Object._Proxy(s, onum);
    }

    private Object getObjectByOid(String oid) {
        String[] splits = oid.split("\\/");
        if (splits.length != 4) {
            throw new IllegalArgumentException("Malformed oid: " + oid);
        }
        return this.getObjectByOid((Store)Worker.getWorker().getStore(splits[2]), Long.parseLong(splits[3]));
    }

    private String getOid(Object obj) {
        return "fab://" + obj.$getStore().name() + "/" + obj.$getOnum();
    }

    private byte[] toByteArray(byteArray arr) {
        byte[] n = new byte[arr.getLength()];
        for (int i = 0; i < n.length; ++i) {
            n[i] = arr.get(i);
        }
        return n;
    }

    private byteArray toByteArray(Store s, Label l, byte[] arr) {
        byteArray n = (byteArray)new byteArray._Impl(s, l, arr.length).$getProxy();
        for (int i = 0; i < arr.length; ++i) {
            n.set(i, arr[i]);
        }
        return n;
    }

    private void toFile(FClass c) throws IOException {
        String name = c.getName();
        String filename = this.baseName + File.separator + this.classNameToFile(name);
        File f = new File(filename).getParentFile();
        if (f != null) {
            f.mkdirs();
        }
        FileOutputStream str = new FileOutputStream(filename);
        str.write(this.toByteArray(c.getBytecode()));
        str.close();
        String propsFilename = this.classNameToFile(name) + ".fabproperties";
        Properties p = this.fileExists(propsFilename) ? this.readProperties(propsFilename) : new Properties();
        p.setProperty("oid", this.getOid((Object)c));
        this.toFile(p, propsFilename);
    }

    private void toFile(Properties p, String name) throws IOException {
        FileOutputStream fs = new FileOutputStream(this.baseName + File.separator + name);
        p.store(fs, null);
        fs.close();
    }

    private boolean fileExists(String filename) {
        return new File(this.baseName + File.separator + filename).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(String filename) throws IOException {
        File f = new File(this.baseName + File.separator + filename);
        int len = (int)f.length();
        byte[] bytecode = new byte[len];
        FileInputStream in = new FileInputStream(f);
        try {
            for (int i = 0; i < len; ++i) {
                int r = ((InputStream)in).read();
                if (r < 0) {
                    throw new IOException("bytecode shorter than advertised");
                }
                bytecode[i] = (byte)r;
            }
            if (((InputStream)in).read() > 0) {
                throw new IOException("bytecode longer than advertised");
            }
            byte[] byArray = bytecode;
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private Properties readProperties(String file) throws IOException {
        FileInputStream in = new FileInputStream(this.baseName + File.separator + file);
        Properties p = new Properties();
        p.load(in);
        ((InputStream)in).close();
        return p;
    }

    private static void showUsage() {
        System.err.println("Usage:");
        System.err.println("To load a codebase from Fabric to the filesystem");
        System.err.println("    codebasetool import [workername] [storeName] [onum] [exportDir]");
        System.err.println("To store a codebase into Fabric from the filesystem");
        System.err.println("    codebasetool export [workername] [pathToCodebase] [storeName] [classToExport] [...]");
    }
}

