/*
 * Decompiled with CFR 0.152.
 */
package fabric.lang.security;

import fabric.common.TransactionID;
import fabric.lang.Object;
import fabric.lang.WrappedJavaInlineable;
import fabric.lang.security.ActsForProof;
import fabric.lang.security.Capability;
import fabric.lang.security.Closure;
import fabric.lang.security.ConfPolicy;
import fabric.lang.security.ConjunctivePrincipal;
import fabric.lang.security.DelegatesProof;
import fabric.lang.security.DisjunctivePrincipal;
import fabric.lang.security.FromDisjunctProof;
import fabric.lang.security.IntegPolicy;
import fabric.lang.security.Label;
import fabric.lang.security.LabelUtil;
import fabric.lang.security.Principal;
import fabric.lang.security.ReaderPolicy;
import fabric.lang.security.ReflexiveProof;
import fabric.lang.security.SecurityCache;
import fabric.lang.security.ToConjunctProof;
import fabric.lang.security.TransitiveProof;
import fabric.lang.security.WriterPolicy;
import fabric.net.UnreachableNodeException;
import fabric.util.ArrayList;
import fabric.util.Collection;
import fabric.util.LinkedHashSet;
import fabric.worker.AbortException;
import fabric.worker.LocalStore;
import fabric.worker.RetryException;
import fabric.worker.Store;
import fabric.worker.TransactionRestartingException;
import fabric.worker.Worker;
import fabric.worker.transaction.TransactionManager;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public interface PrincipalUtil
extends Object {
    public static final String jlc$CompilerVersion$fabil = "0.1.0";
    public static final long jlc$SourceLastModified$fabil = 1283210021000L;
    public static final String jlc$ClassType$fabil = "H4sIAAAAAAAAAMWae2wcRxnA587ns52Y+JE0CXnZsVPhEHoXQRu1NRAcEytOL/jqSwMxia57e3P2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\njzhDEf7hlbjIUNSR4Hc/NFz3dHtHkV/3/h+0H96qmyMAAA==";

    public static interface _Static
    extends Object,
    Cloneable {

        public static class _Impl
        extends Object._Impl
        implements _Static {
            public _Impl(Store store, Label label) throws UnreachableNodeException {
                super(store, label);
            }

            protected Object._Proxy $makeProxy() {
                return new _Proxy(this);
            }

            private void $init() {
            }
        }

        public static final class _Proxy
        extends Object._Proxy
        implements _Static {
            public static final _Static $instance;

            public _Proxy(_Impl impl) {
                super((Object._Impl)impl);
            }

            public _Proxy(Store store, long onum) {
                super(store, onum);
            }

            static {
                _Impl impl = (_Impl)Object._Static._Proxy.$makeStaticInstance(_Impl.class);
                $instance = (_Static)impl.$getProxy();
                impl.$init();
            }
        }
    }

    public static class _Impl
    extends Object._Impl
    implements PrincipalUtil {
        public static boolean acts_for(Principal p, Principal q) {
            return _Impl.actsFor(p, q);
        }

        public static boolean actsFor(Principal p, Principal q) {
            LocalStore localStore = Worker.getWorker().getLocalStore();
            return !Object._Proxy.idEquals((java.lang.Object)_Impl.actsForProof((Store)localStore, p, q), null);
        }

        public static ActsForProof actsForProof(Store store, Principal p, Principal q) {
            SecurityCache.ActsForPair pair;
            LocalStore localStore = Worker.getWorker().getLocalStore();
            SecurityCache cache = TransactionManager.getInstance().getSecurityCache();
            if (cache.containsActsFor(pair = new SecurityCache.ActsForPair(p, q))) {
                return cache.getActsFor(pair);
            }
            if (cache.containsNotActsFor(pair)) {
                return null;
            }
            if (_Impl.delegatesTo(q, p)) {
                return (DelegatesProof)new DelegatesProof._Impl(store, _Static._Proxy.$instance.get$label(), p, q).$getProxy();
            }
            if (_Impl.eq(p, q)) {
                return (ReflexiveProof)new ReflexiveProof._Impl(store, _Static._Proxy.$instance.get$label(), p, q).$getProxy();
            }
            ActsForProof prf = _Impl.findActsForProof(store, p, q, null);
            if (!Object._Proxy.idEquals((java.lang.Object)prf, null) && _Impl.verifyProof(prf, p, q)) {
                cache.putActsFor(pair, prf);
                HashSet s = new HashSet();
                prf.gatherDelegationDependencies(s);
                for (SecurityCache.DelegationPair del : s) {
                    cache.addActsForDependency(del, pair);
                }
                return prf;
            }
            cache.addNotActsFor(pair);
            return null;
        }

        public static void notifyNewDelegation(Principal granter, Principal superior) {
            if (!_Impl.delegatesTo(granter, superior)) {
                return;
            }
            TransactionManager.getInstance().getSecurityCache().clearNotActsFor();
            LabelUtil._Impl.notifyNewDelegation(granter, superior);
        }

        public static void notifyRevokeDelegation(Principal granter, Principal superior) {
            SecurityCache.DelegationPair del;
            SecurityCache cache = TransactionManager.getInstance().getSecurityCache();
            Set deps = cache.removeActsForDependencies(del = new SecurityCache.DelegationPair(superior, granter));
            if (!Object._Proxy.idEquals((java.lang.Object)deps, null)) {
                for (SecurityCache.ActsForPair afp : deps) {
                    cache.removeActsFor(afp);
                }
            }
            LabelUtil._Impl.notifyRevokeDelegation(granter, superior);
        }

        public static ActsForProof findActsForProof(Store store, Principal p, Principal q, java.lang.Object searchState) {
            ActsForProof prf;
            ProofSearchState newss;
            LocalStore localStore = Worker.getWorker().getLocalStore();
            if (Object._Proxy.idEquals((java.lang.Object)q, null)) {
                return (DelegatesProof)new DelegatesProof._Impl(store, _Static._Proxy.$instance.get$label(), p, q).$getProxy();
            }
            if (_Impl.eq(p, q)) {
                return (ReflexiveProof)new ReflexiveProof._Impl(store, _Static._Proxy.$instance.get$label(), p, q).$getProxy();
            }
            if (Object._Proxy.$getProxy((java.lang.Object)searchState) instanceof ProofSearchState) {
                ProofSearchState ss = (ProofSearchState)Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$wrap((java.lang.Object)searchState));
                if (ss.contains(p, q)) {
                    return null;
                }
                newss = (ProofSearchState)new ProofSearchState._Impl((Store)localStore, _Static._Proxy.$instance.get$label(), ss, p, q).$getProxy();
            } else {
                newss = (ProofSearchState)new ProofSearchState._Impl((Store)localStore, _Static._Proxy.$instance.get$label(), p, q).$getProxy();
            }
            boolean doneDownTo = false;
            if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)p)) instanceof ConjunctivePrincipal || Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)p)) instanceof DisjunctivePrincipal) {
                prf = p.findProofDownto(store, q, WrappedJavaInlineable.$unwrap((Object)newss));
                if (!Object._Proxy.idEquals((java.lang.Object)prf, null)) {
                    return prf;
                }
                doneDownTo = true;
            }
            if (!Object._Proxy.idEquals((java.lang.Object)(prf = q.findProofUpto(store, p, WrappedJavaInlineable.$unwrap((Object)newss))), null)) {
                return prf;
            }
            if (!(doneDownTo || Object._Proxy.idEquals((java.lang.Object)p, null) || Object._Proxy.idEquals((java.lang.Object)(prf = p.findProofDownto(store, q, WrappedJavaInlineable.$unwrap((Object)newss))), null))) {
                return prf;
            }
            return null;
        }

        private static boolean eq(Principal p, Principal q) {
            return Object._Proxy.idEquals((java.lang.Object)p, (java.lang.Object)q) || !Object._Proxy.idEquals((java.lang.Object)p, null) && !Object._Proxy.idEquals((java.lang.Object)q, null) && p.equals(q) && q.equals(p);
        }

        public static boolean verifyProof(ActsForProof prf, Principal actor, Principal granter) {
            if (Object._Proxy.idEquals((java.lang.Object)prf, null)) {
                return false;
            }
            if (!Object._Proxy.idEquals((java.lang.Object)prf.getActor(), (java.lang.Object)actor) || !Object._Proxy.idEquals((java.lang.Object)prf.getGranter(), (java.lang.Object)granter)) {
                return false;
            }
            if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)prf)) instanceof DelegatesProof) {
                return _Impl.delegatesTo(granter, actor);
            }
            if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)prf)) instanceof ReflexiveProof) {
                return _Impl.eq(actor, granter);
            }
            if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)prf)) instanceof TransitiveProof) {
                TransitiveProof proof = (TransitiveProof)Object._Proxy.$getProxy((java.lang.Object)prf);
                return _Impl.verifyProof(proof.getActorToP(), proof.getActor(), proof.getP()) && _Impl.verifyProof(proof.getPToGranter(), proof.getP(), proof.getGranter());
            }
            if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)prf)) instanceof FromDisjunctProof) {
                FromDisjunctProof proof = (FromDisjunctProof)Object._Proxy.$getProxy((java.lang.Object)prf);
                if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)actor)) instanceof DisjunctivePrincipal) {
                    DisjunctivePrincipal dp = (DisjunctivePrincipal)Object._Proxy.$getProxy((java.lang.Object)actor);
                    fabric.util.Iterator iter = dp.get$disjuncts().iterator();
                    while (iter.hasNext()) {
                        Principal disjunct = (Principal)Object._Proxy.$getProxy((java.lang.Object)iter.next());
                        ActsForProof pr = (ActsForProof)Object._Proxy.$getProxy((java.lang.Object)proof.getDisjunctProofs().get((Object)disjunct));
                        if (_Impl.verifyProof(pr, disjunct, granter)) continue;
                        return false;
                    }
                    return true;
                }
            } else if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)prf)) instanceof ToConjunctProof) {
                ToConjunctProof proof = (ToConjunctProof)Object._Proxy.$getProxy((java.lang.Object)prf);
                if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)granter)) instanceof ConjunctivePrincipal) {
                    ConjunctivePrincipal cp = (ConjunctivePrincipal)Object._Proxy.$getProxy((java.lang.Object)granter);
                    fabric.util.Iterator iter = cp.get$conjuncts().iterator();
                    while (iter.hasNext()) {
                        Principal conjunct = (Principal)Object._Proxy.$getProxy((java.lang.Object)iter.next());
                        ActsForProof pr = (ActsForProof)Object._Proxy.$getProxy((java.lang.Object)proof.getConjunctProofs().get((Object)conjunct));
                        if (_Impl.verifyProof(pr, actor, conjunct)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public static boolean delegatesTo(Principal granter, Principal superior) {
            if (Object._Proxy.idEquals((java.lang.Object)granter, null)) {
                return true;
            }
            if (_Impl.isTopPrincipal(superior)) {
                return true;
            }
            if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)superior)) instanceof ConjunctivePrincipal) {
                ConjunctivePrincipal cp = (ConjunctivePrincipal)Object._Proxy.$getProxy((java.lang.Object)superior);
                fabric.util.Iterator iter = cp.get$conjuncts().iterator();
                while (iter.hasNext()) {
                    Principal conjunct = (Principal)Object._Proxy.$getProxy((java.lang.Object)iter.next());
                    if (!_Impl.equals(conjunct, granter)) continue;
                    return true;
                }
            }
            return granter.delegatesTo(superior);
        }

        public static boolean equivalentTo(Principal p, Principal q) {
            boolean eq;
            boolean eq$var30 = eq = false;
            TransactionManager $tm35 = TransactionManager.getInstance();
            boolean $commit32 = false;
            while (!$commit32) {
                $commit32 = true;
                TransactionManager.getInstance().startTransaction();
                try {
                    eq = _Impl.actsFor(p, q) && _Impl.actsFor(q, p);
                }
                catch (RetryException $e33) {
                    $commit32 = false;
                }
                catch (TransactionRestartingException $e33) {
                    $commit32 = false;
                    TransactionID $currentTid34 = $tm35.getCurrentTid();
                    if ($e33.tid.isDescendantOf($currentTid34)) continue;
                    if ($currentTid34.parent != null) {
                        throw $e33;
                    }
                    throw new InternalError("Something is broken with transaction management. Got a signal to restart a different transaction than the one being managed.");
                }
                catch (Throwable $e33) {
                    $commit32 = false;
                    if ($tm35.checkForStaleObjects()) continue;
                    throw new AbortException($e33);
                }
                finally {
                    if ($commit32) {
                        try {
                            TransactionManager.getInstance().commitTransaction();
                        }
                        catch (AbortException $e33) {
                            $commit32 = false;
                        }
                        catch (TransactionRestartingException $e33) {
                            $commit32 = false;
                            TransactionID $currentTid34 = $tm35.getCurrentTid();
                            if ($currentTid34 == null || $e33.tid.isDescendantOf($currentTid34) && !$currentTid34.equals($e33.tid)) continue;
                            throw $e33;
                        }
                    } else {
                        TransactionManager.getInstance().abortTransaction();
                    }
                    if ($commit32) continue;
                    eq = eq$var30;
                }
            }
            return eq;
        }

        public static boolean equals(Principal p, Principal q) {
            return _Impl.eq(p, q);
        }

        public static java.lang.Object execute(Principal p, java.lang.Object authPrf, Closure c, Label lb) {
            LocalStore localStore = Worker.getWorker().getLocalStore();
            Capability cap = _Impl.authorize((Store)localStore, p, authPrf, c, lb, true);
            if (!Object._Proxy.idEquals((java.lang.Object)cap, null)) {
                return cap.invoke();
            }
            return null;
        }

        public static Capability authorize(Store store, Principal p, java.lang.Object authPrf, Closure c, Label lb) {
            return _Impl.authorize(store, p, authPrf, c, lb, false);
        }

        public static Capability authorize(Principal p, java.lang.Object authPrf, Closure c, Label lb) {
            LocalStore localStore = Worker.getWorker().getLocalStore();
            return _Impl.authorize((Store)localStore, p, authPrf, c, lb, false);
        }

        private static Capability authorize(Store store, Principal p, java.lang.Object authPrf, Closure c, Label lb, boolean executeNow) {
            Principal closureP = c.jif$getfabric_lang_security_Closure_P();
            Label closureL = c.jif$getfabric_lang_security_Closure_L();
            if ((Object._Proxy.idEquals((java.lang.Object)closureP, (java.lang.Object)p) || !Object._Proxy.idEquals((java.lang.Object)p, null) && !Object._Proxy.idEquals((java.lang.Object)closureP, null) && p.equals(closureP) && closureP.equals(p)) && LabelUtil._Impl.equivalentTo(closureL, lb) && (Object._Proxy.idEquals((java.lang.Object)p, null) || p.isAuthorized(authPrf, c, lb, executeNow))) {
                return (Capability)new Capability._Impl(store, _Static._Proxy.$instance.get$label(), closureP, closureL, c).$getProxy();
            }
            return null;
        }

        public static Principal nullPrincipal() {
            return null;
        }

        public static Principal bottomPrincipal() {
            return _Impl.nullPrincipal();
        }

        public static Principal bottomPrincipal(Store c) {
            return _Impl.bottomPrincipal();
        }

        public static Principal topPrincipal() {
            LocalStore localStore = Worker.getWorker().getLocalStore();
            return localStore.getTopPrincipal();
        }

        public static Principal topPrincipal(Store store) {
            LocalStore localStore = Worker.getWorker().getLocalStore();
            return localStore.getTopPrincipal();
        }

        public static boolean isTopPrincipal(Principal p) {
            return Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)p)) instanceof TopPrincipal;
        }

        public static ConfPolicy readableByPrinPolicy(Principal p) {
            LocalStore localStore = Worker.getWorker().getLocalStore();
            return _Impl.readableByPrinPolicy((Store)localStore, p);
        }

        public static ConfPolicy readableByPrinPolicy(Store store, Principal p) {
            return (ReaderPolicy)new ReaderPolicy._Impl(store, _Static._Proxy.$instance.get$label(), _Impl.topPrincipal(), p).$getProxy();
        }

        public static IntegPolicy writableByPrinPolicy(Principal p) {
            LocalStore localStore = Worker.getWorker().getLocalStore();
            return _Impl.writableByPrinPolicy((Store)localStore, p);
        }

        public static IntegPolicy writableByPrinPolicy(Store store, Principal p) {
            return (WriterPolicy)new WriterPolicy._Impl(store, _Static._Proxy.$instance.get$label(), _Impl.topPrincipal(), p).$getProxy();
        }

        public static Principal disjunction(Principal left, Principal right) {
            LocalStore store = Worker.getWorker().getLocalStore();
            return _Impl.disjunction((Store)store, left, right);
        }

        public static Principal disjunction(Store store, Principal left, Principal right) {
            if (Object._Proxy.idEquals((java.lang.Object)left, null) || Object._Proxy.idEquals((java.lang.Object)right, null)) {
                return null;
            }
            if (_Impl.actsFor(left, right)) {
                return right;
            }
            if (_Impl.actsFor(right, left)) {
                return left;
            }
            ArrayList c = (ArrayList)new ArrayList._Impl(store, _Static._Proxy.$instance.get$label(), 2).$getProxy();
            c.add((Object)left);
            c.add((Object)right);
            return _Impl.disjunction(store, c);
        }

        public static Principal conjunction(Principal left, Principal right) {
            LocalStore store = Worker.getWorker().getLocalStore();
            return _Impl.conjunction((Store)store, left, right);
        }

        public static Principal conjunction(Store store, Principal left, Principal right) {
            if (Object._Proxy.idEquals((java.lang.Object)left, null)) {
                return right;
            }
            if (Object._Proxy.idEquals((java.lang.Object)right, null)) {
                return left;
            }
            if (_Impl.actsFor(left, right)) {
                return left;
            }
            if (_Impl.actsFor(right, left)) {
                return right;
            }
            ArrayList c = (ArrayList)new ArrayList._Impl(store, _Static._Proxy.$instance.get$label(), 2).$getProxy();
            c.add((Object)left);
            c.add((Object)right);
            return _Impl.conjunction(store, c);
        }

        public static Principal disjunction(Collection principals) {
            LocalStore store = Worker.getWorker().getLocalStore();
            return _Impl.disjunction((Store)store, principals);
        }

        public static Principal disjunction(Store store, Collection principals) {
            if (Object._Proxy.idEquals((java.lang.Object)principals, null) || principals.isEmpty()) {
                return _Impl.topPrincipal();
            }
            LocalStore localStore = Worker.getWorker().getLocalStore();
            if (principals.size() == 1) {
                Object o = principals.iterator((Store)localStore).next();
                if (Object._Proxy.idEquals((java.lang.Object)o, null) || Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)o)) instanceof Principal) {
                    return (Principal)Object._Proxy.$getProxy((java.lang.Object)o);
                }
                return _Impl.topPrincipal();
            }
            LinkedHashSet needed = (LinkedHashSet)new LinkedHashSet._Impl(store, _Static._Proxy.$instance.get$label()).$getProxy();
            fabric.util.Iterator iter = principals.iterator((Store)localStore);
            while (iter.hasNext()) {
                Object o = iter.next();
                Principal p = null;
                if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)o)) instanceof Principal) {
                    p = (Principal)Object._Proxy.$getProxy((java.lang.Object)o);
                }
                if (Object._Proxy.idEquals(p, null)) {
                    return p;
                }
                if (_Impl.isTopPrincipal(p)) continue;
                if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)p)) instanceof DisjunctivePrincipal) {
                    needed.addAll(((DisjunctivePrincipal)Object._Proxy.$getProxy((java.lang.Object)p)).get$disjuncts());
                    continue;
                }
                needed.add((Object)p);
            }
            return (DisjunctivePrincipal)new DisjunctivePrincipal._Impl(store, null, needed).$getProxy();
        }

        public static Principal conjunction(Collection principals) {
            LocalStore store = Worker.getWorker().getLocalStore();
            return _Impl.conjunction((Store)store, principals);
        }

        public static Principal conjunction(Store store, Collection principals) {
            if (Object._Proxy.idEquals((java.lang.Object)principals, null) || principals.isEmpty()) {
                return _Impl.bottomPrincipal();
            }
            LocalStore localStore = Worker.getWorker().getLocalStore();
            if (principals.size() == 1) {
                Object o = principals.iterator((Store)localStore).next();
                if (Object._Proxy.idEquals((java.lang.Object)o, null) || Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)o)) instanceof Principal) {
                    return (Principal)Object._Proxy.$getProxy((java.lang.Object)o);
                }
                return _Impl.bottomPrincipal();
            }
            LinkedHashSet needed = (LinkedHashSet)new LinkedHashSet._Impl(store, _Static._Proxy.$instance.get$label()).$getProxy();
            fabric.util.Iterator iter = principals.iterator((Store)localStore);
            while (iter.hasNext()) {
                Object o = iter.next();
                Principal p = null;
                if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)o)) instanceof Principal) {
                    p = (Principal)Object._Proxy.$getProxy((java.lang.Object)o);
                }
                if (Object._Proxy.idEquals(p, null)) continue;
                if (_Impl.isTopPrincipal(p)) {
                    return p;
                }
                if (Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)p)) instanceof ConjunctivePrincipal) {
                    needed.addAll(((ConjunctivePrincipal)Object._Proxy.$getProxy((java.lang.Object)p)).get$conjuncts());
                    continue;
                }
                needed.add((Object)p);
            }
            return (ConjunctivePrincipal)new ConjunctivePrincipal._Impl(store, null, needed).$getProxy();
        }

        public static String toString(Principal p) {
            return Object._Proxy.idEquals((java.lang.Object)p, null) ? "_" : p.name();
        }

        public static String stringValue(Principal p) {
            return _Impl.toString(p);
        }

        public _Impl(Store $location, Label $label) {
            super($location, $label);
        }

        protected Object._Proxy $makeProxy() {
            return new _Proxy(this);
        }

        public void $serialize(ObjectOutput out, List refTypes, List intraStoreRefs, List interStoreRefs) throws IOException {
            super.$serialize(out, refTypes, intraStoreRefs, interStoreRefs);
        }

        public _Impl(Store store, long onum, int version, long expiry, long label, ObjectInput in, Iterator refTypes, Iterator intraStoreRefs) throws IOException, ClassNotFoundException {
            super(store, onum, version, expiry, label, in, refTypes, intraStoreRefs);
        }
    }

    public static class _Proxy
    extends Object._Proxy
    implements PrincipalUtil {
        public static boolean acts_for(Principal arg1, Principal arg2) {
            return _Impl.acts_for(arg1, arg2);
        }

        public static boolean actsFor(Principal arg1, Principal arg2) {
            return _Impl.actsFor(arg1, arg2);
        }

        public static ActsForProof actsForProof(Store arg1, Principal arg2, Principal arg3) {
            return _Impl.actsForProof(arg1, arg2, arg3);
        }

        public static void notifyNewDelegation(Principal arg1, Principal arg2) {
            _Impl.notifyNewDelegation(arg1, arg2);
        }

        public static void notifyRevokeDelegation(Principal arg1, Principal arg2) {
            _Impl.notifyRevokeDelegation(arg1, arg2);
        }

        public static ActsForProof findActsForProof(Store arg1, Principal arg2, Principal arg3, java.lang.Object arg4) {
            return _Impl.findActsForProof(arg1, arg2, arg3, arg4);
        }

        public static boolean verifyProof(ActsForProof arg1, Principal arg2, Principal arg3) {
            return _Impl.verifyProof(arg1, arg2, arg3);
        }

        public static boolean delegatesTo(Principal arg1, Principal arg2) {
            return _Impl.delegatesTo(arg1, arg2);
        }

        public static boolean equivalentTo(Principal arg1, Principal arg2) {
            return _Impl.equivalentTo(arg1, arg2);
        }

        public static boolean equals(Principal arg1, Principal arg2) {
            return _Impl.equals(arg1, arg2);
        }

        public static java.lang.Object execute(Principal arg1, java.lang.Object arg2, Closure arg3, Label arg4) {
            return _Impl.execute(arg1, arg2, arg3, arg4);
        }

        public static Capability authorize(Store arg1, Principal arg2, java.lang.Object arg3, Closure arg4, Label arg5) {
            return _Impl.authorize(arg1, arg2, arg3, arg4, arg5);
        }

        public static Capability authorize(Principal arg1, java.lang.Object arg2, Closure arg3, Label arg4) {
            return _Impl.authorize(arg1, arg2, arg3, arg4);
        }

        public static Principal nullPrincipal() {
            return _Impl.nullPrincipal();
        }

        public static Principal bottomPrincipal() {
            return _Impl.bottomPrincipal();
        }

        public static Principal bottomPrincipal(Store arg1) {
            return _Impl.bottomPrincipal(arg1);
        }

        public static Principal topPrincipal() {
            return _Impl.topPrincipal();
        }

        public static Principal topPrincipal(Store arg1) {
            return _Impl.topPrincipal(arg1);
        }

        public static boolean isTopPrincipal(Principal arg1) {
            return _Impl.isTopPrincipal(arg1);
        }

        public static ConfPolicy readableByPrinPolicy(Principal arg1) {
            return _Impl.readableByPrinPolicy(arg1);
        }

        public static ConfPolicy readableByPrinPolicy(Store arg1, Principal arg2) {
            return _Impl.readableByPrinPolicy(arg1, arg2);
        }

        public static IntegPolicy writableByPrinPolicy(Principal arg1) {
            return _Impl.writableByPrinPolicy(arg1);
        }

        public static IntegPolicy writableByPrinPolicy(Store arg1, Principal arg2) {
            return _Impl.writableByPrinPolicy(arg1, arg2);
        }

        public static Principal disjunction(Principal arg1, Principal arg2) {
            return _Impl.disjunction(arg1, arg2);
        }

        public static Principal disjunction(Store arg1, Principal arg2, Principal arg3) {
            return _Impl.disjunction(arg1, arg2, arg3);
        }

        public static Principal conjunction(Principal arg1, Principal arg2) {
            return _Impl.conjunction(arg1, arg2);
        }

        public static Principal conjunction(Store arg1, Principal arg2, Principal arg3) {
            return _Impl.conjunction(arg1, arg2, arg3);
        }

        public static Principal disjunction(Collection arg1) {
            return _Impl.disjunction(arg1);
        }

        public static Principal disjunction(Store arg1, Collection arg2) {
            return _Impl.disjunction(arg1, arg2);
        }

        public static Principal conjunction(Collection arg1) {
            return _Impl.conjunction(arg1);
        }

        public static Principal conjunction(Store arg1, Collection arg2) {
            return _Impl.conjunction(arg1, arg2);
        }

        public static String toString(Principal arg1) {
            return _Impl.toString(arg1);
        }

        public static String stringValue(Principal arg1) {
            return _Impl.stringValue(arg1);
        }

        public _Proxy(_Impl impl) {
            super((Object._Impl)impl);
        }

        public _Proxy(Store store, long onum) {
            super(store, onum);
        }
    }

    public static interface TopPrincipal
    extends Principal {
        public static final String jlc$CompilerVersion$fabil = "0.1.0";
        public static final long jlc$SourceLastModified$fabil = 1283210021000L;
        public static final String jlc$ClassType$fabil = "H4sIAAAAAAAAAJ1XXWxURRSe3W23LV0t25bS0NI/CoGgu75Ion3QWmgoLKG0JUKFLLP3zm4vnb1z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\nvg6yDgAA";

        public String name();

        public boolean delegatesTo(Principal var1);

        public boolean equals(Principal var1);

        public boolean isAuthorized(java.lang.Object var1, Closure var2, Label var3, boolean var4);

        public ActsForProof findProofUpto(Store var1, Principal var2, java.lang.Object var3);

        public ActsForProof findProofDownto(Store var1, Principal var2, java.lang.Object var3);

        public static interface _Static
        extends Object,
        Cloneable {

            public static class _Impl
            extends Object._Impl
            implements _Static {
                public _Impl(Store store, Label label) throws UnreachableNodeException {
                    super(store, label);
                }

                protected Object._Proxy $makeProxy() {
                    return new _Proxy(this);
                }

                private void $init() {
                }
            }

            public static final class _Proxy
            extends Object._Proxy
            implements _Static {
                public static final _Static $instance;

                public _Proxy(_Impl impl) {
                    super((Object._Impl)impl);
                }

                public _Proxy(Store store, long onum) {
                    super(store, onum);
                }

                static {
                    _Impl impl = (_Impl)Object._Static._Proxy.$makeStaticInstance(_Impl.class);
                    $instance = (_Static)impl.$getProxy();
                    impl.$init();
                }
            }
        }

        public static final class _Impl
        extends Principal._Impl
        implements TopPrincipal {
            public _Impl(Store $location, Label $label) {
                super($location, $label);
            }

            @Override
            public String name() {
                return "*";
            }

            @Override
            public boolean delegatesTo(Principal p) {
                return false;
            }

            @Override
            public boolean equals(Principal p) {
                return Object._Proxy.$getProxy((java.lang.Object)WrappedJavaInlineable.$unwrap((Object)p)) instanceof TopPrincipal;
            }

            @Override
            public boolean isAuthorized(java.lang.Object authPrf, Closure closure, Label lb, boolean executeNow) {
                return false;
            }

            @Override
            public ActsForProof findProofUpto(Store store, Principal p, java.lang.Object searchState) {
                return null;
            }

            @Override
            public ActsForProof findProofDownto(Store store, Principal q, java.lang.Object searchState) {
                return null;
            }

            protected Object._Proxy $makeProxy() {
                return new _Proxy(this);
            }

            public void $serialize(ObjectOutput out, List refTypes, List intraStoreRefs, List interStoreRefs) throws IOException {
                super.$serialize(out, refTypes, intraStoreRefs, interStoreRefs);
            }

            public _Impl(Store store, long onum, int version, long expiry, long label, ObjectInput in, Iterator refTypes, Iterator intraStoreRefs) throws IOException, ClassNotFoundException {
                super(store, onum, version, expiry, label, in, refTypes, intraStoreRefs);
            }
        }

        public static class _Proxy
        extends Principal._Proxy
        implements TopPrincipal {
            public _Proxy(_Impl impl) {
                super((Principal._Impl)impl);
            }

            public _Proxy(Store store, long onum) {
                super(store, onum);
            }
        }
    }

    public static interface ProofSearchState
    extends Object {
        public static final String jlc$CompilerVersion$fabil = "0.1.0";
        public static final long jlc$SourceLastModified$fabil = 1283210021000L;
        public static final String jlc$ClassType$fabil = "H4sIAAAAAAAAAI1Xb2wURRSfu2uv/07bK1AILbSUYiDonVEhYj9g09BQOMLZoyhVPOb25u6W7u2u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\n2a9I9t0M7ksldgZfAvBXzvEaRFpy8Ld9pnvo9nItTh7+D7y4N+JaDwAA";

        public SecurityCache.ActsForPair[] get$goalstack();

        public SecurityCache.ActsForPair[] set$goalstack(SecurityCache.ActsForPair[] var1);

        public boolean contains(Principal var1, Principal var2);

        public static interface _Static
        extends Object,
        Cloneable {

            public static class _Impl
            extends Object._Impl
            implements _Static {
                public _Impl(Store store, Label label) throws UnreachableNodeException {
                    super(store, label);
                }

                protected Object._Proxy $makeProxy() {
                    return new _Proxy(this);
                }

                private void $init() {
                }
            }

            public static final class _Proxy
            extends Object._Proxy
            implements _Static {
                public static final _Static $instance;

                public _Proxy(_Impl impl) {
                    super((Object._Impl)impl);
                }

                public _Proxy(Store store, long onum) {
                    super(store, onum);
                }

                static {
                    _Impl impl = (_Impl)Object._Static._Proxy.$makeStaticInstance(_Impl.class);
                    $instance = (_Static)impl.$getProxy();
                    impl.$init();
                }
            }
        }

        public static class _Impl
        extends Object._Impl
        implements ProofSearchState {
            private SecurityCache.ActsForPair[] goalstack;

            @Override
            public SecurityCache.ActsForPair[] get$goalstack() {
                TransactionManager.getInstance().registerRead((Object._Impl)this);
                return this.goalstack;
            }

            @Override
            public SecurityCache.ActsForPair[] set$goalstack(SecurityCache.ActsForPair[] val) {
                TransactionManager tm = TransactionManager.getInstance();
                boolean transactionCreated = tm.registerWrite((Object._Impl)this);
                this.goalstack = val;
                if (transactionCreated) {
                    tm.commitTransaction();
                }
                return val;
            }

            public _Impl(Store $location, Label $label, Principal p, Principal q) {
                super($location, $label);
                this.set$goalstack(new SecurityCache.ActsForPair[1]);
                this.get$goalstack()[0] = new SecurityCache.ActsForPair(p, q);
            }

            private _Impl(Store $location, Label $label, ProofSearchState ss, Principal p, Principal q) {
                super($location, $label);
                int len = ss.get$goalstack().length + 1;
                this.set$goalstack(new SecurityCache.ActsForPair[len]);
                for (int i = 0; i < len - 1; ++i) {
                    this.get$goalstack()[i] = ss.get$goalstack()[i];
                }
                this.get$goalstack()[len - 1] = new SecurityCache.ActsForPair(p, q);
            }

            @Override
            public boolean contains(Principal p, Principal q) {
                for (int i = 0; i < this.get$goalstack().length; ++i) {
                    if (Object._Proxy.idEquals((java.lang.Object)this.get$goalstack()[i], null) || !fabric.lang.security.PrincipalUtil$_Impl.eq(this.get$goalstack()[i].p, p) || !fabric.lang.security.PrincipalUtil$_Impl.eq(this.get$goalstack()[i].q, q)) continue;
                    return true;
                }
                return false;
            }

            protected Object._Proxy $makeProxy() {
                return new _Proxy(this);
            }

            public void $serialize(ObjectOutput out, List refTypes, List intraStoreRefs, List interStoreRefs) throws IOException {
                super.$serialize(out, refTypes, intraStoreRefs, interStoreRefs);
            }

            public _Impl(Store store, long onum, int version, long expiry, long label, ObjectInput in, Iterator refTypes, Iterator intraStoreRefs) throws IOException, ClassNotFoundException {
                super(store, onum, version, expiry, label, in, refTypes, intraStoreRefs);
            }

            public void $copyAppStateFrom(Object._Impl other) {
                super.$copyAppStateFrom(other);
                _Impl src = (_Impl)other;
                this.goalstack = src.goalstack;
            }
        }

        public static class _Proxy
        extends Object._Proxy
        implements ProofSearchState {
            @Override
            public SecurityCache.ActsForPair[] get$goalstack() {
                return ((_Impl)this.fetch()).get$goalstack();
            }

            @Override
            public SecurityCache.ActsForPair[] set$goalstack(SecurityCache.ActsForPair[] val) {
                return ((_Impl)this.fetch()).set$goalstack(val);
            }

            @Override
            public boolean contains(Principal arg1, Principal arg2) {
                return ((ProofSearchState)this.fetch()).contains(arg1, arg2);
            }

            public _Proxy(_Impl impl) {
                super((Object._Impl)impl);
            }

            public _Proxy(Store store, long onum) {
                super(store, onum);
            }
        }
    }
}

