/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.transaction;

import fabric.common.TransactionID;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.worker.Store;
import fabric.worker.transaction.Log;

public final class TransactionRegistry {
    private static final LongKeyMap<Log> registry = new LongKeyHashMap<Log>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getInnermostLog(long tid) {
        Log log;
        LongKeyMap<Log> longKeyMap = registry;
        synchronized (longKeyMap) {
            log = registry.get(tid);
        }
        if (log == null) {
            return null;
        }
        return TransactionRegistry.innermostLog(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getOrCreateInnermostLog(TransactionID tid) {
        Log log;
        if (tid == null) {
            return null;
        }
        LongKeyMap<Log> longKeyMap = registry;
        synchronized (longKeyMap) {
            log = registry.get(tid.topTid);
            if (log == null) {
                log = new Log(tid);
            }
        }
        return TransactionRegistry.innermostLog(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Log log) {
        LongKeyMap<Log> longKeyMap = registry;
        synchronized (longKeyMap) {
            if (registry.get(log.tid.topTid) != null) {
                throw new InternalError("Attempted to register a transaction log whose top-level tid conflicts with a previously registered log.");
            }
            registry.put(log.tid.topTid, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(long topTid) {
        LongKeyMap<Log> longKeyMap = registry;
        synchronized (longKeyMap) {
            registry.remove(topTid);
        }
    }

    private static Log innermostLog(Log log) {
        Log child = log.getChild();
        while (child != null) {
            log = child;
            child = log.getChild();
        }
        return log;
    }

    public static void renumberObject(Store store, long onum, long newOnum) {
        for (Log log : registry.values()) {
            log.renumberObject(store, onum, newOnum);
        }
    }
}

