/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.transaction;

import fabric.common.FabricThread;
import fabric.common.Logging;
import fabric.common.SerializedObject;
import fabric.common.TransactionID;
import fabric.common.exceptions.InternalError;
import fabric.common.util.LongKeyMap;
import fabric.common.util.OidKeyHashMap;
import fabric.common.util.WeakReferenceArrayList;
import fabric.lang.Object;
import fabric.lang.security.Label;
import fabric.lang.security.SecurityCache;
import fabric.net.RemoteNode;
import fabric.net.UnreachableNodeException;
import fabric.store.InProcessStore;
import fabric.worker.AbortException;
import fabric.worker.FabricSoftRef;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.TransactionAbortingException;
import fabric.worker.TransactionAtomicityViolationException;
import fabric.worker.TransactionCommitFailedException;
import fabric.worker.TransactionPrepareFailedException;
import fabric.worker.TransactionRestartingException;
import fabric.worker.Worker;
import fabric.worker.debug.Timing;
import fabric.worker.remote.RemoteWorker;
import fabric.worker.remote.UpdateMap;
import fabric.worker.transaction.Log;
import fabric.worker.transaction.ReadMapEntry;
import fabric.worker.transaction.TransactionRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;

public final class TransactionManager {
    private Log current = null;
    static final OidKeyHashMap<ReadMapEntry> readMap = new OidKeyHashMap();
    private static final Map<Thread, TransactionManager> instanceMap = new WeakHashMap<Thread, TransactionManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ReadMapEntry getReadMapEntry(Object._Impl impl, long expiry) {
        ReadMapEntry result;
        FabricSoftRef ref = impl.$ref;
        if (ref.store.isLocalStore()) {
            return new ReadMapEntry(impl, expiry);
        }
        while (true) {
            Object object = readMap;
            // MONITORENTER : object
            result = readMap.get(ref.store, ref.onum);
            if (result == null) {
                result = new ReadMapEntry(impl, expiry);
                readMap.put(ref.store, ref.onum, result);
                // MONITOREXIT : object
                return result;
            }
            // MONITOREXIT : object
            object = result;
            // MONITORENTER : object
            OidKeyHashMap<ReadMapEntry> oidKeyHashMap = readMap;
            // MONITORENTER : oidKeyHashMap
            if (result == readMap.get(ref.store, ref.onum)) break;
            // MONITOREXIT : oidKeyHashMap
            // MONITOREXIT : object
        }
        result.obj = impl.$ref;
        ++result.pinCount;
        result.promise = result.promise > expiry ? result.promise : expiry;
        int ver = impl.$getVersion();
        if (ver == result.versionNumber) {
            // MONITOREXIT : oidKeyHashMap
            // MONITOREXIT : object
            return result;
        }
        Iterator<Log> i$ = result.readLocks.iterator();
        while (true) {
            if (!i$.hasNext()) {
                result.versionNumber = ver;
                // MONITOREXIT : oidKeyHashMap
                // MONITOREXIT : object
                return result;
            }
            Log reader = i$.next();
            reader.flagRetry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionManager getInstance() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FabricThread) {
            FabricThread ft = (FabricThread)((Object)thread);
            TransactionManager result = ft.getTransactionManager();
            if (result == null) {
                result = new TransactionManager();
                ft.setTransactionManager(result);
            }
            return result;
        }
        Map<Thread, TransactionManager> map = instanceMap;
        synchronized (map) {
            TransactionManager result = instanceMap.get(thread);
            if (result == null) {
                result = new TransactionManager();
                instanceMap.put(thread, result);
            }
            return result;
        }
    }

    private TransactionManager() {
    }

    private void checkRetrySignal() {
        if (this.current.retrySignal != null) {
            Log log = this.current;
            synchronized (log) {
                Logging.WORKER_TRANSACTION_LOGGER.log(Level.FINEST, "{0} got retry signal", this.current);
                throw new TransactionRestartingException(this.current.retrySignal);
            }
        }
    }

    public void abortTransaction() {
        this.abortTransaction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortTransaction(boolean recurseToCohorts) {
        Log.CommitState commitState;
        if (this.current.tid.depth == 0) {
            commitState = this.current.commitState;
            synchronized (commitState) {
                while (this.current.commitState.value == Log.CommitState.Values.PREPARING) {
                    try {
                        this.current.commitState.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                switch (this.current.commitState.value) {
                    case UNPREPARED: 
                    case PREPARE_FAILED: 
                    case PREPARED: {
                        this.current.commitState.value = Log.CommitState.Values.ABORTING;
                        break;
                    }
                    case PREPARING: {
                        throw new InternalError();
                    }
                    case COMMITTING: 
                    case COMMITTED: {
                        Logging.WORKER_TRANSACTION_LOGGER.warning("Ignoring attempt to abort a committed transaction.");
                        return;
                    }
                    case ABORTING: 
                    case ABORTED: {
                        return;
                    }
                }
            }
        }
        Logging.WORKER_TRANSACTION_LOGGER.warning(this.current + " aborting");
        this.current.flagRetry();
        this.current.waitForThreads();
        if (recurseToCohorts) {
            this.sendAbortMessages();
        }
        this.current.abort();
        Logging.WORKER_TRANSACTION_LOGGER.warning(this.current + " aborted");
        commitState = this.current.commitState;
        synchronized (commitState) {
            if (this.current.tid.depth == 0) {
                this.current.commitState.value = Log.CommitState.Values.ABORTED;
                this.current.commitState.notifyAll();
            }
            if (this.current.tid.parent == null || this.current.parent != null && this.current.parent.tid.equals(this.current.tid.parent)) {
                this.current = this.current.parent;
            } else {
                this.current.tid = this.current.tid.parent;
            }
        }
    }

    public void commitTransaction() throws AbortException, TransactionRestartingException, TransactionAtomicityViolationException {
        this.commitTransaction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(boolean useAuthentication) throws AbortException, TransactionRestartingException, TransactionAtomicityViolationException {
        Timing.COMMIT.begin();
        try {
            this.commitTransactionAt(System.currentTimeMillis(), useAuthentication, false);
        }
        finally {
            Timing.COMMIT.end();
        }
    }

    public void commitTransactionAt(long commitTime) throws AbortException, TransactionRestartingException {
        this.commitTransactionAt(commitTime, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTransactionAt(long commitTime, boolean useAuthentication, boolean ignoreRetrySignal) throws AbortException, TransactionRestartingException {
        Logging.WORKER_TRANSACTION_LOGGER.log(Level.FINEST, "{0} attempting to commit", this.current);
        this.current.waitForThreads();
        TransactionID ignoredRetrySignal = null;
        if (!ignoreRetrySignal) {
            try {
                this.checkRetrySignal();
            }
            catch (TransactionAbortingException e) {
                this.abortTransaction();
                throw new AbortException();
            }
            catch (TransactionRestartingException e) {
                this.abortTransaction();
                throw e;
            }
        }
        Log e = this.current;
        synchronized (e) {
            ignoredRetrySignal = this.current.retrySignal;
        }
        Logging.WORKER_TRANSACTION_LOGGER.log(Level.FINEST, "{0} committing", this.current);
        Log parent = this.current.parent;
        if (this.current.tid.parent != null) {
            try {
                Timing.SUBTX.begin();
                this.current.commitNested();
                Logging.WORKER_TRANSACTION_LOGGER.log(Level.FINEST, "{0} committed", this.current);
                if (parent != null && parent.tid.equals(this.current.tid.parent)) {
                    this.current = parent;
                } else {
                    this.current.tid = this.current.tid.parent;
                }
                if (ignoredRetrySignal != null) {
                    Log log = this.current;
                    synchronized (log) {
                        TransactionID signal = ignoredRetrySignal;
                        if (this.current.retrySignal != null && (signal = signal.getLowestCommonAncestor(this.current.retrySignal)) == null) {
                            throw new InternalError("Something is broken with transaction management. Found retry signals for different transactions in the same log. (In transaction " + this.current.tid + ".  Retry1=" + this.current.retrySignal + "; Retry2=" + ignoredRetrySignal);
                        }
                        this.current.retrySignal = signal;
                    }
                }
                return;
            }
            finally {
                Timing.SUBTX.end();
            }
        }
        this.current.removePromisedReads(commitTime);
        Set<Store> stores = this.current.storesToContact();
        List<RemoteWorker> workers = this.current.workersCalled;
        this.sendPrepareMessages(useAuthentication, commitTime, stores, workers);
        this.sendCommitMessagesAndCleanUp(useAuthentication, stores, workers);
    }

    public void sendPrepareMessages(long commitTime) {
        this.sendPrepareMessages(true, commitTime, this.current.storesToContact(), this.current.workersCalled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPrepareMessages(final boolean useAuthentication, final long commitTime, Set<Store> stores, List<RemoteWorker> workers) {
        final Map<RemoteNode, TransactionPrepareFailedException> failures = Collections.synchronizedMap(new HashMap());
        Log.CommitState commitState = this.current.commitState;
        synchronized (commitState) {
            switch (this.current.commitState.value) {
                case UNPREPARED: {
                    this.current.commitState.value = Log.CommitState.Values.PREPARING;
                    break;
                }
                case PREPARED: 
                case PREPARING: {
                    return;
                }
                case COMMITTING: 
                case COMMITTED: {
                    Logging.WORKER_TRANSACTION_LOGGER.log(Level.FINE, "Ignoring prepare request (transaction state = {0})", (Object)this.current.commitState.value);
                    return;
                }
                case PREPARE_FAILED: 
                case ABORTING: 
                case ABORTED: {
                    failures.put(null, null);
                    this.abortPrepare(failures);
                }
            }
        }
        ArrayList<Thread> threads = new ArrayList<Thread>(stores.size() + workers.size());
        for (final RemoteWorker worker : workers) {
            Thread thread = new Thread("worker prepare to " + worker.name()){

                @Override
                public void run() {
                    try {
                        worker.prepareTransaction(((TransactionManager)TransactionManager.this).current.tid.topTid, commitTime);
                    }
                    catch (UnreachableNodeException e) {
                        failures.put(worker, new TransactionPrepareFailedException("Unreachable worker"));
                    }
                    catch (TransactionPrepareFailedException e) {
                        failures.put(worker, new TransactionPrepareFailedException(e.getMessage()));
                    }
                    catch (TransactionRestartingException e) {
                        failures.put(worker, new TransactionPrepareFailedException("transaction restarting"));
                    }
                }
            };
            thread.start();
            threads.add(thread);
        }
        final Worker worker = Worker.getWorker();
        Iterator<Store> storeIt = stores.iterator();
        while (storeIt.hasNext()) {
            final Store store = storeIt.next();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block6: {
                        try {
                            Collection<Object._Impl> creates = TransactionManager.this.current.getCreatesForStore(store);
                            LongKeyMap<Integer> reads = TransactionManager.this.current.getReadsForStore(store, false);
                            Collection<Object._Impl> writes = TransactionManager.this.current.getWritesForStore(store);
                            boolean subTransactionCreated = store.prepareTransaction(useAuthentication, ((TransactionManager)TransactionManager.this).current.tid.topTid, commitTime, creates, reads, writes);
                            if (!subTransactionCreated) break block6;
                            RemoteWorker storeWorker = worker.getWorker(store.name());
                            List<RemoteWorker> list = ((TransactionManager)TransactionManager.this).current.workersCalled;
                            synchronized (list) {
                                ((TransactionManager)TransactionManager.this).current.workersCalled.add(storeWorker);
                            }
                        }
                        catch (TransactionPrepareFailedException e) {
                            failures.put((RemoteNode)((Object)store), e);
                        }
                        catch (UnreachableNodeException e) {
                            failures.put((RemoteNode)((Object)store), new TransactionPrepareFailedException("Unreachable store"));
                        }
                    }
                }
            };
            if (!(store instanceof InProcessStore) && !store.isLocalStore() && storeIt.hasNext()) {
                Thread thread = new Thread(runnable, "worker prepare to " + store.name());
                threads.add(thread);
                thread.start();
                continue;
            }
            runnable.run();
        }
        block19: for (Thread thread : threads) {
            while (true) {
                try {
                    thread.join();
                    continue block19;
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        if (!failures.isEmpty()) {
            String logMessage = "Transaction tid=" + this.current.tid.topTid + ":  prepare failed.";
            for (Map.Entry<RemoteNode, TransactionPrepareFailedException> entry : failures.entrySet()) {
                if (entry.getKey() instanceof RemoteStore) {
                    RemoteStore store = (RemoteStore)entry.getKey();
                    LongKeyMap<SerializedObject> versionConflicts = entry.getValue().versionConflicts;
                    if (versionConflicts != null) {
                        for (SerializedObject obj : versionConflicts.values()) {
                            store.updateCache(obj);
                        }
                    }
                }
                if (!Logging.WORKER_TRANSACTION_LOGGER.isLoggable(Level.FINE)) continue;
                logMessage = logMessage + "\n\t" + entry.getKey() + ": " + entry.getValue().getMessage();
            }
            Logging.WORKER_TRANSACTION_LOGGER.fine(logMessage);
            this.sendAbortMessages(useAuthentication, stores, workers, failures.keySet());
            Log.CommitState commitState2 = this.current.commitState;
            synchronized (commitState2) {
                this.current.commitState.value = Log.CommitState.Values.PREPARE_FAILED;
                this.current.commitState.notifyAll();
            }
            this.abortPrepare(failures);
        } else {
            Log.CommitState commitState3 = this.current.commitState;
            synchronized (commitState3) {
                this.current.commitState.value = Log.CommitState.Values.PREPARED;
                this.current.commitState.notifyAll();
            }
        }
    }

    private void abortPrepare(Map<RemoteNode, TransactionPrepareFailedException> failures) {
        failures.remove(null);
        TransactionPrepareFailedException e = new TransactionPrepareFailedException(failures);
        Logging.log(Logging.WORKER_TRANSACTION_LOGGER, Level.WARNING, "{0} error committing: prepare failed exception: {1}", this.current, e);
        TransactionID tid = this.current.tid;
        this.abortTransaction(false);
        throw new TransactionRestartingException(tid);
    }

    public void sendCommitMessagesAndCleanUp() throws TransactionAtomicityViolationException {
        this.sendCommitMessagesAndCleanUp(true, this.current.storesToContact(), this.current.workersCalled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommitMessagesAndCleanUp(final boolean useAuthentication, Set<Store> stores, List<RemoteWorker> workers) throws TransactionAtomicityViolationException {
        Log.CommitState commitState = this.current.commitState;
        synchronized (commitState) {
            switch (this.current.commitState.value) {
                case UNPREPARED: 
                case PREPARING: {
                    Logging.WORKER_TRANSACTION_LOGGER.log(Level.FINE, "Ignoring commit request (transaction state = {0}", (Object)this.current.commitState.value);
                    return;
                }
                case PREPARED: {
                    this.current.commitState.value = Log.CommitState.Values.COMMITTING;
                    break;
                }
                case COMMITTING: 
                case COMMITTED: {
                    return;
                }
                case PREPARE_FAILED: 
                case ABORTING: 
                case ABORTED: {
                    throw new TransactionAtomicityViolationException();
                }
            }
        }
        final List<RemoteNode> unreachable = Collections.synchronizedList(new ArrayList());
        final List<RemoteNode> failed = Collections.synchronizedList(new ArrayList());
        ArrayList<Thread> threads = new ArrayList<Thread>(stores.size() + workers.size());
        for (final RemoteWorker worker : workers) {
            Thread thread = new Thread("worker commit to " + worker){

                @Override
                public void run() {
                    try {
                        worker.commitTransaction(((TransactionManager)TransactionManager.this).current.tid.topTid);
                    }
                    catch (UnreachableNodeException e) {
                        unreachable.add(worker);
                    }
                    catch (TransactionCommitFailedException e) {
                        failed.add(worker);
                    }
                }
            };
            thread.start();
            threads.add(thread);
        }
        Iterator<Store> storeIt = stores.iterator();
        while (storeIt.hasNext()) {
            final Store store = storeIt.next();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        store.commitTransaction(useAuthentication, ((TransactionManager)TransactionManager.this).current.tid.topTid);
                    }
                    catch (TransactionCommitFailedException e) {
                        failed.add((RemoteStore)store);
                    }
                    catch (UnreachableNodeException e) {
                        unreachable.add((RemoteStore)store);
                    }
                }
            };
            if (!(store instanceof InProcessStore) && !store.isLocalStore() && storeIt.hasNext()) {
                Thread thread = new Thread(runnable, "worker commit to " + store.name());
                threads.add(thread);
                thread.start();
                continue;
            }
            runnable.run();
        }
        block16: for (Thread thread : threads) {
            while (true) {
                try {
                    thread.join();
                    continue block16;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        if (!unreachable.isEmpty() || !failed.isEmpty()) {
            Logging.log(Logging.WORKER_TRANSACTION_LOGGER, Level.SEVERE, "{0} error committing: atomicity violation -- failed: {1} unreachable: {2}", this.current, failed, unreachable);
            throw new TransactionAtomicityViolationException(failed, unreachable);
        }
        Logging.WORKER_TRANSACTION_LOGGER.log(Level.FINEST, "{0} committed at stores...updating data structures", this.current);
        this.current.commitTopLevel();
        Logging.WORKER_TRANSACTION_LOGGER.log(Level.FINEST, "{0} committed", this.current);
        Log.CommitState commitState2 = this.current.commitState;
        synchronized (commitState2) {
            this.current.commitState.value = Log.CommitState.Values.COMMITTED;
        }
        TransactionRegistry.remove(this.current.tid.topTid);
        this.current = null;
    }

    private void sendAbortMessages() {
        this.sendAbortMessages(true, this.current.storesToContact(), this.current.workersCalled, Collections.EMPTY_SET);
    }

    private void sendAbortMessages(boolean useAuthentication, Set<Store> stores, List<RemoteWorker> workers, Set<RemoteNode> fails) {
        for (Store store : stores) {
            if (fails.contains(store)) continue;
            store.abortTransaction(useAuthentication, this.current.tid);
        }
        for (RemoteWorker worker : workers) {
            if (fails.contains(worker)) continue;
            worker.abortTransaction(this.current.tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCreate(Object._Impl obj) {
        Timing.TXLOG.begin();
        try {
            if (this.current == null) {
                throw new InternalError("Cannot create objects outside a transaction");
            }
            this.checkRetrySignal();
            obj.$writer = this.current;
            obj.$writeLockHolder = this.current;
            this.ensureOwnership(obj);
            this.current.updateMap.put(obj.$getProxy(), obj.get$label());
        }
        finally {
            Timing.TXLOG.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRead(Object._Impl obj) {
        Object._Impl _Impl2 = obj;
        synchronized (_Impl2) {
            if (obj.$reader == this.current && obj.$updateMapVersion == this.current.updateMap.version) {
                return;
            }
            if (this.current == null) {
                return;
            }
            Timing.TXLOG.begin();
            try {
                this.ensureReadLock(obj);
                this.ensureObjectUpToDate(obj);
            }
            finally {
                Timing.TXLOG.end();
            }
        }
    }

    private void ensureReadLock(Object._Impl obj) {
        if (obj.$reader == this.current) {
            return;
        }
        this.checkRetrySignal();
        boolean hadToWait = false;
        while (obj.$writeLockHolder != null && !this.current.isDescendantOf(obj.$writeLockHolder)) {
            try {
                Logging.log(Logging.WORKER_TRANSACTION_LOGGER, Level.FINEST, this.current + "{0} wants to read {1}/" + obj.$getOnum() + " ({2}); waiting on writer {3}", this.current, obj.$getStore(), obj.getClass(), obj.$writeLockHolder);
                hadToWait = true;
                ++obj.$numWaiting;
                obj.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --obj.$numWaiting;
            this.checkRetrySignal();
        }
        obj.$reader = this.current;
        obj.$updateMapVersion = -1;
        this.current.acquireReadLock(obj);
        if (hadToWait) {
            Logging.WORKER_TRANSACTION_LOGGER.log(Level.FINEST, "{0} got read lock", this.current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerWrite(Object._Impl obj) {
        boolean needTransaction;
        boolean bl = needTransaction = this.current == null;
        if (needTransaction) {
            this.startTransaction();
        }
        Object._Impl _Impl2 = obj;
        synchronized (_Impl2) {
            if (obj.$writer == this.current && obj.$updateMapVersion == this.current.updateMap.version && obj.$isOwned) {
                return needTransaction;
            }
            try {
                Timing.TXLOG.begin();
                this.ensureWriteLock(obj);
                this.ensureObjectUpToDate(obj);
                this.ensureOwnership(obj);
            }
            finally {
                Timing.TXLOG.end();
            }
        }
        return needTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriteLock(Object._Impl obj) {
        Iterable<Object._Impl> iterable;
        if (obj.$writer == this.current) {
            return;
        }
        this.checkRetrySignal();
        boolean hadToWait = false;
        while (true) {
            if (obj.$writeLockHolder != null && !this.current.isDescendantOf(obj.$writeLockHolder)) {
                Logging.log(Logging.WORKER_TRANSACTION_LOGGER, Level.FINEST, "{0} wants to write {1}/" + obj.$getOnum() + " ({2}); waiting on writer {3}", this.current, obj.$getStore(), obj.getClass(), obj.$writeLockHolder);
                hadToWait = true;
            } else {
                ReadMapEntry readMapEntry = obj.$readMapEntry;
                if (readMapEntry != null) {
                    ReadMapEntry readMapEntry2 = readMapEntry;
                    synchronized (readMapEntry2) {
                        boolean allReadersInAncestry = true;
                        for (Log lock : readMapEntry.readLocks) {
                            if (this.current.isDescendantOf(lock)) continue;
                            Logging.log(Logging.WORKER_TRANSACTION_LOGGER, Level.FINEST, "{0} wants to write {1}/" + obj.$getOnum() + " ({2}); aborting reader {3}", this.current, obj.$getStore(), obj.getClass(), lock);
                            lock.flagRetry();
                            allReadersInAncestry = false;
                        }
                        if (allReadersInAncestry) {
                            break;
                        }
                    }
                }
            }
            try {
                ++obj.$numWaiting;
                obj.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --obj.$numWaiting;
            this.checkRetrySignal();
        }
        obj.$writer = this.current;
        if (hadToWait) {
            Logging.WORKER_TRANSACTION_LOGGER.log(Level.FINEST, "{0} got write lock", this.current);
        }
        if (obj.$writeLockHolder == this.current) {
            return;
        }
        obj.$history = obj.clone();
        obj.$writeLockHolder = this.current;
        if (obj.$getStore().isLocalStore()) {
            iterable = this.current.localStoreWrites;
            synchronized (iterable) {
                this.current.localStoreWrites.add(obj);
            }
        }
        iterable = this.current.writes;
        synchronized (iterable) {
            this.current.writes.add(obj);
        }
        if (obj.$reader != this.current) {
            obj.$reader = Log.NO_READER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOwnership(Object._Impl obj) {
        if (obj.$isOwned) {
            return;
        }
        RemoteWorker owner = this.current.updateMap.getUpdate(obj.$getProxy());
        if (owner != null) {
            owner.takeOwnership(this.current.tid, obj.$getStore(), obj.$getOnum());
        }
        obj.$isOwned = true;
        this.current.updateMap.put(obj.$getProxy(), Worker.getWorker().getLocalWorker());
        if (obj.$version == 0) {
            if (obj.$getStore().isLocalStore()) {
                WeakReferenceArrayList<Object._Impl> weakReferenceArrayList = this.current.localStoreCreates;
                synchronized (weakReferenceArrayList) {
                    this.current.localStoreCreates.add(obj);
                }
            }
            List<Object._Impl> list = this.current.creates;
            synchronized (list) {
                this.current.creates.add(obj);
            }
        }
    }

    private void ensureObjectUpToDate(Object._Impl obj) {
        if (obj.$updateMapVersion == this.current.updateMap.version) {
            return;
        }
        obj.$updateMapVersion = this.current.updateMap.version;
        RemoteWorker owner = this.current.updateMap.getUpdate(obj.$getProxy());
        if (owner == null || owner == Worker.getWorker().getLocalWorker()) {
            return;
        }
        this.ensureWriteLock(obj);
        owner.readObject(this.current.tid, obj);
    }

    public boolean checkForStaleObjects() {
        Set<Store> stores = this.current.storesToCheckFreshness();
        int numNodesToContact = stores.size() + this.current.workersCalled.size();
        final List nodesWithStaleObjects = Collections.synchronizedList(new ArrayList(numNodesToContact));
        ArrayList<Thread> threads = new ArrayList<Thread>(numNodesToContact);
        for (final RemoteWorker worker : this.current.workersCalled) {
            Thread thread = new Thread("worker freshness check to " + worker.name()){

                @Override
                public void run() {
                    try {
                        if (worker.checkForStaleObjects(((TransactionManager)TransactionManager.this).current.tid)) {
                            nodesWithStaleObjects.add(worker);
                        }
                    }
                    catch (UnreachableNodeException e) {
                        nodesWithStaleObjects.add(worker);
                    }
                }
            };
            thread.start();
            threads.add(thread);
        }
        Iterator<Store> storeIt = stores.iterator();
        while (storeIt.hasNext()) {
            final Store store = storeIt.next();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LongKeyMap<Integer> reads = TransactionManager.this.current.getReadsForStore(store, true);
                    if (store.checkForStaleObjects(reads)) {
                        nodesWithStaleObjects.add((RemoteNode)((Object)store));
                    }
                }
            };
            if (!(store instanceof InProcessStore) && !store.isLocalStore() && storeIt.hasNext()) {
                Thread thread = new Thread(runnable, "worker freshness check to " + store.name());
                threads.add(thread);
                thread.start();
                continue;
            }
            runnable.run();
        }
        block4: for (Thread thread : threads) {
            while (true) {
                try {
                    thread.join();
                    continue block4;
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        return !nodesWithStaleObjects.isEmpty();
    }

    public void startTransaction() {
        this.startTransaction(null);
    }

    public void startTransaction(TransactionID tid) {
        this.startTransaction(tid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTransaction(TransactionID tid, boolean ignoreRetrySignal) {
        if (this.current != null && !ignoreRetrySignal) {
            this.checkRetrySignal();
        }
        try {
            Timing.BEGIN.begin();
            this.current = new Log(this.current, tid);
            Logging.log(Logging.WORKER_TRANSACTION_LOGGER, Level.FINEST, "{0} started subtx {1} in thread {2}", this.current.parent, this.current, Thread.currentThread());
        }
        finally {
            Timing.BEGIN.end();
        }
    }

    public static void startThread(Thread thread) {
        if (!(thread instanceof FabricThread)) {
            TransactionManager.getInstance().registerThread(thread);
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThread(Thread thread) {
        block8: {
            Timing.TXLOG.begin();
            try {
                if (this.current != null) {
                    throw new InternalError("Cannot create threads within transactions");
                }
                TransactionManager tm = new TransactionManager();
                if (thread instanceof FabricThread) {
                    ((FabricThread)((Object)thread)).setTransactionManager(tm);
                    break block8;
                }
                Map<Thread, TransactionManager> map = instanceMap;
                synchronized (map) {
                    instanceMap.put(thread, tm);
                }
            }
            finally {
                Timing.TXLOG.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterThread(Thread thread) {
        if (!(thread instanceof FabricThread)) {
            Map<Thread, TransactionManager> map = instanceMap;
            synchronized (map) {
                instanceMap.remove(thread);
            }
        }
    }

    public void registerRemoteCall(RemoteWorker worker) {
        if (this.current != null && !this.current.workersCalled.contains(worker)) {
            this.current.workersCalled.add(worker);
        }
    }

    public void associateLog(Log log) {
        this.current = log;
    }

    public Log getCurrentLog() {
        return this.current;
    }

    public TransactionID getCurrentTid() {
        if (this.current == null) {
            return null;
        }
        return this.current.tid;
    }

    public UpdateMap getUpdateMap() {
        if (this.current == null) {
            return null;
        }
        return this.current.updateMap;
    }

    public RemoteWorker getFetchWorker(Object._Proxy proxy) {
        if (this.current == null || !this.current.updateMap.containsCreate(proxy)) {
            return null;
        }
        Label label = this.current.updateMap.getCreate(proxy);
        return this.current.updateMap.getUpdate(proxy, label);
    }

    public SecurityCache getSecurityCache() {
        return (SecurityCache)this.current.securityCache;
    }

    public void associateAndSyncLog(Log log, TransactionID tid) {
        this.associateLog(log);
        if (log == null) {
            if (tid != null) {
                this.startTransaction(tid);
            }
            return;
        }
        TransactionID commonAncestor = log.getTid().getLowestCommonAncestor(tid);
        for (int i = log.getTid().depth; i > commonAncestor.depth; --i) {
            this.commitTransactionAt(System.currentTimeMillis(), true, true);
        }
        if (commonAncestor.depth != tid.depth) {
            this.startTransaction(tid, true);
        }
    }
}

