/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.transaction;

import fabric.common.util.OidKeyHashMap;
import fabric.lang.Object;
import fabric.worker.FabricSoftRef;
import fabric.worker.transaction.Log;
import fabric.worker.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.List;

public final class ReadMapEntry {
    FabricSoftRef obj;
    List<Log> readLocks;
    int versionNumber;
    long promise;
    int pinCount;

    ReadMapEntry(Object._Impl obj, long expiry) {
        this.obj = obj.$ref;
        this.readLocks = new ArrayList<Log>();
        this.versionNumber = obj.$version;
        this.promise = expiry;
        this.pinCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLock(Log lockHolder) {
        ReadMapEntry readMapEntry = this;
        synchronized (readMapEntry) {
            this.readLocks.remove(lockHolder);
            this.unpin();
        }
        this.signalObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unpin() {
        if (this.readLocks.isEmpty() && this.pinCount == 0) {
            OidKeyHashMap<ReadMapEntry> oidKeyHashMap = TransactionManager.readMap;
            synchronized (oidKeyHashMap) {
                TransactionManager.readMap.remove(this.obj.store, this.obj.onum);
                return true;
            }
        }
        return false;
    }

    public synchronized boolean depin() {
        --this.pinCount;
        return this.unpin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalObject() {
        Object object;
        Object._Impl obj = (Object._Impl)this.obj.get();
        if (obj == null) {
            if (this.obj.store.isLocalStore()) {
                return;
            }
            obj = this.obj.store.readObjectFromCache(this.obj.onum);
            if (obj == null) {
                return;
            }
            object = this;
            synchronized (object) {
                this.obj = obj.$ref;
            }
        }
        object = obj;
        synchronized (object) {
            if (obj.$numWaiting > 0) {
                obj.notifyAll();
            }
            obj.$reader = Log.NO_READER;
        }
    }
}

