/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.transaction;

import fabric.common.TransactionID;
import fabric.common.Util;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.common.util.OidKeyHashMap;
import fabric.common.util.WeakReferenceArrayList;
import fabric.lang.Object;
import fabric.lang.security.SecurityCache;
import fabric.worker.Store;
import fabric.worker.Worker;
import fabric.worker.debug.Timing;
import fabric.worker.remote.RemoteWorker;
import fabric.worker.remote.UpdateMap;
import fabric.worker.transaction.AbstractSecurityCache;
import fabric.worker.transaction.ReadMapEntry;
import fabric.worker.transaction.TransactionRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Log {
    public static final Log NO_READER = new Log((Log)null);
    TransactionID tid;
    final Log parent;
    UpdateMap updateMap;
    private Log child;
    Thread thread;
    volatile TransactionID retrySignal;
    protected final OidKeyHashMap<ReadMapEntry> reads;
    protected final List<ReadMapEntry> readsReadByParent;
    protected final List<Object._Impl> creates;
    protected final WeakReferenceArrayList<Object._Impl> localStoreCreates;
    protected final List<Object._Impl> writes;
    protected final WeakReferenceArrayList<Object._Impl> localStoreWrites;
    public final List<RemoteWorker> workersCalled;
    public final CommitState commitState;
    public final AbstractSecurityCache securityCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Log(Log parent, TransactionID tid) {
        this.parent = parent;
        this.tid = tid == null ? (parent == null ? new TransactionID() : new TransactionID(parent.tid)) : tid;
        this.child = null;
        this.thread = Thread.currentThread();
        this.retrySignal = parent == null ? null : parent.retrySignal;
        this.reads = new OidKeyHashMap();
        this.readsReadByParent = new ArrayList<ReadMapEntry>();
        this.creates = new ArrayList<Object._Impl>();
        this.localStoreCreates = new WeakReferenceArrayList();
        this.writes = new ArrayList<Object._Impl>();
        this.localStoreWrites = new WeakReferenceArrayList();
        this.workersCalled = new ArrayList<RemoteWorker>();
        if (parent != null) {
            try {
                Timing.SUBTX.begin();
                this.updateMap = new UpdateMap(parent.updateMap);
                Log log = parent;
                synchronized (log) {
                    parent.child = this;
                }
                this.commitState = parent.commitState;
                this.securityCache = new SecurityCache((SecurityCache)parent.securityCache);
            }
            finally {
                Timing.SUBTX.end();
            }
        }
        this.updateMap = new UpdateMap(this.tid.topTid);
        this.commitState = new CommitState();
        this.securityCache = new SecurityCache(null);
        TransactionRegistry.register(this);
    }

    Log(Log parent) {
        this(parent, null);
    }

    public Log(TransactionID tid) {
        this(null, tid);
    }

    boolean isDescendantOf(Log log) {
        return this.tid.isDescendantOf(log.tid);
    }

    Set<Store> storesToContact() {
        HashSet<Store> result = new HashSet<Store>();
        result.addAll(this.reads.storeSet());
        for (Object._Impl obj : this.writes) {
            if (!obj.$isOwned) continue;
            result.add(obj.$getStore());
        }
        for (Object._Impl obj : this.creates) {
            if (!obj.$isOwned) continue;
            result.add(obj.$getStore());
        }
        if (!this.localStoreWrites.isEmpty() || !this.localStoreCreates.isEmpty()) {
            result.add(Worker.getWorker().getLocalStore());
        }
        return result;
    }

    Set<Store> storesToCheckFreshness() {
        HashSet<Store> result = new HashSet<Store>();
        result.addAll(this.reads.storeSet());
        for (ReadMapEntry entry : this.readsReadByParent) {
            result.add(entry.obj.store);
        }
        return result;
    }

    LongKeyMap<Integer> getReadsForStore(Store store, boolean includeModified) {
        List<Object._Impl> writesToExclude;
        LongKeyHashMap<Integer> result = new LongKeyHashMap<Integer>();
        LongKeyMap<ReadMapEntry> submap = this.reads.get(store);
        if (submap == null) {
            return result;
        }
        for (LongKeyMap.Entry<ReadMapEntry> entry : submap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().versionNumber);
        }
        if (this.parent != null) {
            for (ReadMapEntry readMapEntry : this.readsReadByParent) {
                result.put(readMapEntry.obj.onum, readMapEntry.versionNumber);
            }
        }
        if (store.isLocalStore()) {
            writesToExclude = includeModified ? Collections.EMPTY_LIST : this.localStoreWrites;
            for (Object._Impl write : Util.chain(writesToExclude, this.localStoreCreates)) {
                result.remove(write.$getOnum());
            }
        } else {
            writesToExclude = includeModified ? Collections.EMPTY_LIST : this.writes;
            for (Object._Impl write : Util.chain(writesToExclude, this.creates)) {
                if (write.$getStore() != store) continue;
                result.remove(write.$getOnum());
            }
        }
        return result;
    }

    Collection<Object._Impl> getWritesForStore(Store store) {
        LongKeyHashMap<Object._Impl> result = new LongKeyHashMap<Object._Impl>();
        if (store.isLocalStore()) {
            for (Object._Impl obj : this.localStoreWrites) {
                result.put(obj.$getOnum(), obj);
            }
            for (Object._Impl create : this.localStoreCreates) {
                result.remove(create.$getOnum());
            }
        } else {
            for (Object._Impl obj : this.writes) {
                if (obj.$getStore() != store || !obj.$isOwned) continue;
                result.put(obj.$getOnum(), obj);
            }
            for (Object._Impl create : this.creates) {
                if (create.$getStore() != store) continue;
                result.remove(create.$getOnum());
            }
        }
        return result.values();
    }

    Collection<Object._Impl> getCreatesForStore(Store store) {
        LongKeyHashMap<Object._Impl> result = new LongKeyHashMap<Object._Impl>();
        if (store.isLocalStore()) {
            for (Object._Impl obj : this.localStoreCreates) {
                result.put(obj.$getOnum(), obj);
            }
        } else {
            for (Object._Impl obj : this.creates) {
                if (obj.$getStore() != store || !obj.$isOwned) continue;
                result.put(obj.$getOnum(), obj);
            }
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flagRetry() {
        LinkedList<Log> toFlag = new LinkedList<Log>();
        toFlag.add(this);
        while (!toFlag.isEmpty()) {
            Log log;
            Log log2 = log = (Log)toFlag.remove();
            synchronized (log2) {
                if (log.child != null) {
                    toFlag.add(log.child);
                }
                if (log.retrySignal == null || log.retrySignal.isDescendantOf(this.tid)) {
                    log.retrySignal = this.tid;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        Log log;
        for (LongKeyMap<ReadMapEntry> longKeyMap : this.reads) {
            for (ReadMapEntry entry : longKeyMap.values()) {
                entry.releaseLock(this);
            }
        }
        for (ReadMapEntry readMapEntry : this.readsReadByParent) {
            readMapEntry.releaseLock(this);
        }
        Iterator<Object> i$ = Util.chain(this.writes, this.localStoreWrites).iterator();
        while (i$.hasNext()) {
            Object._Impl _Impl2;
            Object._Impl _Impl3 = _Impl2 = (Object._Impl)i$.next();
            synchronized (_Impl3) {
                _Impl2.$copyStateFrom(_Impl2.$history);
                if (_Impl2.$numWaiting > 0) {
                    _Impl2.notifyAll();
                }
            }
        }
        if (this.parent != null && this.parent.tid.equals(this.tid.parent)) {
            log = this.parent;
            synchronized (log) {
                this.parent.child = null;
            }
        }
        this.reads.clear();
        this.readsReadByParent.clear();
        this.creates.clear();
        this.localStoreCreates.clear();
        this.writes.clear();
        this.localStoreWrites.clear();
        this.workersCalled.clear();
        this.securityCache.reset();
        this.updateMap = this.parent != null ? new UpdateMap(this.parent.updateMap) : new UpdateMap(this.tid.topTid);
        if (this.retrySignal != null) {
            log = this;
            synchronized (log) {
                if (this.retrySignal.equals(this.tid)) {
                    this.retrySignal = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitNested() {
        List<Object._Impl> parentCreates;
        Object object;
        if (this.parent == null || !this.parent.tid.equals(this.tid.parent)) {
            return;
        }
        for (LongKeyMap<ReadMapEntry> longKeyMap : this.reads) {
            for (ReadMapEntry readMapEntry : longKeyMap.values()) {
                this.parent.transferReadLock(this, readMapEntry);
            }
        }
        for (ReadMapEntry readMapEntry : this.readsReadByParent) {
            readMapEntry.releaseLock(this);
        }
        List<Object._Impl> parentWrites = this.parent.writes;
        Iterator<Object._Impl> iterator = this.writes.iterator();
        while (iterator.hasNext()) {
            Object._Impl obj2;
            Object._Impl _Impl2 = obj2 = iterator.next();
            synchronized (_Impl2) {
                if (obj2.$history.$writeLockHolder == this.parent) {
                    obj2.$history = obj2.$history.$history;
                } else {
                    object = parentWrites;
                    synchronized (object) {
                        parentWrites.add(obj2);
                    }
                }
                obj2.$writer = null;
                obj2.$writeLockHolder = this.parent;
                if (obj2.$numWaiting > 0) {
                    obj2.notifyAll();
                }
            }
        }
        WeakReferenceArrayList<Object._Impl> weakReferenceArrayList = this.parent.localStoreWrites;
        for (Object._Impl _Impl3 : this.localStoreWrites) {
            object = _Impl3;
            synchronized (object) {
                if (_Impl3.$history.$writeLockHolder == this.parent) {
                    _Impl3.$history = _Impl3.$history.$history;
                } else {
                    WeakReferenceArrayList<Object._Impl> weakReferenceArrayList2 = weakReferenceArrayList;
                    synchronized (weakReferenceArrayList2) {
                        weakReferenceArrayList.add(_Impl3);
                    }
                }
                _Impl3.$writer = null;
                _Impl3.$writeLockHolder = this.parent;
                if (_Impl3.$numWaiting > 0) {
                    _Impl3.notifyAll();
                }
            }
        }
        List<Object._Impl> list = parentCreates = this.parent.creates;
        synchronized (list) {
            for (Object._Impl obj3 : this.creates) {
                parentCreates.add(obj3);
                obj3.$writeLockHolder = this.parent;
            }
        }
        WeakReferenceArrayList<Object._Impl> weakReferenceArrayList3 = this.parent.localStoreCreates;
        object = weakReferenceArrayList3;
        synchronized (object) {
            for (Object._Impl obj4 : this.localStoreCreates) {
                weakReferenceArrayList3.add(obj4);
                obj4.$writeLockHolder = this.parent;
            }
        }
        object = this.parent.workersCalled;
        synchronized (object) {
            for (RemoteWorker worker : this.workersCalled) {
                if (this.parent.workersCalled.contains(worker)) continue;
                this.parent.workersCalled.add(worker);
            }
        }
        this.parent.securityCache.set((SecurityCache)this.securityCache);
        object = this.parent.updateMap;
        synchronized (object) {
            this.parent.updateMap.putAll(this.updateMap);
        }
        object = this.parent;
        synchronized (object) {
            this.parent.child = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitTopLevel() {
        for (LongKeyMap<ReadMapEntry> longKeyMap : this.reads) {
            for (ReadMapEntry entry : longKeyMap.values()) {
                entry.releaseLock(this);
            }
        }
        if (!this.readsReadByParent.isEmpty()) {
            throw new InternalError("something was read by a non-existent parent");
        }
        for (Object._Impl _Impl2 : Util.chain(this.writes, this.localStoreWrites)) {
            if (!_Impl2.$isOwned) {
                _Impl2.$ref.evict();
                continue;
            }
            Object._Impl _Impl3 = _Impl2;
            synchronized (_Impl3) {
                _Impl2.$writer = null;
                _Impl2.$writeLockHolder = null;
                ++_Impl2.$version;
                ++_Impl2.$readMapEntry.versionNumber;
                _Impl2.$isOwned = false;
                _Impl2.$history = _Impl2.$history.$history;
                if (_Impl2.$numWaiting > 0) {
                    _Impl2.notifyAll();
                }
            }
        }
        for (Object._Impl _Impl4 : Util.chain(this.creates, this.localStoreCreates)) {
            if (!_Impl4.$isOwned) {
                _Impl4.$ref.evict();
                continue;
            }
            _Impl4.$writer = null;
            _Impl4.$writeLockHolder = null;
            _Impl4.$version = 1;
            _Impl4.$readMapEntry.versionNumber = 1;
            _Impl4.$isOwned = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferReadLock(Log child, ReadMapEntry readMapEntry) {
        boolean lockedByAncestor = false;
        Object object = readMapEntry;
        synchronized (object) {
            readMapEntry.readLocks.remove(child);
            for (Log cur : readMapEntry.readLocks) {
                if (cur == this) {
                    return;
                }
                if (lockedByAncestor || !this.isDescendantOf(cur)) continue;
                lockedByAncestor = true;
            }
            readMapEntry.readLocks.add(this);
        }
        if (!lockedByAncestor) {
            object = this.reads;
            synchronized (object) {
                this.reads.put(readMapEntry.obj.store, readMapEntry.obj.onum, readMapEntry);
            }
        } else {
            this.readsReadByParent.add(readMapEntry);
        }
        readMapEntry.signalObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireReadLock(Object._Impl obj) {
        ReadMapEntry readMapEntry = obj.$readMapEntry;
        boolean lockedByAncestor = false;
        Object object = readMapEntry;
        synchronized (object) {
            for (Log cur : readMapEntry.readLocks) {
                if (cur == this) {
                    return;
                }
                if (lockedByAncestor || !this.isDescendantOf(cur)) continue;
                lockedByAncestor = true;
            }
            readMapEntry.readLocks.add(this);
        }
        if (obj.$writer != this) {
            obj.$writer = null;
        }
        if (!lockedByAncestor) {
            object = this.reads;
            synchronized (object) {
                this.reads.put(obj.$ref.store, obj.$ref.onum, readMapEntry);
            }
        } else {
            this.readsReadByParent.add(readMapEntry);
        }
    }

    void waitForThreads() {
    }

    public TransactionID getTid() {
        return this.tid;
    }

    public Log getChild() {
        return this.child;
    }

    void removePromisedReads(long commitTime) {
        Iterator<LongKeyMap<ReadMapEntry>> outer = this.reads.iterator();
        while (outer.hasNext()) {
            Collection<ReadMapEntry> values = outer.next().values();
            Iterator<ReadMapEntry> inner = values.iterator();
            while (inner.hasNext()) {
                ReadMapEntry entry = inner.next();
                if (entry.promise <= commitTime) continue;
                entry.releaseLock(this);
                inner.remove();
            }
            if (!values.isEmpty()) continue;
            outer.remove();
        }
        if (!this.readsReadByParent.isEmpty()) {
            throw new InternalError("something was read by a non-existent parent");
        }
    }

    public void renumberObject(Store store, long onum, long newOnum) {
        ReadMapEntry entry = this.reads.remove(store, onum);
        if (entry != null) {
            this.reads.put(store, newOnum, entry);
        }
        if (this.child != null) {
            this.child.renumberObject(store, onum, newOnum);
        }
    }

    public static class CommitState {
        public Values value = Values.UNPREPARED;

        public static enum Values {
            UNPREPARED,
            PREPARING,
            PREPARED,
            PREPARE_FAILED,
            COMMITTING,
            COMMITTED,
            ABORTING,
            ABORTED;

        }
    }
}

