/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.remote.messages;

import fabric.common.TransactionID;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.common.exceptions.ProtocolError;
import fabric.messages.Message;
import fabric.net.UnreachableNodeException;
import fabric.worker.remote.MessageHandlerThread;
import fabric.worker.remote.RemoteWorker;
import fabric.worker.remote.messages.InterWorkerMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StalenessCheckMessage
extends InterWorkerMessage<Response> {
    public final TransactionID tid;

    public StalenessCheckMessage(TransactionID tid) {
        super(Message.MessageType.INTERWORKER_STALENESS_CHECK);
        this.tid = tid;
    }

    public StalenessCheckMessage(DataInput in) throws IOException {
        this(new TransactionID(in));
    }

    @Override
    public Response dispatch(MessageHandlerThread handler) throws ProtocolError {
        return handler.handle(this);
    }

    public Response send(RemoteWorker remoteWorker) {
        try {
            return (Response)super.send(remoteWorker, true);
        }
        catch (UnreachableNodeException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from worker.", e);
        }
    }

    @Override
    public Response response(RemoteWorker node, DataInput in) throws IOException {
        return new Response(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.tid.write(out);
    }

    public static class Response
    implements Message.Response {
        public final boolean result;

        public Response(boolean result) {
            this.result = result;
        }

        Response(DataInput in) throws IOException {
            this.result = in.readBoolean();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.result);
        }
    }
}

