/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.remote.messages;

import fabric.common.TransactionID;
import fabric.common.Util;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.common.exceptions.ProtocolError;
import fabric.lang.Object;
import fabric.lang.security.Principal;
import fabric.messages.Message;
import fabric.net.UnreachableNodeException;
import fabric.worker.remote.MessageHandlerThread;
import fabric.worker.remote.RemoteCallException;
import fabric.worker.remote.RemoteWorker;
import fabric.worker.remote.UpdateMap;
import fabric.worker.remote.messages.InterWorkerMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;

public class RemoteCallMessage
extends InterWorkerMessage<Response> {
    public final TransactionID tid;
    public final UpdateMap updateMap;
    public final Class<?> receiverType;
    public final Object._Proxy receiver;
    public final String methodName;
    public final Class<?>[] parameterTypes;
    public final java.lang.Object[] args;

    public RemoteCallMessage(TransactionID tid, UpdateMap updateMap, Class<?> receiverType, Object._Proxy receiver, String methodName, Class<?>[] parameterTypes, java.lang.Object[] args) {
        super(Message.MessageType.REMOTE_CALL);
        if (parameterTypes == null ? args != null : parameterTypes.length != args.length) {
            throw new IllegalArgumentException();
        }
        this.tid = tid;
        this.updateMap = updateMap;
        this.receiverType = receiverType;
        this.receiver = receiver;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.args = args;
    }

    public RemoteCallMessage(DataInput in) throws IOException, ClassNotFoundException {
        super(Message.MessageType.REMOTE_CALL);
        this.tid = in.readBoolean() ? new TransactionID(in) : null;
        this.updateMap = in.readBoolean() ? new UpdateMap(in) : null;
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buf));
        this.receiverType = (Class)ois.readObject();
        this.receiver = RemoteCallMessage.readRef(this.receiverType, ois);
        this.methodName = ois.readUTF();
        this.parameterTypes = new Class[ois.readInt()];
        this.args = new java.lang.Object[this.parameterTypes.length];
        for (int i = 0; i < this.args.length; ++i) {
            this.parameterTypes[i] = (Class)ois.readObject();
            this.args[i] = ois.readBoolean() ? RemoteCallMessage.readRef(this.parameterTypes[i], ois) : ois.readObject();
        }
    }

    @Override
    public Response dispatch(MessageHandlerThread handler) throws RemoteCallException, ProtocolError {
        return handler.handle(this);
    }

    public Response send(RemoteWorker worker) throws UnreachableNodeException, RemoteCallException {
        try {
            return (Response)super.send(worker, true);
        }
        catch (UnreachableNodeException e) {
            throw e;
        }
        catch (RemoteCallException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from worker " + worker.name, e);
        }
    }

    @Override
    public Response response(RemoteWorker c, DataInput in) throws IOException, RemoteCallException {
        return new Response(c, in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.tid != null);
        if (this.tid != null) {
            this.tid.write(out);
        }
        out.writeBoolean(this.updateMap != null);
        if (this.updateMap != null) {
            this.updateMap.write(out);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.receiverType);
        RemoteCallMessage.writeRef(this.receiver, oos);
        oos.writeUTF(this.methodName);
        oos.writeInt(this.args == null ? 0 : this.args.length);
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                oos.writeObject(this.parameterTypes[i]);
                if (this.args[i] instanceof Object._Proxy) {
                    oos.writeBoolean(true);
                    RemoteCallMessage.writeRef((Object._Proxy)this.args[i], oos);
                    continue;
                }
                oos.writeBoolean(false);
                oos.writeObject(this.args[i]);
            }
        }
        oos.flush();
        baos.flush();
        byte[] buf = baos.toByteArray();
        out.writeInt(buf.length);
        out.write(buf);
    }

    public Method getMethod() throws SecurityException, NoSuchMethodException {
        Class[] mangledParamTypes = new Class[this.parameterTypes.length + 1];
        mangledParamTypes[0] = Principal.class;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            mangledParamTypes[i + 1] = this.parameterTypes[i];
        }
        Class<?> proxyType = null;
        for (Class<?> c : this.receiverType.getClasses()) {
            if (!c.getSimpleName().equals("_Proxy")) continue;
            proxyType = c;
            break;
        }
        if (proxyType == null) {
            throw new NoSuchMethodException("Remote method call on non-Fabric object: " + this.receiverType);
        }
        return proxyType.getMethod(this.methodName + "_remote", mangledParamTypes);
    }

    public static class Response
    implements Message.Response {
        public final java.lang.Object result;
        public final UpdateMap updateMap;

        public Response(java.lang.Object result, UpdateMap updateMap) {
            this.result = result;
            this.updateMap = updateMap;
        }

        Response(RemoteWorker worker, DataInput in) throws IOException, RemoteCallException {
            if (in.readBoolean()) {
                this.result = InterWorkerMessage.readRef(Object.class, in);
            } else {
                byte[] buf = new byte[in.readInt()];
                in.readFully(buf);
                try {
                    this.result = Util.deserialize(buf);
                }
                catch (ClassNotFoundException e) {
                    throw new RemoteCallException(e);
                }
            }
            this.updateMap = in.readBoolean() ? new UpdateMap(in) : null;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.result instanceof Object._Proxy);
            if (this.result instanceof Object._Proxy) {
                InterWorkerMessage.writeRef((Object._Proxy)this.result, out);
            } else {
                byte[] buf = Util.serialize(this.result);
                out.writeInt(buf.length);
                out.write(buf);
            }
            out.writeBoolean(this.updateMap != null);
            if (this.updateMap != null) {
                this.updateMap.write(out);
            }
        }
    }
}

