/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.remote.messages;

import fabric.common.SerializedObject;
import fabric.common.TransactionID;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.common.exceptions.ProtocolError;
import fabric.lang.Object;
import fabric.messages.Message;
import fabric.net.UnreachableNodeException;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import fabric.worker.remote.MessageHandlerThread;
import fabric.worker.remote.RemoteWorker;
import fabric.worker.remote.messages.InterWorkerMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ReadMessage
extends InterWorkerMessage<Response> {
    public final TransactionID tid;
    public final Store store;
    public final long onum;

    public ReadMessage(TransactionID tid, Store store, long onum) {
        super(Message.MessageType.INTERWORKER_READ);
        this.tid = tid;
        this.store = store;
        this.onum = onum;
    }

    public ReadMessage(DataInput in) throws IOException {
        this(new TransactionID(in), Worker.getWorker().getStore(in.readUTF()), in.readLong());
    }

    @Override
    public Response dispatch(MessageHandlerThread handler) throws ProtocolError {
        return handler.handle(this);
    }

    public Response send(RemoteWorker remoteWorker) throws UnreachableNodeException {
        try {
            return (Response)super.send(remoteWorker, true);
        }
        catch (UnreachableNodeException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from worker.", e);
        }
    }

    @Override
    public Response response(RemoteWorker worker, DataInput in) throws IOException {
        return new Response(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.tid.write(out);
        out.writeUTF(this.store.name());
        out.writeLong(this.onum);
    }

    public static class Response
    implements Message.Response {
        public final Object._Impl obj;

        public Response(Object._Impl obj) {
            this.obj = obj;
        }

        Response(DataInput in) throws IOException {
            if (!in.readBoolean()) {
                this.obj = null;
                return;
            }
            RemoteStore store = Worker.getWorker().getStore(in.readUTF());
            SerializedObject serialized = new SerializedObject(in);
            this.obj = serialized.deserialize(store);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            if (this.obj != null) {
                out.writeBoolean(true);
                out.writeUTF(this.obj.$getStore().name());
                SerializedObject.write(this.obj, out);
            } else {
                out.writeBoolean(false);
            }
        }
    }
}

