/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.remote.messages;

import fabric.common.exceptions.InternalError;
import fabric.lang.Object;
import fabric.messages.Message;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import fabric.worker.remote.RemoteWorker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class InterWorkerMessage<R extends Message.Response>
extends Message<RemoteWorker, R> {
    public InterWorkerMessage(Message.MessageType messageType) {
        super(messageType);
    }

    public static void writeRef(Object._Proxy ref, DataOutput out) throws IOException {
        out.writeUTF(ref.$getStore().name());
        out.writeLong(ref.$getOnum());
    }

    public static Object._Proxy readRef(Class<?> type, DataInput in) throws IOException {
        RemoteStore store = Worker.getWorker().getStore(in.readUTF());
        Class<?> proxyType = null;
        for (Class<?> c : type.getClasses()) {
            if (!c.getSimpleName().equals("_Proxy")) continue;
            proxyType = c;
            break;
        }
        if (proxyType == null) {
            throw new InternalError("Unable to find proxy class for " + type);
        }
        try {
            Constructor<?> constructor = proxyType.getConstructor(Store.class, Long.TYPE);
            return (Object._Proxy)constructor.newInstance(store, in.readLong());
        }
        catch (SecurityException e) {
            throw new InternalError(e);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e);
        }
        catch (IllegalArgumentException e) {
            throw new InternalError(e);
        }
        catch (InstantiationException e) {
            throw new InternalError(e);
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e);
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e);
        }
    }
}

