/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.remote.messages;

import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.lang.security.NodePrincipal;
import fabric.messages.Message;
import fabric.net.UnreachableNodeException;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import fabric.worker.remote.MessageHandlerThread;
import fabric.worker.remote.RemoteWorker;
import fabric.worker.remote.messages.InterWorkerMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GetPrincipalMessage
extends InterWorkerMessage<Response> {
    public GetPrincipalMessage() {
        super(Message.MessageType.GET_PRINCIPAL);
    }

    public GetPrincipalMessage(DataInput in) {
        this();
    }

    @Override
    public Response dispatch(MessageHandlerThread handler) {
        return handler.handle(this);
    }

    public Response send(RemoteWorker remoteWorker) throws UnreachableNodeException {
        try {
            return (Response)super.send(remoteWorker, true);
        }
        catch (UnreachableNodeException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from worker.", e);
        }
    }

    @Override
    public Response response(RemoteWorker worker, DataInput in) throws IOException {
        return new Response(in);
    }

    @Override
    public void write(DataOutput out) {
    }

    public static class Response
    implements Message.Response {
        public final NodePrincipal principal;

        public Response(NodePrincipal principal) {
            this.principal = principal;
        }

        Response(DataInput in) throws IOException {
            RemoteStore store = Worker.getWorker().getStore(in.readUTF());
            this.principal = new NodePrincipal._Proxy((Store)store, in.readLong());
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.principal.$getStore().name());
            out.writeLong(this.principal.$getOnum());
        }
    }
}

