/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.remote;

import fabric.common.Crypto;
import fabric.common.FastSerializable;
import fabric.common.ONumConstants;
import fabric.common.exceptions.InternalError;
import fabric.common.util.LongKeyMap;
import fabric.common.util.OidKeyHashMap;
import fabric.common.util.Pair;
import fabric.lang.Object;
import fabric.lang.security.Label;
import fabric.lang.security.SecretKeyObject;
import fabric.worker.LocalStore;
import fabric.worker.Store;
import fabric.worker.TransactionAbortingException;
import fabric.worker.Worker;
import fabric.worker.remote.RemoteWorker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class UpdateMap
implements FastSerializable {
    private static final String ALG_HASH = "MD5";
    private final long tid;
    private Map<Hash, Label> creates;
    private Map<Hash, Pair<byte[], byte[]>> updates;
    private OidKeyHashMap<RemoteWorker> readCache;
    private OidKeyHashMap<Pair<Object._Proxy, RemoteWorker>> writeCache;
    public int version;

    public UpdateMap(long tid) {
        this.creates = new HashMap<Hash, Label>();
        this.updates = new HashMap<Hash, Pair<byte[], byte[]>>();
        this.readCache = new OidKeyHashMap();
        this.writeCache = new OidKeyHashMap();
        this.version = 0;
        this.tid = tid;
    }

    public UpdateMap(UpdateMap map) {
        this.creates = new HashMap<Hash, Label>(map.creates);
        this.updates = new HashMap<Hash, Pair<byte[], byte[]>>(map.updates);
        this.readCache = new OidKeyHashMap<RemoteWorker>(map.readCache);
        this.writeCache = new OidKeyHashMap<Pair<Object._Proxy, RemoteWorker>>(map.writeCache);
        this.version = map.version;
        this.tid = map.tid;
    }

    public UpdateMap(DataInput in) throws IOException {
        this(in.readLong());
        Hash key;
        byte[] buf;
        int i;
        this.version = -1;
        Worker worker = Worker.getWorker();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            key = new Hash(buf);
            Label._Proxy val = null;
            if (in.readBoolean()) {
                String storeName = in.readUTF();
                long onum = in.readLong();
                Store store = worker.getLocalStore();
                if (!ONumConstants.isGlobalConstant(onum)) {
                    store = worker.getStore(storeName);
                }
                val = new Label._Proxy(store, onum);
            }
            this.creates.put(key, (Label)val);
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            key = new Hash(buf);
            byte[] iv = new byte[in.readInt()];
            in.readFully(iv);
            byte[] data = new byte[in.readInt()];
            in.readFully(data);
            this.updates.put(key, new Pair<byte[], byte[]>(iv, data));
        }
    }

    public boolean containsCreate(Object._Proxy proxy) {
        if (this.creates.isEmpty()) {
            return false;
        }
        try {
            return this.creates.containsKey(this.hash(proxy));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    public Label getCreate(Object._Proxy proxy) {
        if (this.creates.isEmpty()) {
            return null;
        }
        try {
            return this.creates.get(this.hash(proxy));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    public RemoteWorker getUpdate(Object._Proxy proxy) {
        if (this.readCache.containsKey(proxy)) {
            return this.readCache.get(proxy);
        }
        if (this.updates.isEmpty()) {
            return null;
        }
        RemoteWorker result = this.slowLookup(proxy, this.getKey(proxy));
        this.readCache.put(proxy, result);
        return result;
    }

    public RemoteWorker getUpdate(Object._Proxy proxy, Label label) {
        if (this.readCache.containsKey(proxy)) {
            return this.readCache.get(proxy);
        }
        if (this.updates.isEmpty()) {
            return null;
        }
        RemoteWorker result = this.slowLookup(proxy, this.getKey(label));
        this.readCache.put(proxy, result);
        return result;
    }

    private RemoteWorker slowLookup(Object._Proxy proxy, byte[] encryptKey) {
        try {
            Hash mapKey = this.hash(proxy, encryptKey);
            Pair<byte[], byte[]> encHost = this.updates.get(mapKey);
            if (encHost == null) {
                return null;
            }
            Cipher cipher = Crypto.cipherInstance(2, encryptKey, (byte[])encHost.first);
            String hostname = new String(cipher.doFinal((byte[])encHost.second));
            RemoteWorker result = Worker.getWorker().getWorker(hostname);
            if (!this.isValidWriter(result, proxy)) {
                throw new TransactionAbortingException("Invalid update map entry found.");
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new InternalError(e);
        }
    }

    private boolean isValidWriter(RemoteWorker worker, Object._Proxy proxy) {
        return true;
    }

    public void put(Object._Proxy proxy, Label keyObject) {
        if (ONumConstants.isGlobalConstant(proxy.$getOnum()) || proxy.$getStore() instanceof LocalStore) {
            return;
        }
        try {
            this.creates.put(this.hash(proxy), keyObject);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    public void put(Object._Proxy proxy, RemoteWorker worker) {
        if (ONumConstants.isGlobalConstant(proxy.$getOnum()) || proxy.$getStore() instanceof LocalStore) {
            return;
        }
        this.writeCache.put(proxy, new Pair<Object._Proxy, RemoteWorker>(proxy, worker));
        this.readCache.put(proxy, worker);
    }

    public void putAll(UpdateMap map) {
        this.creates.putAll(map.creates);
        if (map.updates.isEmpty()) {
            return;
        }
        this.flushWriteCache();
        map.flushWriteCache();
        this.updates.putAll(map.updates);
        this.readCache.clear();
        this.version = map.version > this.version ? map.version + 1 : ++this.version;
    }

    private void flushWriteCache() {
        for (LongKeyMap<Pair<Object._Proxy, RemoteWorker>> longKeyMap : this.writeCache) {
            for (Pair<Object._Proxy, RemoteWorker> val : longKeyMap.values()) {
                this.slowPut((Object._Proxy)val.first, (RemoteWorker)val.second);
            }
        }
        this.writeCache.clear();
    }

    private void slowPut(Object._Proxy proxy, RemoteWorker worker) {
        try {
            byte[] encryptKey = this.getKey(proxy);
            Hash mapKey = this.hash(proxy, encryptKey);
            byte[] iv = Crypto.makeIV();
            Cipher cipher = Crypto.cipherInstance(1, encryptKey, iv);
            Pair<byte[], byte[]> encHost = new Pair<byte[], byte[]>(iv, cipher.doFinal(worker.name.getBytes()));
            this.updates.put(mapKey, encHost);
        }
        catch (GeneralSecurityException e) {
            throw new InternalError(e);
        }
    }

    private Hash hash(Object._Proxy proxy) throws NoSuchAlgorithmException {
        return this.hash(proxy, null);
    }

    private Hash hash(Object._Proxy proxy, byte[] key) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance(ALG_HASH);
        Store store = proxy.$getStore();
        long onum = proxy.$getOnum();
        md5.update(store.name().getBytes());
        md5.update((byte)onum);
        md5.update((byte)(onum >>> 8));
        md5.update((byte)(onum >>> 16));
        md5.update((byte)(onum >>> 24));
        md5.update((byte)(onum >>> 32));
        md5.update((byte)(onum >>> 40));
        md5.update((byte)(onum >>> 48));
        md5.update((byte)(onum >>> 56));
        md5.update((byte)this.tid);
        md5.update((byte)(this.tid >>> 8));
        md5.update((byte)(this.tid >>> 16));
        md5.update((byte)(this.tid >>> 24));
        md5.update((byte)(this.tid >>> 32));
        md5.update((byte)(this.tid >>> 40));
        md5.update((byte)(this.tid >>> 48));
        md5.update((byte)(this.tid >>> 56));
        if (key != null) {
            md5.update(key);
        }
        return new Hash(md5.digest());
    }

    private byte[] getKey(Object._Proxy proxy) {
        return this.getKey(proxy.get$label());
    }

    private byte[] getKey(Label label) {
        SecretKeyObject keyObject = label.keyObject();
        if (keyObject == null) {
            return null;
        }
        return keyObject.getKey().getEncoded();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Hash key;
        this.flushWriteCache();
        out.writeLong(this.tid);
        out.writeInt(this.creates.size());
        for (Map.Entry<Hash, Label> entry : this.creates.entrySet()) {
            key = entry.getKey();
            Label value = entry.getValue();
            out.writeInt(key.hash.length);
            out.write(key.hash);
            if (value != null) {
                out.writeBoolean(true);
                out.writeUTF(value.$getStore().name());
                out.writeLong(value.$getOnum());
                continue;
            }
            out.writeBoolean(false);
        }
        out.writeInt(this.updates.size());
        for (Map.Entry<Hash, Object> entry : this.updates.entrySet()) {
            key = entry.getKey();
            Pair val = (Pair)entry.getValue();
            out.writeInt(key.hash.length);
            out.write(key.hash);
            out.writeInt(((byte[])val.first).length);
            out.write((byte[])val.first);
            out.writeInt(((byte[])val.second).length);
            out.write((byte[])val.second);
        }
    }

    private static class Hash {
        private byte[] hash;
        private int hashCode;

        Hash(byte[] hash) {
            this.hash = hash;
            this.hashCode = hash[0] << 24 | hash[1] << 16 | hash[2] << 8 | hash[3];
        }

        public boolean equals(Object obj) {
            Hash other = (Hash)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            for (int i = 4; i < this.hash.length; ++i) {
                if (this.hash[i] == other.hash[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

