/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.remote;

import fabric.common.ObjectGroup;
import fabric.common.TransactionID;
import fabric.common.exceptions.InternalError;
import fabric.common.net.naming.SocketAddress;
import fabric.dissemination.Glob;
import fabric.lang.Object;
import fabric.lang.security.NodePrincipal;
import fabric.messages.AbortTransactionMessage;
import fabric.messages.CommitTransactionMessage;
import fabric.messages.ObjectUpdateMessage;
import fabric.messages.PrepareTransactionMessage;
import fabric.net.RemoteNode;
import fabric.net.UnreachableNodeException;
import fabric.worker.Store;
import fabric.worker.TransactionCommitFailedException;
import fabric.worker.TransactionPrepareFailedException;
import fabric.worker.Worker;
import fabric.worker.remote.RemoteCallException;
import fabric.worker.remote.UpdateMap;
import fabric.worker.remote.messages.GetPrincipalMessage;
import fabric.worker.remote.messages.ReadMessage;
import fabric.worker.remote.messages.RemoteCallMessage;
import fabric.worker.remote.messages.StalenessCheckMessage;
import fabric.worker.remote.messages.TakeOwnershipMessage;
import fabric.worker.transaction.Log;
import fabric.worker.transaction.TransactionManager;
import fabric.worker.transaction.TransactionRegistry;
import java.io.IOException;

public final class RemoteWorker
extends RemoteNode {
    public RemoteWorker(String name) {
        super(name, true);
    }

    public Object issueRemoteCall(Object._Proxy receiver, String methodName, Class<?>[] parameterTypes, Object[] args) throws UnreachableNodeException, RemoteCallException {
        TransactionManager tm = TransactionManager.getInstance();
        tm.registerRemoteCall(this);
        TransactionID tid = tm.getCurrentTid();
        UpdateMap updateMap = tm.getUpdateMap();
        Class<?> receiverClass = receiver.fetch().$getProxy().getClass().getEnclosingClass();
        RemoteCallMessage.Response response = new RemoteCallMessage(tid, updateMap, receiverClass, receiver, methodName, parameterTypes, args).send(this);
        Log innermost = TransactionRegistry.getInnermostLog(tid.topTid);
        tm.associateAndSyncLog(innermost, tid);
        if (response.updateMap != null) {
            tm.getUpdateMap().putAll(response.updateMap);
        }
        return response.result;
    }

    public void prepareTransaction(long tid, long commitTime) throws UnreachableNodeException, TransactionPrepareFailedException {
        new PrepareTransactionMessage(tid, commitTime).send(this);
    }

    public void commitTransaction(long tid) throws UnreachableNodeException, TransactionCommitFailedException {
        CommitTransactionMessage.Response response = new CommitTransactionMessage(tid).send(this);
        if (!response.success) {
            throw new TransactionCommitFailedException(response.message);
        }
    }

    public void abortTransaction(TransactionID tid) throws UnreachableNodeException {
        new AbortTransactionMessage(tid).send(this);
    }

    public void readObject(TransactionID tid, Object._Impl obj) {
        Object._Impl remoteObj = this.readObject(tid, obj.$getStore(), obj.$getOnum());
        if (remoteObj == null) {
            throw new InternalError("Inter-worker object read failed.");
        }
        obj.$copyAppStateFrom(remoteObj);
    }

    public Object._Impl readObject(TransactionID tid, Store store, long onum) {
        ReadMessage.Response response = new ReadMessage(tid, store, onum).send(this);
        return response.obj;
    }

    public void takeOwnership(TransactionID tid, Store store, long onum) {
        TakeOwnershipMessage.Response response = new TakeOwnershipMessage(tid, store, onum).send(this);
        if (!response.success) {
            throw new InternalError("Unable to take ownership of object fab://" + store.name() + "/" + onum + " from " + this.name + " -- either " + this.name + " doesn't own the object or authorization has failed.");
        }
    }

    public NodePrincipal getPrincipal() {
        String expectedPrincipalName;
        GetPrincipalMessage.Response response = new GetPrincipalMessage().send(this);
        final NodePrincipal principal = response.principal;
        try {
            expectedPrincipalName = "cn=" + this.name;
        }
        catch (IllegalStateException e) {
            throw new InternalError(e);
        }
        boolean authenticated = Worker.runInTransaction(null, new Worker.Code<Boolean>(){

            @Override
            public Boolean run() {
                return principal.name().equals(expectedPrincipalName);
            }
        });
        if (authenticated) {
            return principal;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean notifyObjectUpdate(String store, long onum, Glob glob) {
        ObjectUpdateMessage.Response response = new ObjectUpdateMessage(store, onum, glob).send(this);
        return response.resubscribe;
    }

    public boolean notifyObjectUpdate(long onum, ObjectGroup group) {
        ObjectUpdateMessage.Response response = new ObjectUpdateMessage(onum, group).send(this);
        return response.resubscribe;
    }

    public boolean checkForStaleObjects(TransactionID tid) {
        StalenessCheckMessage.Response response = new StalenessCheckMessage(tid).send(this);
        return response.result;
    }

    @Override
    protected SocketAddress lookup() throws IOException {
        return Worker.getWorker().workerNameService.resolve(this.name);
    }
}

