/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.remote;

import fabric.common.FabricThread;
import fabric.worker.Worker;
import fabric.worker.remote.ConnectionHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class RemoteCallManager
extends FabricThread.AbstractImpl {
    volatile boolean shuttingDown = false;
    private final ConnectionHandler connectionHandler = new ConnectionHandler(this);

    public RemoteCallManager() {
        super("remote call manager");
    }

    @Override
    public void run() {
        try {
            ServerSocketChannel server = ServerSocketChannel.open();
            server.configureBlocking(true);
            server.socket().bind(new InetSocketAddress(Worker.getWorker().port));
            while (!this.shuttingDown) {
                try {
                    SocketChannel connection = server.accept();
                    this.connectionHandler.handle(connection);
                }
                catch (ClosedByInterruptException e) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.shuttingDown = true;
        this.connectionHandler.shutdown();
        this.interrupt();
    }
}

