/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.remote;

import fabric.common.AbstractMessageHandlerThread;
import fabric.common.AuthorizationUtil;
import fabric.common.TransactionID;
import fabric.common.exceptions.ProtocolError;
import fabric.lang.Object;
import fabric.lang.security.Label;
import fabric.messages.AbortTransactionMessage;
import fabric.messages.CommitTransactionMessage;
import fabric.messages.ObjectUpdateMessage;
import fabric.messages.PrepareTransactionMessage;
import fabric.worker.RemoteStore;
import fabric.worker.TransactionAtomicityViolationException;
import fabric.worker.TransactionPrepareFailedException;
import fabric.worker.Worker;
import fabric.worker.remote.RemoteCallException;
import fabric.worker.remote.RemoteCallManager;
import fabric.worker.remote.SessionAttributes;
import fabric.worker.remote.UpdateMap;
import fabric.worker.remote.messages.GetPrincipalMessage;
import fabric.worker.remote.messages.ReadMessage;
import fabric.worker.remote.messages.RemoteCallMessage;
import fabric.worker.remote.messages.StalenessCheckMessage;
import fabric.worker.remote.messages.TakeOwnershipMessage;
import fabric.worker.transaction.Log;
import fabric.worker.transaction.TransactionManager;
import fabric.worker.transaction.TransactionRegistry;
import java.lang.reflect.InvocationTargetException;

public class MessageHandlerThread
extends AbstractMessageHandlerThread<SessionAttributes, MessageHandlerThread> {
    private final RemoteCallManager rcm;
    private final Worker worker;

    public MessageHandlerThread(RemoteCallManager rcm, AbstractMessageHandlerThread.Pool<MessageHandlerThread> pool) {
        super("RCM message handler", pool);
        this.rcm = rcm;
        this.worker = Worker.getWorker();
        TransactionManager.startThread(this);
    }

    @Override
    protected boolean shuttingDown() {
        return this.rcm.shuttingDown;
    }

    public RemoteCallMessage.Response handle(final RemoteCallMessage remoteCallMessage) throws RemoteCallException, ProtocolError {
        if (((SessionAttributes)this.session).isDissemConnection) {
            throw new ProtocolError("Message not supported.");
        }
        TransactionID tid = remoteCallMessage.tid;
        TransactionManager tm = TransactionManager.getInstance();
        if (tid != null) {
            Log log = TransactionRegistry.getOrCreateInnermostLog(tid);
            tm.associateAndSyncLog(log, tid);
            tm.getUpdateMap().putAll(remoteCallMessage.updateMap);
        }
        try {
            java.lang.Object result = Worker.runInSubTransaction(new Worker.Code<java.lang.Object>(){

                @Override
                public java.lang.Object run() {
                    try {
                        Object._Proxy receiver = remoteCallMessage.receiver.fetch().$getProxy();
                        java.lang.Object[] args = new java.lang.Object[remoteCallMessage.args.length + 1];
                        args[0] = ((SessionAttributes)((MessageHandlerThread)MessageHandlerThread.this).session).remotePrincipal;
                        for (int i = 0; i < remoteCallMessage.args.length; ++i) {
                            java.lang.Object arg = remoteCallMessage.args[i];
                            if (arg instanceof Object) {
                                arg = ((Object)arg).fetch().$getProxy();
                            }
                            args[i + 1] = arg;
                        }
                        return remoteCallMessage.getMethod().invoke((java.lang.Object)receiver, args);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    catch (SecurityException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            UpdateMap updateMap = TransactionManager.getInstance().getUpdateMap();
            RemoteCallMessage.Response response = new RemoteCallMessage.Response(result, updateMap);
            return response;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException || cause instanceof SecurityException || cause instanceof IllegalAccessException || cause instanceof InvocationTargetException || cause instanceof NoSuchMethodException || cause instanceof RuntimeException) {
                throw new RemoteCallException(cause);
            }
            throw e;
        }
        finally {
            tm.associateLog(null);
        }
    }

    public void handle(AbortTransactionMessage abortTransactionMessage) throws ProtocolError {
        if (((SessionAttributes)this.session).isDissemConnection) {
            throw new ProtocolError("Message not supported.");
        }
        Log log = TransactionRegistry.getInnermostLog(abortTransactionMessage.tid.topTid);
        if (log == null) {
            return;
        }
        TransactionManager tm = TransactionManager.getInstance();
        tm.associateAndSyncLog(log, abortTransactionMessage.tid);
        tm.abortTransaction();
        tm.associateLog(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrepareTransactionMessage.Response handle(PrepareTransactionMessage prepareTransactionMessage) throws ProtocolError, TransactionPrepareFailedException {
        if (((SessionAttributes)this.session).isDissemConnection) {
            throw new ProtocolError("Message not supported.");
        }
        Log log = TransactionRegistry.getInnermostLog(prepareTransactionMessage.tid);
        if (log == null) {
            throw new TransactionPrepareFailedException("No such transaction");
        }
        TransactionManager tm = TransactionManager.getInstance();
        TransactionID topTid = log.getTid();
        while (topTid.depth > 0) {
            topTid = topTid.parent;
        }
        tm.associateAndSyncLog(log, topTid);
        try {
            tm.sendPrepareMessages(prepareTransactionMessage.commitTime);
        }
        finally {
            tm.associateLog(null);
        }
        return new PrepareTransactionMessage.Response();
    }

    public CommitTransactionMessage.Response handle(CommitTransactionMessage commitTransactionMessage) throws ProtocolError {
        if (((SessionAttributes)this.session).isDissemConnection) {
            throw new ProtocolError("Message not supported.");
        }
        Log log = TransactionRegistry.getInnermostLog(commitTransactionMessage.transactionID);
        if (log == null) {
            return new CommitTransactionMessage.Response(true);
        }
        TransactionManager tm = TransactionManager.getInstance();
        tm.associateLog(log);
        try {
            tm.sendCommitMessagesAndCleanUp();
        }
        catch (TransactionAtomicityViolationException e) {
            tm.associateLog(null);
            return new CommitTransactionMessage.Response(false);
        }
        return new CommitTransactionMessage.Response(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadMessage.Response handle(ReadMessage readMessage) throws ProtocolError {
        Object._Impl obj;
        if (((SessionAttributes)this.session).isDissemConnection) {
            throw new ProtocolError("Message not supported.");
        }
        Log log = TransactionRegistry.getInnermostLog(readMessage.tid.topTid);
        if (log == null) {
            return new ReadMessage.Response(null);
        }
        Object._Impl _Impl2 = obj = new Object._Proxy(readMessage.store, readMessage.onum).fetch();
        synchronized (_Impl2) {
            if (!obj.$isOwned) {
                return new ReadMessage.Response(null);
            }
        }
        TransactionManager tm = TransactionManager.getInstance();
        tm.associateAndSyncLog(log, readMessage.tid);
        Label label = obj.get$label();
        if (!AuthorizationUtil.isReadPermitted(((SessionAttributes)this.session).remotePrincipal, label.$getStore(), label.$getOnum())) {
            obj = null;
        }
        tm.associateLog(null);
        return new ReadMessage.Response(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TakeOwnershipMessage.Response handle(TakeOwnershipMessage takeOwnershipMessage) throws ProtocolError {
        Object._Impl obj;
        if (((SessionAttributes)this.session).isDissemConnection) {
            throw new ProtocolError("Message not supported.");
        }
        Log log = TransactionRegistry.getInnermostLog(takeOwnershipMessage.tid.topTid);
        if (log == null) {
            return new TakeOwnershipMessage.Response(false);
        }
        Object._Impl _Impl2 = obj = new Object._Proxy(takeOwnershipMessage.store, takeOwnershipMessage.onum).fetch();
        synchronized (_Impl2) {
            if (!obj.$isOwned) {
                return new TakeOwnershipMessage.Response(false);
            }
        }
        TransactionManager tm = TransactionManager.getInstance();
        tm.associateAndSyncLog(log, takeOwnershipMessage.tid);
        Label label = obj.get$label();
        boolean authorized = AuthorizationUtil.isWritePermitted(((SessionAttributes)this.session).remotePrincipal, label.$getStore(), label.$getOnum());
        tm.associateLog(null);
        if (authorized) {
            obj.$isOwned = false;
            return new TakeOwnershipMessage.Response(true);
        }
        return new TakeOwnershipMessage.Response(false);
    }

    public GetPrincipalMessage.Response handle(GetPrincipalMessage getPrincipalMessage) {
        return new GetPrincipalMessage.Response(this.worker.getPrincipal());
    }

    public ObjectUpdateMessage.Response handle(ObjectUpdateMessage objectUpdateMessage) {
        boolean response;
        if (objectUpdateMessage.group == null) {
            RemoteStore store = this.worker.getStore(objectUpdateMessage.store);
            response = this.worker.updateDissemCaches(store, objectUpdateMessage.onum, objectUpdateMessage.glob);
        } else {
            RemoteStore store = this.worker.getStore(((SessionAttributes)this.session).remoteNodeName);
            response = this.worker.updateCache(store, objectUpdateMessage.group);
        }
        return new ObjectUpdateMessage.Response(response);
    }

    public StalenessCheckMessage.Response handle(StalenessCheckMessage stalenessCheckMessage) throws ProtocolError {
        if (((SessionAttributes)this.session).isDissemConnection) {
            throw new ProtocolError("Message not supported.");
        }
        TransactionID tid = stalenessCheckMessage.tid;
        if (tid == null) {
            return new StalenessCheckMessage.Response(false);
        }
        TransactionManager tm = TransactionManager.getInstance();
        Log log = TransactionRegistry.getOrCreateInnermostLog(tid);
        tm.associateAndSyncLog(log, tid);
        boolean result = tm.checkForStaleObjects();
        tm.associateLog(null);
        return new StalenessCheckMessage.Response(result);
    }

    static class Factory
    implements AbstractMessageHandlerThread.Factory<MessageHandlerThread> {
        private final RemoteCallManager rcm;

        Factory(RemoteCallManager rcm) {
            this.rcm = rcm;
        }

        @Override
        public MessageHandlerThread createMessageHandler(AbstractMessageHandlerThread.Pool<MessageHandlerThread> pool) {
            return new MessageHandlerThread(this.rcm, pool);
        }
    }
}

