/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.remote;

import fabric.common.AbstractConnectionHandler;
import fabric.common.Logging;
import fabric.lang.security.NodePrincipal;
import fabric.worker.Worker;
import fabric.worker.remote.MessageHandlerThread;
import fabric.worker.remote.RemoteCallManager;
import fabric.worker.remote.SessionAttributes;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.logging.Level;

public class ConnectionHandler
extends AbstractConnectionHandler<Object, SessionAttributes, MessageHandlerThread> {
    private static final int POOL_SIZE = 10;

    public ConnectionHandler(RemoteCallManager rcm) {
        super(10, new MessageHandlerThread.Factory(rcm));
    }

    @Override
    protected Object getNodeByName(String name) {
        if (Worker.getWorker().name.equalsIgnoreCase(name)) {
            return Collections.EMPTY_LIST;
        }
        return null;
    }

    @Override
    protected String getThreadName(SocketAddress remote, SessionAttributes session) {
        return "Connection handler for " + session.remoteNodeName + " talking to local worker";
    }

    @Override
    protected void logAuthenticationFailure() {
        Logging.NETWORK_CONNECTION_LOGGER.info("Worker rejected connection: authentication failed.");
    }

    @Override
    protected void logSession(SocketAddress remote, SessionAttributes session) {
        Logging.log(Logging.NETWORK_CONNECTION_LOGGER, Level.INFO, "Worker accepted connection from {0} at {1}", session.remoteNodeName, remote);
    }

    @Override
    protected SessionAttributes newAuthenticatedSession(Object node, String remoteNodeName, String remoteNodePrincipalName, NodePrincipal remoteNodePrincipal) {
        return new SessionAttributes(remoteNodeName, remoteNodePrincipalName, remoteNodePrincipal);
    }

    @Override
    protected SessionAttributes newUnauthenticatedSession(Object node, String remoteNodeName) {
        return new SessionAttributes(remoteNodeName);
    }
}

