/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker.debug;

import java.io.PrintStream;
import java.util.Stack;

public enum Timing {
    APP,
    BEGIN,
    COMMIT,
    TXLOG,
    SUBTX,
    FETCH,
    STORE;

    private long time;
    private int count;
    public boolean enabled = false;
    private static Stack<Timing> scope;
    private static long stamp;
    private static boolean debug;

    private static void attribute() {
        long now = System.currentTimeMillis();
        Timing t = scope.peek();
        t.time += now - stamp;
        ++t.count;
        stamp = now;
    }

    public void begin() {
        if (this.enabled) {
            Timing.attribute();
            scope.push(this);
        }
    }

    public void end() {
        if (this.enabled) {
            Timing.attribute();
            if (scope.pop() != this && debug) {
                throw new AssertionError();
            }
        }
    }

    public static void printStats() {
        Timing.printStats(System.out);
    }

    public static void printStats(PrintStream out) {
        Timing.attribute();
        long total = 0L;
        int count = 0;
        for (Timing t : Timing.values()) {
            total += t.time;
            count += t.count;
        }
        for (Timing t : Timing.values()) {
            if (!t.enabled) continue;
            out.format("%6s:  %6d ms\n", t.name().toLowerCase(), t.time);
        }
        out.format(" Total: %7d ms (%-8d measurements)\n", total, count);
    }

    public static void reset() {
        for (Timing t : Timing.values()) {
            t.time = 0L;
            t.count = 0;
        }
        scope = new Stack();
        scope.push(APP);
        Timing.APP.count = 1;
        stamp = System.currentTimeMillis();
    }

    public static void main(String[] args) {
        long begin = System.currentTimeMillis();
        int n = 500000;
        Timing.APP.enabled = true;
        for (int i = 0; i < n; ++i) {
            APP.begin();
            APP.end();
        }
        long end = System.currentTimeMillis();
        System.out.println(((double)end - (double)begin) / 2.0 / (double)n);
    }

    static {
        debug = true;
        Timing.reset();
    }
}

