/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker;

import fabric.common.ConfigProperties;
import fabric.common.Logging;
import fabric.common.ObjectGroup;
import fabric.common.SSLSocketFactoryTable;
import fabric.common.SerializedObject;
import fabric.common.TransactionID;
import fabric.common.Version;
import fabric.common.exceptions.InternalError;
import fabric.common.exceptions.TerminationException;
import fabric.common.exceptions.UsageError;
import fabric.common.net.naming.DefaultNameService;
import fabric.common.net.naming.NameService;
import fabric.dissemination.FetchManager;
import fabric.dissemination.Glob;
import fabric.dissemination.pastry.Cache;
import fabric.lang.Object;
import fabric.lang.WrappedJavaInlineable;
import fabric.lang.arrays.ObjectArray;
import fabric.lang.security.ConfPolicy;
import fabric.lang.security.IntegPolicy;
import fabric.lang.security.Label;
import fabric.lang.security.LabelUtil;
import fabric.lang.security.NodePrincipal;
import fabric.worker.AbortException;
import fabric.worker.FabricSoftRef;
import fabric.worker.LocalStore;
import fabric.worker.MainThread;
import fabric.worker.Options;
import fabric.worker.RemoteStore;
import fabric.worker.RetryException;
import fabric.worker.Store;
import fabric.worker.TransactionRestartingException;
import fabric.worker.debug.Timing;
import fabric.worker.remote.RemoteCallManager;
import fabric.worker.remote.RemoteWorker;
import fabric.worker.transaction.Log;
import fabric.worker.transaction.TransactionManager;
import fabric.worker.transaction.TransactionRegistry;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public final class Worker {
    public final String name;
    public final int port;
    protected final Map<String, RemoteStore> stores;
    private final Map<String, RemoteWorker> remoteWorkers;
    protected final LocalStore localStore;
    protected final KeyStore keyStore;
    public final SSLSocketFactory sslSocketFactory;
    protected final NodePrincipal principal;
    public final Principal javaPrincipal;
    public final int timeout;
    public final int retries;
    public final NameService storeNameService;
    public final NameService workerNameService;
    protected final FetchManager fetchManager;
    private final List<Cache> disseminationCaches;
    private final RemoteCallManager remoteCallManager;
    public static final Random RAND = new Random();
    private static final int DEFAULT_TIMEOUT = 2;
    private static final Timing t = Timing.APP;
    protected static Worker instance;

    private static Worker initialize(String name, int port, String principalURL, KeyStore keyStore, char[] passwd, int maxConnections, int timeout, int retries, boolean useSSL, String fetcher, Properties dissemConfig, Map<String, RemoteStore> initStoreSet) throws InternalError, UnrecoverableKeyException, IllegalStateException, UsageError {
        if (instance != null) {
            throw new IllegalStateException("The Fabric worker has already been initialized");
        }
        Logging.WORKER_LOGGER.info("Initializing Fabric worker");
        Logging.WORKER_LOGGER.config("maximum connections: " + maxConnections);
        Logging.WORKER_LOGGER.config("timeout:             " + timeout);
        Logging.WORKER_LOGGER.config("retries:             " + retries);
        Logging.WORKER_LOGGER.config("use ssl:             " + useSSL);
        instance = new Worker(name, port, principalURL, keyStore, passwd, maxConnections, timeout, retries, useSSL, fetcher, dissemConfig, initStoreSet);
        Worker.instance.remoteCallManager.start();
        Worker.instance.localStore.initialize();
        System.out.println("Worker started");
        return instance;
    }

    private Worker(String name, int port, String principalURL, KeyStore keyStore, char[] passwd, int maxConnections, int timeout, int retries, boolean useSSL, String fetcher, Properties dissemConfig, Map<String, RemoteStore> initStoreSet) throws InternalError, UnrecoverableKeyException, UsageError {
        if (timeout < 1) {
            timeout = 2;
        }
        this.name = name;
        this.port = port;
        this.timeout = 1000 * timeout;
        this.retries = retries;
        fabric.common.Options.DEBUG_NO_SSL = !useSSL;
        this.keyStore = keyStore;
        try {
            this.storeNameService = new DefaultNameService(DefaultNameService.PortType.STORE);
            this.workerNameService = new DefaultNameService(DefaultNameService.PortType.WORKER);
        }
        catch (IOException e) {
            throw new InternalError("Unable to load the name service", e);
        }
        this.stores = new HashMap<String, RemoteStore>();
        if (initStoreSet != null) {
            this.stores.putAll(initStoreSet);
        }
        this.remoteWorkers = new HashMap<String, RemoteWorker>();
        this.localStore = new LocalStore();
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, passwd);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            tmf.init(keyStore);
            TrustManager[] tm = tmf.getTrustManagers();
            sslContext.init(kmf.getKeyManagers(), tm, null);
            this.sslSocketFactory = sslContext.getSocketFactory();
            SSLSocketFactoryTable.register(name, this.sslSocketFactory);
            this.javaPrincipal = ((X509KeyManager)kmf.getKeyManagers()[0]).getCertificateChain(name)[0].getSubjectX500Principal();
        }
        catch (KeyManagementException e) {
            throw new InternalError("Unable to initialise key manager factory.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
        catch (KeyStoreException e) {
            throw new InternalError("Unable to initialise key manager factory.", e);
        }
        if (principalURL != null) {
            try {
                URI principalPath = new URI(principalURL);
                RemoteStore store = this.getStore(principalPath.getHost());
                long onum = Long.parseLong(principalPath.getPath().substring(1));
                this.principal = new NodePrincipal._Proxy((Store)store, onum);
            }
            catch (URISyntaxException e) {
                throw new UsageError("Invalid principal URL specified.", 1);
            }
        } else {
            this.principal = null;
        }
        this.remoteCallManager = new RemoteCallManager();
        this.disseminationCaches = new ArrayList<Cache>(1);
        try {
            Constructor<?> fetchManagerConstructor = Class.forName(fetcher).getConstructor(Worker.class, Properties.class);
            this.fetchManager = (FetchManager)fetchManagerConstructor.newInstance(this, dissemConfig);
        }
        catch (Exception e) {
            throw new InternalError("Unable to load fetch manager", e);
        }
    }

    public static Worker getWorker() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("The Fabric worker is uninitialized.  Call Worker.init(...)");
        }
        return instance;
    }

    public RemoteStore getStore(String name) {
        RemoteStore result = this.stores.get(name);
        if (result == null) {
            result = new RemoteStore(name);
            this.stores.put(name, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteWorker getWorker(String name) {
        RemoteWorker result;
        Map<String, RemoteWorker> map = this.remoteWorkers;
        synchronized (map) {
            result = this.remoteWorkers.get(name);
            if (result == null) {
                result = new RemoteWorker(name);
                this.remoteWorkers.put(name, result);
            }
        }
        return result;
    }

    public LocalStore getLocalStore() {
        return this.localStore;
    }

    public RemoteWorker getLocalWorker() {
        return this.getWorker(this.name);
    }

    public FetchManager fetchManager() {
        return this.fetchManager;
    }

    public void registerDisseminationCache(Cache cache) {
        this.disseminationCaches.add(cache);
    }

    public boolean updateDissemCaches(RemoteStore store, long onum, Glob update) {
        boolean result = false;
        for (Cache cache : this.disseminationCaches) {
            result |= cache.updateEntry(store, onum, update);
        }
        return result;
    }

    public boolean updateCache(RemoteStore store, ObjectGroup group) {
        boolean result = false;
        for (SerializedObject obj : group.objects().values()) {
            result |= store.updateCache(obj);
        }
        return result;
    }

    public NodePrincipal getPrincipal() {
        return this.principal;
    }

    public Principal getJavaPrincipal() {
        return this.javaPrincipal;
    }

    public void clearCache() {
        for (RemoteStore store : this.stores.values()) {
            store.clearCache();
        }
    }

    public void shutdown() {
        Worker.shutdown_();
        this.remoteCallManager.shutdown();
        this.fetchManager.destroy();
        for (RemoteStore store : this.stores.values()) {
            if (!(store instanceof RemoteStore)) continue;
            store.cleanup();
        }
        for (RemoteWorker worker : this.remoteWorkers.values()) {
            worker.cleanup();
        }
    }

    private static void shutdown_() {
        FabricSoftRef.destroy();
    }

    public static void initialize(String name) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IllegalStateException, IOException, InternalError, UsageError {
        Worker.initialize(name, null, null);
    }

    public static void initialize(String name, String principalURL, Map<String, RemoteStore> initStoreSet) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, IllegalStateException, InternalError, UsageError {
        ConfigProperties props = new ConfigProperties(name);
        if (principalURL == null) {
            principalURL = props.workerPrincipal;
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        char[] passwd = props.password;
        String filename = props.keystore;
        FileInputStream in = new FileInputStream(filename);
        keyStore.load(in, passwd);
        ((InputStream)in).close();
        int port = props.workerPort;
        int maxConnections = props.maxConnections;
        int timeout = props.timeout;
        int retries = props.retries;
        String fetcher = props.dissemClass;
        Properties dissemConfig = props.disseminationProperties;
        boolean useSSL = props.useSSL;
        Worker.initialize(name, port, principalURL, keyStore, passwd, maxConnections, timeout, retries, useSSL, fetcher, dissemConfig, initStoreSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        Logging.WORKER_LOGGER.info("Worker node");
        Logging.WORKER_LOGGER.config("Fabric version " + new Version());
        Logging.WORKER_LOGGER.info("");
        Worker worker = null;
        try {
            Options opts;
            try {
                opts = new Options(args);
                Worker.initialize(opts.name);
                worker = Worker.getWorker();
                if (worker.getPrincipal() == null && opts.store == null && opts.app != null) {
                    throw new UsageError("No fabric.worker.principal specified in the worker configuration.  Either\nspecify one or create a principal with --make-principal.");
                }
            }
            catch (UsageError ue) {
                PrintStream out;
                PrintStream printStream = out = ue.exitCode == 0 ? System.out : System.err;
                if (ue.getMessage() != null && ue.getMessage().length() > 0) {
                    out.println(ue.getMessage());
                    out.println();
                }
                Options.usage(out);
                throw new TerminationException(ue.exitCode);
            }
            StringBuilder cmd = new StringBuilder("Command Line: Worker");
            for (String s : args) {
                cmd.append(" ");
                cmd.append(s);
            }
            Logging.WORKER_LOGGER.config(cmd.toString());
            if (opts.store != null) {
                final String name = worker.getJavaPrincipal().getName();
                final RemoteStore store = worker.getStore(opts.store);
                Worker.runInSubTransaction(new Code<Void>(){

                    @Override
                    public Void run() {
                        NodePrincipal._Impl principal = new NodePrincipal._Impl(store, null, name);
                        principal.addDelegatesTo((fabric.lang.security.Principal)store.getPrincipal());
                        System.out.println("Worker principal created:");
                        System.out.println("fab://" + opts.store + "/" + principal.$getOnum());
                        return null;
                    }
                });
                return;
            }
            if (opts.app == null) {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(Long.MAX_VALUE);
                        }
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            final NodePrincipal workerPrincipal = worker.getPrincipal();
            Worker.runInSubTransaction(new Code<Void>(){

                @Override
                public Void run() {
                    Logging.WORKER_LOGGER.config("Worker principal is " + workerPrincipal);
                    return null;
                }
            });
            Class<?> mainClass = Class.forName(opts.app[0] + "$_Impl");
            Method main = mainClass.getMethod("main", ObjectArray.class);
            final String[] newArgs = new String[opts.app.length - 1];
            for (int i = 0; i < newArgs.length; ++i) {
                newArgs[i] = opts.app[i + 1];
            }
            final LocalStore local = worker.getLocalStore();
            Object argsProxy = Worker.runInSubTransaction(new Code<Object>(){

                @Override
                public Object run() {
                    ConfPolicy conf = LabelUtil._Impl.readerPolicy((Store)local, (fabric.lang.security.Principal)workerPrincipal, (fabric.lang.security.Principal)workerPrincipal);
                    IntegPolicy integ = LabelUtil._Impl.writerPolicy((Store)local, (fabric.lang.security.Principal)workerPrincipal, (fabric.lang.security.Principal)workerPrincipal);
                    Label label = LabelUtil._Impl.toLabel((Store)local, (ConfPolicy)conf, (IntegPolicy)integ);
                    return WrappedJavaInlineable.$wrap(local, label, newArgs);
                }
            });
            MainThread.invoke(opts, main, argsProxy);
        }
        finally {
            if (worker != null) {
                worker.shutdown();
            } else {
                Worker.shutdown_();
            }
        }
    }

    public void setStore(String name, RemoteStore store) {
        this.stores.put(name, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInTransaction(TransactionID tid, Code<T> code) {
        TransactionManager tm = TransactionManager.getInstance();
        Log oldLog = tm.getCurrentLog();
        Log log = TransactionRegistry.getOrCreateInnermostLog(tid);
        tm.associateAndSyncLog(log, tid);
        try {
            T t = Worker.runInSubTransaction(code);
            return t;
        }
        finally {
            tm.associateLog(oldLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInTransactionUnauthenticated(Code<T> code) {
        TransactionManager tm = TransactionManager.getInstance();
        Log oldLog = tm.getCurrentLog();
        tm.associateAndSyncLog(null, null);
        try {
            T t = Worker.runInSubTransaction(false, code);
            return t;
        }
        finally {
            tm.associateLog(oldLog);
        }
    }

    public static <T> T runInSubTransaction(Code<T> code) {
        return Worker.runInSubTransaction(true, code);
    }

    private static <T> T runInSubTransaction(boolean useAuthentication, Code<T> code) {
        TransactionManager tm = TransactionManager.getInstance();
        boolean success = false;
        int backoff = 1;
        while (!success) {
            if (backoff > 32) {
                while (true) {
                    try {
                        Thread.sleep(backoff);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            if (backoff < 5000) {
                backoff *= 2;
            }
            success = true;
            tm.startTransaction();
            try {
                T e = code.run();
                return e;
            }
            catch (RetryException e) {
                success = false;
            }
            catch (TransactionRestartingException e) {
                success = false;
                TransactionID currentTid = tm.getCurrentTid();
                if (e.tid.isDescendantOf(currentTid)) continue;
                if (currentTid.parent != null) {
                    throw e;
                }
                throw new InternalError("Something is broken with transaction management. Got a signal to restart a different transaction than the one being managed.");
            }
            catch (Throwable e) {
                success = false;
                if (tm.checkForStaleObjects()) continue;
                throw new AbortException(e);
            }
            finally {
                if (success) {
                    try {
                        tm.commitTransaction(useAuthentication);
                        continue;
                    }
                    catch (AbortException e) {
                        success = false;
                        continue;
                    }
                    catch (TransactionRestartingException e) {
                        success = false;
                        TransactionID currentTid = tm.getCurrentTid();
                        if (currentTid == null || e.tid.isDescendantOf(currentTid) && !currentTid.equals(e.tid)) continue;
                        throw e;
                    }
                }
                tm.abortTransaction();
            }
        }
        throw new InternalError();
    }

    public static interface Code<T> {
        public T run() throws Throwable;
    }
}

