/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker;

import fabric.common.SerializedObject;
import fabric.common.exceptions.FabricException;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.net.RemoteNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TransactionPrepareFailedException
extends FabricException {
    public final LongKeyMap<SerializedObject> versionConflicts;
    public final List<String> messages;

    public TransactionPrepareFailedException(LongKeyMap<SerializedObject> versionConflicts) {
        this.versionConflicts = versionConflicts;
        this.messages = null;
    }

    public TransactionPrepareFailedException(Map<RemoteNode, TransactionPrepareFailedException> failures) {
        this.versionConflicts = null;
        this.messages = new ArrayList<String>();
        for (Map.Entry<RemoteNode, TransactionPrepareFailedException> entry : failures.entrySet()) {
            TransactionPrepareFailedException exn = entry.getValue();
            if (exn.messages == null) continue;
            for (String s : exn.messages) {
                this.messages.add(entry.getKey() + ": " + s);
            }
        }
    }

    public TransactionPrepareFailedException(List<TransactionPrepareFailedException> causes) {
        this.versionConflicts = new LongKeyHashMap<SerializedObject>();
        this.messages = new ArrayList<String>();
        for (TransactionPrepareFailedException exc : causes) {
            if (exc.versionConflicts != null) {
                this.versionConflicts.putAll(exc.versionConflicts);
            }
            if (exc.messages == null) continue;
            this.messages.addAll(exc.messages);
        }
    }

    public TransactionPrepareFailedException(LongKeyMap<SerializedObject> versionConflicts, String message) {
        this.versionConflicts = versionConflicts;
        this.messages = Collections.singletonList(message);
    }

    public TransactionPrepareFailedException(String message) {
        this(null, message);
    }

    @Override
    public String getMessage() {
        String result = "Transaction failed to prepare.";
        if (this.messages != null) {
            for (String m : this.messages) {
                result = result + System.getProperty("line.separator") + "    " + m;
            }
        }
        return result;
    }
}

