/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker;

import fabric.common.Crypto;
import fabric.common.ONumConstants;
import fabric.common.ObjectGroup;
import fabric.common.SerializedObject;
import fabric.common.Surrogate;
import fabric.common.TransactionID;
import fabric.common.exceptions.FetchException;
import fabric.common.exceptions.InternalError;
import fabric.common.net.naming.SocketAddress;
import fabric.common.util.LongHashSet;
import fabric.common.util.LongIterator;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.dissemination.Glob;
import fabric.lang.Object;
import fabric.lang.security.NodePrincipal;
import fabric.messages.AbortTransactionMessage;
import fabric.messages.AllocateMessage;
import fabric.messages.CommitTransactionMessage;
import fabric.messages.DissemReadMessage;
import fabric.messages.GetCertificateChainMessage;
import fabric.messages.PrepareTransactionMessage;
import fabric.messages.ReadMessage;
import fabric.messages.StalenessCheckMessage;
import fabric.messages.UnauthenticatedAbortTransactionMessage;
import fabric.messages.UnauthenticatedCommitTransactionMessage;
import fabric.messages.UnauthenticatedPrepareTransactionMessage;
import fabric.net.RemoteNode;
import fabric.net.UnreachableNodeException;
import fabric.util.Map;
import fabric.worker.FabricSoftRef;
import fabric.worker.SerializedObjectSoftRef;
import fabric.worker.Store;
import fabric.worker.TransactionCommitFailedException;
import fabric.worker.TransactionPrepareFailedException;
import fabric.worker.Worker;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class RemoteStore
extends RemoteNode
implements Store {
    private final transient Queue<Long> fresh_ids;
    private final transient LongKeyMap<FabricSoftRef> objects = new LongKeyHashMap<FabricSoftRef>();
    private final transient LongKeyMap<FetchLock> fetchLocks = new LongKeyHashMap<FetchLock>();
    private transient PublicKey publicKey = null;
    private final transient LongKeyMap<SerializedObjectSoftRef> serialized;
    final transient ReferenceQueue<SerializedObject> serializedRefQueue;
    private final transient SerializedCollector collector;

    protected RemoteStore(String name) {
        super(name, true);
        this.fresh_ids = new LinkedList<Long>();
        this.serialized = new LongKeyHashMap<SerializedObjectSoftRef>();
        this.serializedRefQueue = new ReferenceQueue();
        this.collector = new SerializedCollector();
        this.collector.start();
    }

    protected RemoteStore(String name, PublicKey key) {
        this(name);
        this.publicKey = key;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.collector.destroyed = true;
        this.collector.interrupt();
    }

    @Override
    public synchronized long createOnum() throws UnreachableNodeException {
        this.reserve(1);
        return this.fresh_ids.poll();
    }

    @Override
    public boolean prepareTransaction(boolean useAuthentication, long tid, long commitTime, Collection<Object._Impl> toCreate, LongKeyMap<Integer> reads, Collection<Object._Impl> writes) throws TransactionPrepareFailedException, UnreachableNodeException {
        if (useAuthentication) {
            PrepareTransactionMessage.Response response = new PrepareTransactionMessage(tid, commitTime, toCreate, reads, writes).send(this);
            return response.subTransactionCreated;
        }
        UnauthenticatedPrepareTransactionMessage.Response response = new UnauthenticatedPrepareTransactionMessage(tid, commitTime, toCreate, reads, writes).send(this);
        if (!response.success) {
            throw new TransactionPrepareFailedException(response.versionConflicts, response.message);
        }
        return response.subTransactionCreated;
    }

    @Override
    public final Object._Impl readObject(long onum) throws FetchException {
        return this.readObject(true, onum);
    }

    @Override
    public final Object._Impl readObjectNoDissem(long onum) throws FetchException {
        return this.readObject(false, onum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object._Impl readObject(boolean useDissem, long onum) throws FetchException {
        FetchLock fetchLock;
        if (ONumConstants.isGlobalConstant(onum)) {
            return Worker.instance.localStore.readObject(onum);
        }
        boolean needToFetch = false;
        Object object = this.fetchLocks;
        synchronized (object) {
            Object._Impl result = this.readObjectFromCache(onum);
            if (result != null) {
                return result;
            }
            fetchLock = this.fetchLocks.get(onum);
            if (fetchLock == null) {
                needToFetch = true;
                fetchLock = new FetchLock();
                this.fetchLocks.put(onum, fetchLock);
            }
        }
        object = fetchLock;
        synchronized (object) {
            if (needToFetch) {
                try {
                    fetchLock.object = this.fetchObject(useDissem, onum);
                }
                catch (FetchException e) {
                    fetchLock.error = e;
                }
                LongKeyMap<FetchLock> e = this.fetchLocks;
                synchronized (e) {
                    this.fetchLocks.remove(onum);
                }
                fetchLock.notifyAll();
            } else {
                while (fetchLock.object == null && fetchLock.error == null) {
                    try {
                        fetchLock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (fetchLock.error != null) {
                throw fetchLock.error;
            }
            return fetchLock.object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object._Impl readObjectFromCache(long onum) {
        LongKeyMap<FabricSoftRef> longKeyMap = this.objects;
        synchronized (longKeyMap) {
            FabricSoftRef ref = this.objects.get(onum);
            if (ref == null) {
                return null;
            }
            return (Object._Impl)ref.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object._Impl fetchObject(boolean useDissem, long onum) throws FetchException {
        SerializedObject serial;
        SoftReference serialRef;
        Object._Impl result = null;
        LongKeyMap<SoftReference> longKeyMap = this.serialized;
        synchronized (longKeyMap) {
            serialRef = this.serialized.remove(onum);
        }
        if (serialRef != null && (serial = (SerializedObject)serialRef.get()) != null) {
            result = serial.deserialize(this);
        }
        if (result == null) {
            ObjectGroup g = useDissem ? Worker.getWorker().fetchManager().fetch(this, onum) : this.readObjectFromStore(onum);
            LongKeyMap<SerializedObjectSoftRef> longKeyMap2 = this.serialized;
            synchronized (longKeyMap2) {
                for (LongKeyMap.Entry<SerializedObject> entry : g.objects().entrySet()) {
                    long curOnum = entry.getKey();
                    SerializedObject curObj = entry.getValue();
                    if (curOnum == onum) {
                        result = curObj.deserialize(this);
                        continue;
                    }
                    this.serialized.put(entry.getKey(), new SerializedObjectSoftRef(this, entry.getValue()));
                }
            }
        }
        while (result instanceof Surrogate) {
            Surrogate surrogate = (Surrogate)result;
            if (useDissem) {
                result = surrogate.store.readObject(surrogate.onum);
                continue;
            }
            result = surrogate.store.readObjectNoDissem(surrogate.onum);
        }
        longKeyMap = this.objects;
        synchronized (longKeyMap) {
            this.objects.put(onum, result.$ref);
        }
        return result;
    }

    public ObjectGroup readObjectFromStore(long onum) throws FetchException {
        ReadMessage.Response response = new ReadMessage(onum).send(this);
        return response.group;
    }

    public final Glob readEncryptedObjectFromStore(long onum) throws FetchException {
        DissemReadMessage.Response response = new DissemReadMessage(onum).send(this);
        return response.glob;
    }

    public Object readResolve() {
        return Worker.getWorker().getStore(this.name);
    }

    protected void reserve(int num) throws UnreachableNodeException {
        while (this.fresh_ids.size() < num) {
            if (num < 512) {
                num = 512;
            }
            AllocateMessage.Response response = new AllocateMessage(num).send(this);
            for (long oid : response.oids) {
                this.fresh_ids.add(oid);
            }
        }
    }

    @Override
    public void abortTransaction(boolean useAuthentication, TransactionID tid) {
        if (useAuthentication) {
            new AbortTransactionMessage(tid).send(this);
        } else {
            new UnauthenticatedAbortTransactionMessage(tid).send(this);
        }
    }

    @Override
    public void commitTransaction(boolean useAuthentication, long transactionID) throws UnreachableNodeException, TransactionCommitFailedException {
        if (useAuthentication) {
            CommitTransactionMessage.Response response = new CommitTransactionMessage(transactionID).send(this);
            if (!response.success) {
                throw new TransactionCommitFailedException(response.message);
            }
        } else {
            UnauthenticatedCommitTransactionMessage.Response response = new UnauthenticatedCommitTransactionMessage(transactionID).send(this);
            if (!response.success) {
                throw new TransactionCommitFailedException(response.message);
            }
        }
    }

    @Override
    public boolean checkForStaleObjects(LongKeyMap<Integer> reads) {
        List<SerializedObject> staleObjects = this.getStaleObjects(reads);
        for (SerializedObject obj : staleObjects) {
            this.updateCache(obj);
        }
        return !staleObjects.isEmpty();
    }

    protected List<SerializedObject> getStaleObjects(LongKeyMap<Integer> reads) {
        return new StalenessCheckMessage(reads).send((RemoteNode)this).staleObjects;
    }

    public String toString() {
        return "Store@" + this.name;
    }

    @Override
    public Map getRoot() {
        return new Map._Proxy((Store)this, 0L);
    }

    @Override
    public NodePrincipal getPrincipal() {
        return new NodePrincipal._Proxy((Store)this, 1L);
    }

    @Override
    public final boolean isLocalStore() {
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notifyEvict(long onum) {
        LongKeyMap<FabricSoftRef> longKeyMap = this.objects;
        synchronized (longKeyMap) {
            FabricSoftRef r = this.objects.get(onum);
            if (r != null && r.get() == null) {
                this.objects.remove(onum);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean evict(long onum) {
        LongKeyMap<FabricSoftRef> longKeyMap = this.objects;
        synchronized (longKeyMap) {
            FabricSoftRef r = this.objects.get(onum);
            if (r == null) {
                return false;
            }
            return r.evict();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCache(SerializedObject update) {
        long onum = update.getOnum();
        LongKeyMap<FabricSoftRef> longKeyMap = this.objects;
        synchronized (longKeyMap) {
            LongKeyMap<SerializedObjectSoftRef> longKeyMap2 = this.serialized;
            synchronized (longKeyMap2) {
                boolean evicted = this.evict(onum);
                if (evicted || this.serialized.containsKey(onum)) {
                    this.serialized.put(onum, new SerializedObjectSoftRef(this, update));
                }
                return evicted;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(Object._Impl impl) {
        FabricSoftRef ref = impl.$ref;
        if (ref.store != this) {
            throw new InternalError("Caching object at wrong store");
        }
        LongKeyMap<FabricSoftRef> longKeyMap = this.objects;
        synchronized (longKeyMap) {
            if (this.objects.get(ref.onum) != null) {
                throw new InternalError("Conflicting cache entry");
            }
            this.objects.put(ref.onum, ref);
        }
    }

    public PublicKey getPublicKey() {
        if (this.publicKey == null) {
            GetCertificateChainMessage.Response response = new GetCertificateChainMessage().send(this);
            Certificate[] certificateChain = response.certificateChain;
            if (Crypto.validateCertificateChain(certificateChain, Worker.instance.keyStore)) {
                this.publicKey = certificateChain[0].getPublicKey();
            }
        }
        return this.publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        LongKeyMap<FabricSoftRef> longKeyMap = this.objects;
        synchronized (longKeyMap) {
            LongKeyMap<SerializedObjectSoftRef> longKeyMap2 = this.serialized;
            synchronized (longKeyMap2) {
                LongHashSet onums = new LongHashSet(this.objects.keySet());
                LongIterator it = onums.iterator();
                while (it.hasNext()) {
                    this.evict(it.next());
                }
                this.serialized.clear();
            }
        }
    }

    @Override
    protected SocketAddress lookup() throws IOException {
        return Worker.getWorker().storeNameService.resolve(this.name);
    }

    private class FetchLock {
        private Object._Impl object;
        private FetchException error;

        private FetchLock() {
        }
    }

    private class SerializedCollector
    extends Thread {
        private final ReferenceQueue<SerializedObject> queue;
        private boolean destroyed;

        SerializedCollector() {
            super("Serialized object collector for store " + RemoteStore.this.name);
            this.queue = new ReferenceQueue();
            this.destroyed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.destroyed) {
                try {
                    SerializedObjectSoftRef ref = (SerializedObjectSoftRef)this.queue.remove();
                    LongKeyMap longKeyMap = RemoteStore.this.serialized;
                    synchronized (longKeyMap) {
                        RemoteStore.this.serialized.remove(ref.onum);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

