/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker;

import fabric.common.FabricThread;
import fabric.worker.Options;
import fabric.worker.transaction.TransactionManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.ListIterator;

public final class MainThread
extends Thread
implements FabricThread {
    private TransactionManager tm = null;
    private final Options opts;
    private final Method main;
    private final Object args;
    private Throwable uncaughtException;

    private MainThread(Options opts, Method main, Object args) {
        super("Main worker application");
        this.opts = opts;
        this.main = main;
        this.args = args;
        this.uncaughtException = null;
        this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                MainThread.this.uncaughtException = e;
            }
        });
    }

    @Override
    public void run() {
        try {
            this.main.invoke(null, this.args);
        }
        catch (InvocationTargetException e) {
            StackTraceElement elt;
            Throwable cause = e.getCause();
            ArrayList<StackTraceElement> trace = new ArrayList<StackTraceElement>();
            for (StackTraceElement elt2 : cause.getStackTrace()) {
                trace.add(elt2);
            }
            ListIterator it = trace.listIterator(trace.size());
            while (it.hasPrevious() && !(elt = (StackTraceElement)it.previous()).getClassName().equals(this.opts.app[0] + "$_Impl")) {
                it.remove();
            }
            StackTraceElement[] traceArray = new StackTraceElement[trace.size()];
            cause.setStackTrace(trace.toArray(traceArray));
            this.uncaughtException = cause;
        }
        catch (Throwable t) {
            this.uncaughtException = t;
        }
    }

    public static void invoke(Options opts, Method main, Object args) throws Throwable {
        MainThread thread = new MainThread(opts, main, args);
        thread.start();
        while (true) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
        Throwable uncaught = thread.uncaughtException;
        if (uncaught != null) {
            throw uncaught;
        }
    }

    @Override
    public final TransactionManager getTransactionManager() {
        return this.tm;
    }

    @Override
    public final void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }
}

