/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker;

import fabric.common.Logging;
import fabric.common.ONumConstants;
import fabric.common.TransactionID;
import fabric.common.exceptions.InternalError;
import fabric.common.util.LongKeyMap;
import fabric.common.util.Pair;
import fabric.lang.Object;
import fabric.lang.security.ConfPolicy;
import fabric.lang.security.IntegPolicy;
import fabric.lang.security.Label;
import fabric.lang.security.LabelUtil;
import fabric.lang.security.NodePrincipal;
import fabric.lang.security.Principal;
import fabric.lang.security.PrincipalUtil;
import fabric.util.HashMap;
import fabric.util.Map;
import fabric.worker.Store;
import fabric.worker.Worker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class LocalStore
implements Store {
    private long freshOID = 2L;
    private Map rootMap;
    private Principal topPrincipal;
    private ConfPolicy topConfidPolicy;
    private ConfPolicy bottomConfidPolicy;
    private IntegPolicy topIntegPolicy;
    private IntegPolicy bottomIntegPolicy;
    private Label emptyLabel;
    private Label publicReadonlyLabel;
    private Set<Pair<Principal, Principal>> localDelegates;

    @Override
    public synchronized boolean prepareTransaction(boolean useAuthentication, long tid, long commitTime, Collection<Object._Impl> toCreate, LongKeyMap<Integer> reads, Collection<Object._Impl> writes) {
        Logging.WORKER_LOCAL_STORE_LOGGER.fine("Local transaction preparing");
        return false;
    }

    @Override
    public synchronized void abortTransaction(boolean useAuthentication, TransactionID tid) {
        Logging.WORKER_LOCAL_STORE_LOGGER.fine("Local transaction aborting");
    }

    @Override
    public synchronized void commitTransaction(boolean useAuthentication, long transactionID) {
        Logging.WORKER_LOCAL_STORE_LOGGER.fine("Local transaction committing");
    }

    @Override
    public synchronized long createOnum() {
        return this.freshOID++;
    }

    @Override
    public synchronized Object._Impl readObject(long onum) {
        return this.readObjectNoDissem(onum);
    }

    @Override
    public synchronized Object._Impl readObjectNoDissem(long onum) {
        if (!ONumConstants.isGlobalConstant(onum)) {
            throw new InternalError("Not supported.");
        }
        if (Integer.MIN_VALUE <= onum && onum <= Integer.MAX_VALUE) {
            switch ((int)onum) {
                case -1: {
                    return (Object._Impl)this.topPrincipal.fetch();
                }
                case -2: {
                    return (Object._Impl)this.topConfidPolicy.fetch();
                }
                case -3: {
                    return (Object._Impl)this.bottomConfidPolicy.fetch();
                }
                case -4: {
                    return (Object._Impl)this.topIntegPolicy.fetch();
                }
                case -5: {
                    return (Object._Impl)this.bottomIntegPolicy.fetch();
                }
                case -6: {
                    return (Object._Impl)this.emptyLabel.fetch();
                }
                case -7: {
                    return (Object._Impl)this.publicReadonlyLabel.fetch();
                }
            }
        }
        throw new InternalError("Unknown global constant: onum " + onum);
    }

    @Override
    public Object._Impl readObjectFromCache(long onum) {
        return this.readObject(onum);
    }

    @Override
    public boolean checkForStaleObjects(LongKeyMap<Integer> reads) {
        return false;
    }

    protected LocalStore() {
    }

    public String toString() {
        return "LocalStore";
    }

    @Override
    public Map getRoot() {
        return this.rootMap;
    }

    public void addLocalDelegation(Principal p, Principal q) {
        this.localDelegates.add(new Pair<Principal, Principal>(p, q));
    }

    public void removeLocalDelegation(Principal p, Principal q) {
        this.localDelegates.remove(new Pair<Principal, Principal>(p, q));
    }

    public boolean localDelegatesTo(Principal p, Principal q) {
        return this.localDelegates.contains(new Pair<Principal, Principal>(p, q));
    }

    public Principal getTopPrincipal() {
        return this.topPrincipal;
    }

    public ConfPolicy getTopConfidPolicy() {
        return this.topConfidPolicy;
    }

    public ConfPolicy getBottomConfidPolicy() {
        return this.bottomConfidPolicy;
    }

    public IntegPolicy getTopIntegPolicy() {
        return this.topIntegPolicy;
    }

    public IntegPolicy getBottomIntegPolicy() {
        return this.bottomIntegPolicy;
    }

    public Label getEmptyLabel() {
        return this.emptyLabel;
    }

    public Label getPublicReadonlyLabel() {
        return this.publicReadonlyLabel;
    }

    @Override
    public String name() {
        return "local";
    }

    @Override
    public NodePrincipal getPrincipal() {
        return Worker.getWorker().getPrincipal();
    }

    @Override
    public boolean isLocalStore() {
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public boolean notifyEvict(long onum) {
        return false;
    }

    @Override
    public boolean evict(long onum) {
        return false;
    }

    @Override
    public void cache(Object._Impl impl) {
    }

    public void initialize() {
        this.emptyLabel = new Label._Proxy((Store)this, -6L);
        this.publicReadonlyLabel = new Label._Proxy((Store)this, -7L);
        Worker.runInSubTransaction(new Worker.Code<Void>(){

            @Override
            public Void run() {
                LocalStore.this.topPrincipal = (Principal)((Object)new PrincipalUtil.TopPrincipal._Impl((Store)LocalStore.this, LocalStore.this.publicReadonlyLabel).$getProxy());
                LocalStore.this.topPrincipal.$forceRenumber(-1L);
                LocalStore.this.bottomConfidPolicy = LabelUtil._Impl.readerPolicy((Store)LocalStore.this, null, (Principal)null);
                LocalStore.this.bottomConfidPolicy.$forceRenumber(-3L);
                LocalStore.this.bottomIntegPolicy = LabelUtil._Impl.writerPolicy((Store)LocalStore.this, (Principal)LocalStore.this.topPrincipal, (Principal)LocalStore.this.topPrincipal);
                LocalStore.this.bottomIntegPolicy.$forceRenumber(-5L);
                LocalStore.this.publicReadonlyLabel = LabelUtil._Impl.toLabel((Store)LocalStore.this, (ConfPolicy)LocalStore.this.bottomConfidPolicy, (IntegPolicy)LocalStore.this.bottomIntegPolicy);
                LocalStore.this.publicReadonlyLabel.$forceRenumber(-7L);
                LocalStore.this.topConfidPolicy = LabelUtil._Impl.readerPolicy((Store)LocalStore.this, (Principal)LocalStore.this.topPrincipal, (Principal)LocalStore.this.topPrincipal);
                LocalStore.this.topConfidPolicy.$forceRenumber(-2L);
                LocalStore.this.topIntegPolicy = LabelUtil._Impl.writerPolicy((Store)LocalStore.this, null, (Principal)null);
                LocalStore.this.topIntegPolicy.$forceRenumber(-4L);
                LocalStore.this.emptyLabel = LabelUtil._Impl.toLabel((Store)LocalStore.this, (ConfPolicy)LocalStore.this.bottomConfidPolicy, (IntegPolicy)LocalStore.this.topIntegPolicy);
                LocalStore.this.emptyLabel.$forceRenumber(-6L);
                NodePrincipal workerPrincipal = Worker.getWorker().getPrincipal();
                ConfPolicy conf = LabelUtil._Impl.readerPolicy((Store)LocalStore.this, (Principal)workerPrincipal, (Principal)null);
                IntegPolicy integ = LabelUtil._Impl.writerPolicy((Store)LocalStore.this, (Principal)workerPrincipal, (Principal)null);
                Label label = LabelUtil._Impl.toLabel((Store)LocalStore.this, (ConfPolicy)conf, (IntegPolicy)integ);
                LocalStore.this.rootMap = (Map)new HashMap._Impl((Store)LocalStore.this, label).$getProxy();
                LocalStore.this.localDelegates = new HashSet();
                return null;
            }
        });
    }
}

