/*
 * Decompiled with CFR 0.152.
 */
package fabric.worker;

import fabric.lang.Object;
import fabric.worker.LocalStore;
import fabric.worker.Store;
import fabric.worker.transaction.ReadMapEntry;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class FabricSoftRef
extends SoftReference<Object._Impl> {
    private static final ReferenceQueue<Object._Impl> queue = new ReferenceQueue();
    private static final RefCollector collector = new RefCollector();
    public Store store;
    public long onum;
    public ReadMapEntry readMapEntry;

    public static void destroy() {
        collector.destroy();
    }

    public FabricSoftRef(Store store, long onum, Object._Impl impl) {
        super(impl, queue);
        this.store = store;
        this.onum = onum;
    }

    public boolean evict() {
        if (this.store instanceof LocalStore) {
            throw new InternalError("evicting local store object");
        }
        this.clear();
        boolean result = this.store.notifyEvict(this.onum);
        if (this.readMapEntry != null && this.readMapEntry.depin()) {
            this.readMapEntry = null;
        }
        return result;
    }

    public void readMapEntry(ReadMapEntry readMapEntry) {
        this.readMapEntry = readMapEntry;
    }

    static {
        collector.start();
    }

    private static class RefCollector
    extends Thread {
        private boolean destroyed;

        RefCollector() {
            super("Reference collector");
        }

        public void destroy() {
            this.destroyed = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.destroyed) {
                try {
                    FabricSoftRef ref = (FabricSoftRef)queue.remove();
                    ref.store.notifyEvict(ref.onum);
                    if (!ref.readMapEntry.depin()) continue;
                    ref.readMapEntry = null;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

