/*
 * Decompiled with CFR 0.152.
 */
package fabric.visit;

import fabric.ast.FabricNodeFactory;
import fabric.types.FabricClassType;
import fabric.types.FabricDynamicPrincipal_c;
import fabric.types.FabricTypeSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jif.types.JifTypeSystem;
import jif.types.LabeledType;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathThis;
import jif.types.label.ConfPolicy;
import jif.types.label.ConfProjectionPolicy_c;
import jif.types.label.IntegPolicy;
import jif.types.label.JoinConfPolicy_c;
import jif.types.label.JoinIntegPolicy_c;
import jif.types.label.Label;
import jif.types.label.MeetConfPolicy_c;
import jif.types.label.PairLabel;
import jif.types.label.ReaderPolicy;
import jif.types.label.WriterPolicy;
import jif.types.principal.ConjunctivePrincipal;
import jif.types.principal.DisjunctivePrincipal;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.Principal;
import jif.types.principal.TopPrincipal;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.FieldDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.types.FieldInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ErrorHandlingVisitor;
import polyglot.visit.NodeVisitor;

public class ThisLabelChecker
extends ErrorHandlingVisitor {
    public ThisLabelChecker(Job job, FabricTypeSystem ts, FabricNodeFactory nf) {
        super(job, (TypeSystem)ts, (NodeFactory)nf);
    }

    private boolean isThisInteg(WriterPolicy p) {
        AccessPath path;
        Principal owner = p.owner();
        Principal writer = p.writer();
        return owner instanceof FabricDynamicPrincipal_c && (path = ((FabricDynamicPrincipal_c)owner).path()) instanceof AccessPathThis && writer instanceof TopPrincipal;
    }

    private boolean hasThis(ConfPolicy p) throws SemanticException {
        if (p instanceof ConfProjectionPolicy_c) {
            throw new SemanticException("No projection policies allowed here");
        }
        if (p instanceof JoinConfPolicy_c) {
            for (ConfPolicy cp : ((JoinConfPolicy_c)p).joinComponents()) {
                if (!this.hasThis(cp)) continue;
                return true;
            }
        }
        if (p instanceof MeetConfPolicy_c) {
            for (ConfPolicy cp : ((MeetConfPolicy_c)p).meetComponents()) {
                if (!this.hasThis(cp)) continue;
                return true;
            }
        }
        if (p instanceof ReaderPolicy) {
            ReaderPolicy rp = (ReaderPolicy)p;
            Principal owner = rp.owner();
            Principal reader = rp.reader();
            if (this.hasThis(owner) || this.hasThis(reader)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasThis(Principal p) {
        if (p instanceof DynamicPrincipal) {
            AccessPath path;
            return p instanceof FabricDynamicPrincipal_c && (path = ((FabricDynamicPrincipal_c)p).path()) instanceof AccessPathThis;
        }
        if (p instanceof ConjunctivePrincipal) {
            for (Principal conp : ((ConjunctivePrincipal)p).conjuncts()) {
                if (!this.hasThis(conp)) continue;
                return true;
            }
        }
        if (p instanceof DisjunctivePrincipal) {
            for (Principal disp : ((DisjunctivePrincipal)p).disjuncts()) {
                if (!this.hasThis(disp)) continue;
                return true;
            }
        }
        return false;
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            ParsedClassType pctype = cd.type();
            if (pctype instanceof FabricClassType && !pctype.isSubtype((Type)((FabricTypeSystem)this.ts).DelegatingPrincipal())) {
                return n;
            }
            List members = cd.body().members();
            ArrayList<Object> newMembers = new ArrayList<Object>();
            for (int i = 0; i < members.size(); ++i) {
                ClassMember member = (ClassMember)members.get(i);
                if (!(member instanceof FieldDecl)) {
                    newMembers.add(member);
                    continue;
                }
                FieldDecl fd = (FieldDecl)member;
                FieldInstance fi = fd.fieldInstance();
                Type type = fd.declType();
                if (type instanceof LabeledType) {
                    LabeledType ltype = (LabeledType)type;
                    Label fieldLabel = ltype.labelPart();
                    IntegPolicy ip = fieldLabel.integProjection();
                    ConfPolicy cp = fieldLabel.confProjection();
                    if (this.hasThis(cp)) {
                        throw new SemanticException("Conf policy of field cannot mention 'this'");
                    }
                    IntegPolicy newPol = null;
                    if (ip instanceof JoinIntegPolicy_c) {
                        HashSet<IntegPolicy> set = new HashSet<IntegPolicy>();
                        Iterator cit = ((JoinIntegPolicy_c)ip).joinComponents().iterator();
                        boolean thisInteg = false;
                        while (cit.hasNext()) {
                            IntegPolicy p = (IntegPolicy)cit.next();
                            if (p instanceof WriterPolicy && this.isThisInteg((WriterPolicy)p)) {
                                thisInteg = true;
                                continue;
                            }
                            set.add(p);
                        }
                        if (!thisInteg) {
                            throw new SemanticException("Integrity label is required to be of the form {this\u2190} \u2294 L");
                        }
                        newPol = new JoinIntegPolicy_c(set, (JifTypeSystem)ip.typeSystem(), ip.position());
                    }
                    if (ip instanceof WriterPolicy) {
                        if (!this.isThisInteg((WriterPolicy)ip)) {
                            throw new SemanticException("Integrity label is required to be of the form {this\u2190} \u2294 L");
                        }
                        newPol = ((FabricTypeSystem)this.ts).bottomIntegPolicy(Position.compilerGenerated());
                    }
                    if (newPol != null) {
                        FabricTypeSystem ts = (FabricTypeSystem)fieldLabel.typeSystem();
                        PairLabel newLabel = ts.pairLabel(fieldLabel.position(), cp, newPol);
                        LabeledType newType = ltype.labelPart((Label)newLabel);
                        FieldDecl newDecl = fd.type(fd.type().type((Type)newType));
                        fi.setType((Type)newType);
                        newDecl = newDecl.fieldInstance(fi);
                        newMembers.add(newDecl);
                        continue;
                    }
                    throw new SemanticException("Only join labels and simple writer policies allowed.");
                }
                throw new InternalCompilerError("Labeled Type not available");
            }
            return cd.body(cd.body().members(newMembers));
        }
        return n;
    }
}

