/*
 * Decompiled with CFR 0.152.
 */
package fabric.visit;

import fabric.ast.FabricNodeFactory;
import fabric.types.FabricParsedClassType;
import fabric.types.FabricTypeSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import jif.ast.JifMethodDecl;
import jif.ast.JifUtil;
import jif.ast.LabelExpr;
import jif.extension.JifBinaryDel;
import jif.types.ActsForConstraint;
import jif.types.Assertion;
import jif.types.CallerConstraint;
import jif.types.JifMethodInstance;
import jif.types.LabelLeAssertion;
import jif.types.label.AccessPath;
import jif.types.label.ConfPolicy;
import jif.types.label.IntegPolicy;
import jif.types.label.Label;
import jif.types.label.PairLabel;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.Principal;
import polyglot.ast.Binary;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.If;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.frontend.Job;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class RemoteCallWrapperUpdater
extends NodeVisitor {
    protected Job job;
    protected FabricTypeSystem ts;
    protected FabricNodeFactory nf;

    public RemoteCallWrapperUpdater(Job job, FabricTypeSystem ts, FabricNodeFactory nf) {
        this.job = job;
        this.ts = ts;
        this.nf = nf;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            FabricParsedClassType pct = (FabricParsedClassType)cd.type();
            if (!this.ts.isFabricClass((Type)pct)) {
                ArrayList<ClassMember> members = new ArrayList<ClassMember>();
                for (ClassMember cm : cd.body().members()) {
                    MethodDecl md;
                    if (cm instanceof MethodDecl && (md = (MethodDecl)cm).name().endsWith("_remote")) {
                        MethodInstance mi = md.methodInstance();
                        pct.removeMethod(mi);
                        continue;
                    }
                    members.add(cm);
                }
                return cd.body(cd.body().members(members));
            }
        } else if (n instanceof JifMethodDecl) {
            JifMethodDecl md = (JifMethodDecl)n;
            if (md.name().endsWith("_remote")) {
                DynamicPrincipal workerPrincipal;
                JifMethodInstance mi = (JifMethodInstance)md.methodInstance();
                FabricParsedClassType pct = (FabricParsedClassType)mi.container();
                Formal f = (Formal)md.formals().get(0);
                LocalInstance li = f.localInstance();
                try {
                    AccessPath ap = JifUtil.varInstanceToAccessPath((VarInstance)li, (Position)li.position());
                    workerPrincipal = this.ts.dynamicPrincipal(ap.position(), ap);
                }
                catch (SemanticException e) {
                    throw new InternalCompilerError((Throwable)e);
                }
                Label startLabel = mi.pcBound();
                Label returnLabel = this.ts.join(mi.returnValueLabel(), mi.returnLabel());
                if (this.ts.containsThisLabel(startLabel) || this.ts.containsThisLabel(returnLabel)) {
                    pct.removeMethod((MethodInstance)mi);
                    return null;
                }
                IntegPolicy startIntegPolicy = this.ts.representableIntegProjection(startLabel);
                Iterator it = mi.formalTypes().iterator();
                it.next();
                while (it.hasNext()) {
                    Type ft = (Type)it.next();
                    Label l = this.ts.labelOfType(ft);
                    if (this.ts.containsThisLabel(l)) {
                        pct.removeMethod((MethodInstance)mi);
                        return null;
                    }
                    IntegPolicy ip = this.ts.representableIntegProjection(l);
                    startIntegPolicy = this.ts.meet(startIntegPolicy, ip);
                }
                PairLabel left = this.ts.pairLabel(Position.compilerGenerated((String)md.position().toString()), this.ts.representableConfProjection(returnLabel), (IntegPolicy)this.ts.writerPolicy(Position.compilerGenerated(), (Principal)this.ts.topPrincipal(Position.compilerGenerated()), (Principal)workerPrincipal));
                PairLabel right = this.ts.pairLabel(Position.compilerGenerated((String)md.name()), (ConfPolicy)this.ts.readerPolicy(Position.compilerGenerated(), (Principal)this.ts.topPrincipal(Position.compilerGenerated()), (Principal)workerPrincipal), startIntegPolicy);
                LabelExpr leftExpr = this.nf.LabelExpr(left.position(), (Label)left);
                LabelExpr rightExpr = this.nf.LabelExpr(right.position(), (Label)right);
                Binary labelComp = this.nf.Binary(Position.compilerGenerated(), (Expr)leftExpr, Binary.LE, (Expr)rightExpr);
                for (Assertion as : mi.constraints()) {
                    Binary check;
                    if (as instanceof CallerConstraint) {
                        CallerConstraint cc = (CallerConstraint)as;
                        for (Principal p : cc.principals()) {
                            Binary check2 = this.nf.Binary(as.position(), (Expr)this.nf.CanonicalPrincipalNode(workerPrincipal.position(), (Principal)workerPrincipal), JifBinaryDel.ACTSFOR, (Expr)this.nf.CanonicalPrincipalNode(p.position(), p));
                            labelComp = this.nf.Binary(Position.compilerGenerated(), (Expr)labelComp, Binary.COND_AND, (Expr)check2);
                        }
                        continue;
                    }
                    if (as instanceof ActsForConstraint) {
                        ActsForConstraint afc = (ActsForConstraint)as;
                        check = this.nf.Binary(afc.position(), (Expr)this.nf.CanonicalPrincipalNode(afc.actor().position(), afc.actor()), afc.isEquiv() ? JifBinaryDel.EQUIV : JifBinaryDel.ACTSFOR, (Expr)this.nf.CanonicalPrincipalNode(afc.granter().position(), afc.granter()));
                        labelComp = this.nf.Binary(Position.compilerGenerated(), (Expr)labelComp, Binary.COND_AND, (Expr)check);
                        continue;
                    }
                    if (!(as instanceof LabelLeAssertion)) continue;
                    LabelLeAssertion lla = (LabelLeAssertion)as;
                    check = this.nf.Binary(lla.position(), (Expr)this.nf.LabelExpr(lla.lhs().position(), lla.lhs()), Binary.LE, (Expr)this.nf.LabelExpr(lla.rhs().position(), lla.rhs()));
                    labelComp = this.nf.Binary(Position.compilerGenerated(), (Expr)labelComp, Binary.COND_AND, (Expr)check);
                }
                Eval eval = (Eval)md.body().statements().get(0);
                Object conseq = mi.returnType().isVoid() ? eval : this.nf.Return(eval.position(), eval.expr());
                Stmt alter = (Stmt)md.body().statements().get(1);
                If s = this.nf.If(Position.compilerGenerated(), (Expr)labelComp, (Stmt)conseq, alter);
                md = (JifMethodDecl)md.body(md.body().statements(Collections.singletonList(s)));
            }
            return md;
        }
        return n;
    }
}

