/*
 * Decompiled with CFR 0.152.
 */
package fabric.visit;

import fabil.FabILOptions;
import fabil.ast.FabILNodeFactory;
import fabil.types.FabILTypeSystem;
import fabric.ast.FabricNodeFactory;
import fabric.types.FabricTypeSystem;
import java.util.ArrayList;
import jif.ast.JifNodeFactory;
import jif.translate.JifToJavaRewriter;
import jif.types.JifTypeSystem;
import jif.types.Param;
import jif.types.label.Label;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.TypeNode;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;

public class FabricToFabilRewriter
extends JifToJavaRewriter {
    protected boolean principalExpected = false;

    public FabricToFabilRewriter(Job job, FabricTypeSystem fab_ts, FabricNodeFactory fab_nf, fabil.ExtensionInfo fabil_ext) {
        super(job, (JifTypeSystem)fab_ts, (JifNodeFactory)fab_nf, (ExtensionInfo)fabil_ext);
    }

    public String runtimeLabelUtil() {
        return this.jif_ts().LabelUtilClassName();
    }

    public TypeNode typeToJava(Type t, Position pos) throws SemanticException {
        FabILNodeFactory fabil_nf = (FabILNodeFactory)this.java_nf();
        FabILTypeSystem fabil_ts = (FabILTypeSystem)this.java_ts();
        FabricTypeSystem fabric_ts = (FabricTypeSystem)this.jif_ts();
        if (fabric_ts.typeEquals(t, (Type)fabric_ts.Worker())) {
            return this.canonical(fabil_nf, (Type)fabil_ts.Worker(), pos);
        }
        if (fabric_ts.typeEquals(t, (Type)fabric_ts.RemoteWorker())) {
            return this.canonical(fabil_nf, (Type)fabil_ts.RemoteWorker(), pos);
        }
        if (fabric_ts.isFabricArray(t)) {
            return fabil_nf.FabricArrayTypeNode(pos, this.typeToJava(t.toArray().base(), pos));
        }
        return super.typeToJava(t, pos);
    }

    public boolean inSignatureMode() {
        FabILOptions opts = (FabILOptions)((fabil.ExtensionInfo)this.java_ext).getOptions();
        return opts.signatureMode();
    }

    public Expr updateLabelLocation(Expr labelExpr, Expr locExpr) {
        if (labelExpr instanceof Call && locExpr != null) {
            Call c = (Call)labelExpr;
            if (c.name().equals("getPrincipal") && c.arguments().size() == 0) {
                return c;
            }
            ArrayList<Expr> args = new ArrayList<Expr>(c.arguments().size() + 1);
            args.add(locExpr);
            for (Expr expr : c.arguments()) {
                if (expr instanceof Call) {
                    args.add(this.updateLabelLocation(expr, locExpr));
                    continue;
                }
                args.add(expr);
            }
            c = (Call)c.arguments(args);
            return c;
        }
        return labelExpr;
    }

    public Expr paramToJava(Param param, Expr locExpr) throws SemanticException {
        if (param instanceof Label) {
            Expr labelExpr = this.labelToJava((Label)param);
            return this.updateLabelLocation(labelExpr, locExpr);
        }
        return super.paramToJava(param);
    }
}

