/*
 * Decompiled with CFR 0.152.
 */
package fabric.translate;

import fabric.types.FabricTypeSystem;
import jif.translate.JifToJavaRewriter;
import jif.translate.PairLabelToJavaExpr_c;
import jif.types.label.ConfProjectionPolicy_c;
import jif.types.label.IntegProjectionPolicy_c;
import jif.types.label.JoinPolicy_c;
import jif.types.label.Label;
import jif.types.label.MeetPolicy_c;
import jif.types.label.PairLabel;
import jif.types.label.Policy;
import polyglot.ast.Expr;
import polyglot.types.SemanticException;
import polyglot.util.Position;

public class FabricPairLabelToFabilExpr_c
extends PairLabelToJavaExpr_c {
    public Expr toJava(Label label, JifToJavaRewriter rw) throws SemanticException {
        PairLabel pl = (PairLabel)label;
        if (pl.confPolicy().isBottomConfidentiality() && pl.integPolicy().isTopIntegrity()) {
            return rw.qq().parseExpr(rw.runtimeLabelUtil() + ".noComponents()");
        }
        Expr cexp = this.policyToJava((Policy)pl.confPolicy(), rw);
        Expr iexp = this.policyToJava((Policy)pl.integPolicy(), rw);
        if (this.containsProjection((Policy)pl.confPolicy()) || this.containsProjection((Policy)pl.integPolicy())) {
            if (!this.containsProjection((Policy)pl.confPolicy())) {
                cexp = rw.qq().parseExpr(rw.runtimeLabelUtil() + ".liftToLabel(%E)", (Object)cexp);
            }
            if (!this.containsProjection((Policy)pl.integPolicy())) {
                iexp = rw.qq().parseExpr(rw.runtimeLabelUtil() + ".liftToLabel(%E)", (Object)iexp);
            }
            return rw.qq().parseExpr(rw.runtimeLabelUtil() + ".join(%E, %E)", (Object)cexp, (Object)iexp);
        }
        return rw.qq().parseExpr(rw.runtimeLabelUtil() + ".toLabel(%E, %E)", (Object)cexp, (Object)iexp);
    }

    protected boolean containsProjection(Policy p) {
        block5: {
            block4: {
                if (p instanceof ConfProjectionPolicy_c) {
                    return true;
                }
                if (p instanceof IntegProjectionPolicy_c) {
                    return true;
                }
                if (!(p instanceof JoinPolicy_c)) break block4;
                JoinPolicy_c jp = (JoinPolicy_c)p;
                for (Policy tp : jp.joinComponents()) {
                    if (!this.containsProjection(tp)) continue;
                    return true;
                }
                break block5;
            }
            if (!(p instanceof MeetPolicy_c)) break block5;
            MeetPolicy_c mp = (MeetPolicy_c)p;
            for (Policy tp : mp.meetComponents()) {
                if (!this.containsProjection(tp)) continue;
                return true;
            }
        }
        return false;
    }

    public Expr policyToJava(Policy p, JifToJavaRewriter rw) throws SemanticException {
        FabricTypeSystem ts = (FabricTypeSystem)rw.jif_ts();
        if (p instanceof IntegProjectionPolicy_c) {
            IntegProjectionPolicy_c ipp = (IntegProjectionPolicy_c)p;
            Label l = ts.meet(ipp.label(), (Label)ts.pairLabel(Position.compilerGenerated(), ts.bottomConfPolicy(Position.compilerGenerated()), ts.topIntegPolicy(Position.compilerGenerated())));
            return l.toJava(rw);
        }
        if (p instanceof ConfProjectionPolicy_c) {
            ConfProjectionPolicy_c cpp = (ConfProjectionPolicy_c)p;
            Label l = ts.meet(cpp.label(), (Label)ts.pairLabel(Position.compilerGenerated(), ts.topConfPolicy(Position.compilerGenerated()), ts.bottomIntegPolicy(Position.compilerGenerated())));
            return l.toJava(rw);
        }
        if (p instanceof JoinPolicy_c) {
            if (this.containsProjection(p)) {
                JoinPolicy_c jp = (JoinPolicy_c)p;
                Expr result = null;
                for (Policy tp : jp.joinComponents()) {
                    Expr ep = this.policyToJava(tp, rw);
                    if (!this.containsProjection(tp)) {
                        ep = rw.qq().parseExpr(rw.runtimeLabelUtil() + ".toLabel(%E)", (Object)ep);
                    }
                    if (result == null) {
                        result = ep;
                        continue;
                    }
                    result = rw.qq().parseExpr(rw.runtimeLabelUtil() + ".join(%E, %E)", (Object)result, (Object)ep);
                }
                return result;
            }
        } else if (p instanceof MeetPolicy_c && this.containsProjection(p)) {
            MeetPolicy_c mp = (MeetPolicy_c)p;
            Expr result = null;
            for (Policy tp : mp.meetComponents()) {
                Expr ep = this.policyToJava(tp, rw);
                if (!this.containsProjection(tp)) {
                    ep = rw.qq().parseExpr(rw.runtimeLabelUtil() + ".toLabel(%E)", (Object)ep);
                }
                if (result == null) {
                    result = ep;
                    continue;
                }
                result = rw.qq().parseExpr(rw.runtimeLabelUtil() + ".meet(%E, %E)", (Object)result, (Object)ep);
            }
            return result;
        }
        return super.policyToJava(p, rw);
    }
}

