/*
 * Decompiled with CFR 0.152.
 */
package fabric.store.db;

import fabric.common.FastSerializable;
import fabric.common.SerializedObject;
import fabric.common.exceptions.AccessException;
import fabric.common.util.LongIterator;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.common.util.LongSet;
import fabric.common.util.MutableInteger;
import fabric.common.util.OidKeyHashMap;
import fabric.common.util.Pair;
import fabric.lang.Object;
import fabric.lang.security.ConfPolicy;
import fabric.lang.security.IntegPolicy;
import fabric.lang.security.Label;
import fabric.lang.security.NodePrincipal;
import fabric.lang.security.PairLabel;
import fabric.lang.security.Principal;
import fabric.lang.security.ReaderPolicy;
import fabric.lang.security.WriterPolicy;
import fabric.store.SubscriptionManager;
import fabric.store.db.GroupContainer;
import fabric.store.db.GroupContainerTable;
import fabric.util.HashMap;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import fabric.worker.remote.RemoteWorker;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;

public abstract class ObjectDB {
    protected final String name;
    private NodePrincipal storePrincipal;
    private Label publicReadonlyLabel;
    private long nextGlobID;
    private final LongKeyMap<Long> globIDByOnum;
    private final GroupContainerTable globTable;
    protected final LongKeyMap<OidKeyHashMap<PendingTransaction>> pendingByTid;
    protected final LongKeyMap<Pair<Long, LongKeyMap<MutableInteger>>> rwLocks;

    protected ObjectDB(String name) {
        this.name = name;
        this.pendingByTid = new LongKeyHashMap<OidKeyHashMap<PendingTransaction>>();
        this.rwLocks = new LongKeyHashMap<Pair<Long, LongKeyMap<MutableInteger>>>();
        this.globIDByOnum = new LongKeyHashMap<Long>();
        this.globTable = new GroupContainerTable();
        this.nextGlobID = 0L;
    }

    public final void beginTransaction(long tid, NodePrincipal worker) throws AccessException {
        OidKeyHashMap<PendingTransaction> submap = this.pendingByTid.get(tid);
        if (submap == null) {
            submap = new OidKeyHashMap();
            this.pendingByTid.put(tid, submap);
        }
        submap.put((Object)worker, new PendingTransaction(tid, worker));
    }

    public final void registerRead(long tid, NodePrincipal worker, long onum) {
        this.addReadLock(onum, tid);
        this.pendingByTid.get((long)tid).get((Object)worker).reads.add(onum);
    }

    public final void registerUpdate(long tid, NodePrincipal worker, SerializedObject obj) {
        this.addWriteLock(obj.getOnum(), tid);
        this.pendingByTid.get((long)tid).get((Object)worker).modData.add(obj);
    }

    private void addReadLock(long onum, long tid) {
        MutableInteger pinCount;
        Pair<Long, LongKeyMap<MutableInteger>> locks = this.rwLocks.get(onum);
        if (locks == null) {
            locks = new Pair(null, new LongKeyHashMap());
            this.rwLocks.put(onum, locks);
        }
        if ((pinCount = (MutableInteger)((LongKeyMap)locks.second).get(tid)) == null) {
            pinCount = new MutableInteger(0);
            ((LongKeyMap)locks.second).put(tid, pinCount);
        }
        ++pinCount.value;
    }

    private void addWriteLock(long onum, long tid) {
        Pair<Long, LongKeyMap<MutableInteger>> locks = this.rwLocks.get(onum);
        if (locks == null) {
            locks = new Pair(null, new LongKeyHashMap());
            this.rwLocks.put(onum, locks);
        }
        locks.first = tid;
    }

    public final void abortPrepare(long tid, NodePrincipal worker) {
        OidKeyHashMap<PendingTransaction> submap = this.pendingByTid.get(tid);
        this.unpin(submap.remove((Object)worker));
        if (submap.isEmpty()) {
            this.pendingByTid.remove(tid);
        }
    }

    public abstract void finishPrepare(long var1, NodePrincipal var3);

    public abstract void commit(long var1, RemoteWorker var3, NodePrincipal var4, SubscriptionManager var5) throws AccessException;

    public abstract void rollback(long var1, NodePrincipal var3) throws AccessException;

    public abstract SerializedObject read(long var1);

    public int getVersion(long onum) throws AccessException {
        SerializedObject obj = this.read(onum);
        if (obj == null) {
            throw new AccessException(this.name, onum);
        }
        return this.read(onum).getVersion();
    }

    public final GroupContainer getCachedGroupContainer(long onum) {
        Long globID = this.globIDByOnum.get(onum);
        if (globID == null) {
            return null;
        }
        return this.globTable.getContainer(globID);
    }

    public final void cacheGroupContainer(LongSet onums, GroupContainer container) {
        long globID = this.nextGlobID++;
        this.globTable.put(globID, container, onums.size());
        LongIterator it = onums.iterator();
        while (it.hasNext()) {
            long onum = it.next();
            Long oldGlobID = this.globIDByOnum.put(onum, globID);
            if (oldGlobID == null) continue;
            this.globTable.unpin(oldGlobID);
        }
    }

    protected final void notifyCommittedUpdate(SubscriptionManager sm, long onum, RemoteWorker worker) {
        Long globID = this.globIDByOnum.remove(onum);
        GroupContainer group = null;
        if (globID != null) {
            group = this.globTable.remove(globID);
        }
        sm.notifyUpdate(onum, worker);
        if (group != null) {
            LongIterator onumIt = group.onums.iterator();
            while (onumIt.hasNext()) {
                Long relatedGlobId;
                long relatedOnum = onumIt.next();
                if (relatedOnum == onum || (relatedGlobId = this.globIDByOnum.get(relatedOnum)) == null || relatedGlobId != globID) continue;
                sm.notifyUpdate(relatedOnum, worker);
            }
        }
    }

    public final boolean isPrepared(long onum, long tid) {
        Pair<Long, LongKeyMap<MutableInteger>> locks = this.rwLocks.get(onum);
        if (locks == null) {
            return false;
        }
        if (locks.first != null) {
            return true;
        }
        if (((LongKeyMap)locks.second).isEmpty()) {
            return false;
        }
        if (((LongKeyMap)locks.second).size() > 1) {
            return true;
        }
        return !((LongKeyMap)locks.second).containsKey(tid);
    }

    public final boolean isWritten(long onum) {
        Pair<Long, LongKeyMap<MutableInteger>> locks = this.rwLocks.get(onum);
        return locks != null && locks.first != null;
    }

    protected final void unpin(PendingTransaction tx) {
        Iterator<Serializable> i$ = tx.reads.iterator();
        while (i$.hasNext()) {
            long readOnum = i$.next();
            Pair<Long, LongKeyMap<MutableInteger>> locks = this.rwLocks.get(readOnum);
            MutableInteger pinCount = (MutableInteger)((LongKeyMap)locks.second).get(tx.tid);
            if (pinCount != null) {
                --pinCount.value;
                if (pinCount.value == 0) {
                    ((LongKeyMap)locks.second).remove(tx.tid);
                }
            }
            if (locks.first != null || !((LongKeyMap)locks.second).isEmpty()) continue;
            this.rwLocks.remove(readOnum);
        }
        for (SerializedObject update : tx.modData) {
            long onum = update.getOnum();
            Pair<Long, LongKeyMap<MutableInteger>> locks = this.rwLocks.get(onum);
            if (locks.first != null && (Long)locks.first == tx.tid) {
                locks.first = null;
            }
            if (locks.first != null || !((LongKeyMap)locks.second).isEmpty()) continue;
            this.rwLocks.remove(onum);
        }
    }

    public abstract long[] newOnums(int var1);

    public abstract boolean exists(long var1);

    public final String getName() {
        return this.name;
    }

    public abstract void close() throws IOException;

    protected abstract boolean isInitialized();

    protected abstract void setInitialized();

    public final void ensureInit() {
        if (this.isInitialized()) {
            return;
        }
        final RemoteStore store = Worker.getWorker().getStore(this.name);
        Worker.runInSubTransaction(new Worker.Code<Void>(){

            @Override
            public Void run() {
                String principalName = new X500Principal("CN=" + ObjectDB.this.name).getName();
                NodePrincipal._Impl principal = new NodePrincipal._Impl(store, null, principalName);
                principal.$forceRenumber(1L);
                ReaderPolicy confid = (ReaderPolicy)new ReaderPolicy._Impl(store, ObjectDB.this.publicReadonlyLabel(), (Principal)ObjectDB.this.storePrincipal(), null).$getProxy();
                WriterPolicy integ = (WriterPolicy)new WriterPolicy._Impl(store, ObjectDB.this.publicReadonlyLabel(), (Principal)ObjectDB.this.storePrincipal(), null).$getProxy();
                Label label = (Label)new PairLabel._Impl(store, null, (ConfPolicy)confid, (IntegPolicy)integ).$getProxy();
                HashMap._Impl map = new HashMap._Impl(store, label);
                map.$forceRenumber(0L);
                return null;
            }
        });
        this.setInitialized();
    }

    private final NodePrincipal storePrincipal() {
        if (this.storePrincipal == null) {
            RemoteStore store = Worker.getWorker().getStore(this.name);
            this.storePrincipal = new NodePrincipal._Proxy((Store)store, 1L);
        }
        return this.storePrincipal;
    }

    private final Label publicReadonlyLabel() {
        if (this.publicReadonlyLabel == null) {
            RemoteStore store = Worker.getWorker().getStore(this.name);
            this.publicReadonlyLabel = new Label._Proxy((Store)store, -7L);
        }
        return this.publicReadonlyLabel;
    }

    protected static final class PendingTransaction
    implements FastSerializable,
    Iterable<Long> {
        public final long tid;
        public final NodePrincipal owner;
        public final Collection<Long> reads;
        public final Collection<SerializedObject> modData;

        PendingTransaction(long tid, NodePrincipal owner) {
            this.tid = tid;
            this.owner = owner;
            this.reads = new ArrayList<Long>();
            this.modData = new ArrayList<SerializedObject>();
        }

        public PendingTransaction(ObjectInputStream in) throws IOException {
            int i;
            this.tid = in.readLong();
            if (in.readBoolean()) {
                RemoteStore store = Worker.getWorker().getStore(in.readUTF());
                this.owner = new NodePrincipal._Proxy((Store)store, in.readLong());
            } else {
                this.owner = null;
            }
            int size = in.readInt();
            this.reads = new ArrayList<Long>(size);
            for (i = 0; i < size; ++i) {
                this.reads.add(in.readLong());
            }
            size = in.readInt();
            this.modData = new ArrayList<SerializedObject>(size);
            for (i = 0; i < size; ++i) {
                this.modData.add(new SerializedObject(in));
            }
        }

        @Override
        public Iterator<Long> iterator() {
            return new Iterator<Long>(){
                private Iterator<Long> readIt;
                private Iterator<SerializedObject> modIt;
                {
                    this.readIt = PendingTransaction.this.reads.iterator();
                    this.modIt = PendingTransaction.this.modData.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.readIt.hasNext() || this.modIt.hasNext();
                }

                @Override
                public Long next() {
                    if (this.readIt.hasNext()) {
                        return this.readIt.next();
                    }
                    return this.modIt.next().getOnum();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeLong(this.tid);
            out.writeBoolean(this.owner != null);
            if (this.owner != null) {
                out.writeUTF(this.owner.$getStore().name());
                out.writeLong(this.owner.$getOnum());
            }
            out.writeInt(this.reads.size());
            for (Long onum : this.reads) {
                out.writeLong(onum);
            }
            out.writeInt(this.modData.size());
            for (SerializedObject obj : this.modData) {
                obj.write(out);
            }
        }
    }
}

