/*
 * Decompiled with CFR 0.152.
 */
package fabric.store.db;

import fabric.common.Logging;
import fabric.common.Resources;
import fabric.common.SerializedObject;
import fabric.common.exceptions.AccessException;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.common.util.OidKeyHashMap;
import fabric.lang.Object;
import fabric.lang.security.NodePrincipal;
import fabric.store.SubscriptionManager;
import fabric.store.db.ObjectDB;
import fabric.worker.remote.RemoteWorker;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MemoryDB
extends ObjectDB {
    private boolean isInitialized = false;
    private long nextOnum;
    private LongKeyMap<SerializedObject> objectTable;
    private long nextGlobID;

    public MemoryDB(String name) {
        super(name);
        try {
            ObjectInputStream oin = new ObjectInputStream(Resources.readFile("var", name));
            this.isInitialized = oin.readBoolean();
            this.nextOnum = oin.readLong();
            int size = oin.readInt();
            this.objectTable = new LongKeyHashMap<SerializedObject>(size);
            for (int i = 0; i < size; ++i) {
                this.objectTable.put(oin.readLong(), new SerializedObject(oin));
            }
            this.nextGlobID = oin.readLong();
        }
        catch (Exception e) {
            this.nextOnum = 2L;
            this.objectTable = new LongKeyHashMap<SerializedObject>();
        }
        Logging.STORE_DB_LOGGER.info("MemDB loaded");
    }

    @Override
    public void finishPrepare(long tid, NodePrincipal worker) {
    }

    @Override
    public void commit(long tid, RemoteWorker workerNode, NodePrincipal workerPrincipal, SubscriptionManager sm) throws AccessException {
        ObjectDB.PendingTransaction tx = this.remove(workerPrincipal, tid);
        for (SerializedObject o : tx.modData) {
            this.objectTable.put(o.getOnum(), o);
            this.notifyCommittedUpdate(sm, o.getOnum(), workerNode);
        }
    }

    @Override
    public void rollback(long tid, NodePrincipal worker) throws AccessException {
        this.remove(worker, tid);
    }

    @Override
    public SerializedObject read(long onum) {
        return this.objectTable.get(onum);
    }

    @Override
    public boolean exists(long onum) {
        return this.rwLocks.get(onum) != null || this.objectTable.containsKey(onum);
    }

    @Override
    public long[] newOnums(int num) {
        long[] result = new long[num < 0 ? 0 : num];
        for (int i = 0; i < num; ++i) {
            ++this.nextOnum;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        ObjectOutputStream oout = new ObjectOutputStream(Resources.writeFile("var", this.name));
        oout.writeBoolean(this.isInitialized);
        oout.writeLong(this.nextOnum);
        oout.writeInt(this.objectTable.size());
        for (LongKeyMap.Entry<SerializedObject> entry : this.objectTable.entrySet()) {
            oout.writeLong(entry.getKey());
            entry.getValue().write(oout);
        }
        oout.writeLong(this.nextGlobID);
        oout.flush();
        oout.close();
    }

    private ObjectDB.PendingTransaction remove(NodePrincipal worker, long tid) throws AccessException {
        OidKeyHashMap submap = (OidKeyHashMap)this.pendingByTid.get(tid);
        ObjectDB.PendingTransaction tx = (ObjectDB.PendingTransaction)submap.remove((Object)worker);
        if (submap.isEmpty()) {
            this.pendingByTid.remove(tid);
        }
        if (tx == null) {
            throw new AccessException("Invalid transaction id: " + tid);
        }
        this.unpin(tx);
        return tx;
    }

    @Override
    protected boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    protected void setInitialized() {
        this.isInitialized = true;
    }
}

