/*
 * Decompiled with CFR 0.152.
 */
package fabric.store.db;

import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.common.util.MutableInteger;
import fabric.common.util.Pair;
import fabric.store.db.GroupContainer;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

final class GroupContainerTable {
    private final LongKeyMap<Pair<SoftRef, MutableInteger>> table = new LongKeyHashMap<Pair<SoftRef, MutableInteger>>();
    private final ReferenceQueue<GroupContainer> queue = new ReferenceQueue();

    public GroupContainerTable() {
        new Collector().start();
    }

    public synchronized GroupContainer getContainer(long globID) {
        Pair<SoftRef, MutableInteger> pair = this.table.get(globID);
        if (pair == null) {
            return null;
        }
        return (GroupContainer)((SoftRef)pair.first).get();
    }

    public synchronized void unpin(long globID) {
        Pair<SoftRef, MutableInteger> pair = this.table.get(globID);
        if (pair == null) {
            return;
        }
        if (((MutableInteger)pair.second).value == 1) {
            this.remove(globID);
        }
        --((MutableInteger)pair.second).value;
    }

    public synchronized void put(long globID, GroupContainer groupContainer, int pinCount) {
        SoftRef ref = new SoftRef(globID, groupContainer, this.queue);
        Pair<SoftRef, MutableInteger> entry = new Pair<SoftRef, MutableInteger>(ref, new MutableInteger(pinCount));
        this.table.put(globID, entry);
    }

    public synchronized GroupContainer remove(long globID) {
        Pair<SoftRef, MutableInteger> entry = this.table.remove(globID);
        if (entry == null) {
            return null;
        }
        return (GroupContainer)((SoftRef)entry.first).get();
    }

    private final class Collector
    extends Thread {
        public Collector() {
            super("Group container soft-ref collector");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        SoftRef ref = (SoftRef)GroupContainerTable.this.queue.remove();
                        GroupContainerTable.this.remove(ref.globId);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private static class SoftRef
    extends SoftReference<GroupContainer> {
        final long globId;

        public SoftRef(long globID, GroupContainer group, ReferenceQueue<GroupContainer> queue) {
            super(group, queue);
            this.globId = globID;
        }
    }
}

