/*
 * Decompiled with CFR 0.152.
 */
package fabric.store.db;

import fabric.common.AuthorizationUtil;
import fabric.common.ObjectGroup;
import fabric.common.SerializedObject;
import fabric.common.exceptions.InternalError;
import fabric.common.util.LongSet;
import fabric.dissemination.Glob;
import fabric.lang.security.NodePrincipal;
import fabric.worker.Store;
import java.security.PrivateKey;
import java.util.Iterator;

public final class GroupContainer {
    private final Store store;
    private final long labelOnum;
    private final PrivateKey signingKey;
    private ObjectGroup group;
    private Glob glob;
    public final LongSet onums;

    public GroupContainer(Store store, PrivateKey signingKey, ObjectGroup group) {
        this.store = store;
        this.signingKey = signingKey;
        this.group = group;
        this.glob = null;
        this.onums = group.objects().keySet();
        Iterator<SerializedObject> i$ = group.objects().values().iterator();
        if (i$.hasNext()) {
            SerializedObject obj = i$.next();
            this.labelOnum = obj.getLabelOnum();
            return;
        }
        throw new InternalError("Empty object group");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectGroup getGroup(NodePrincipal principal) {
        Glob glob;
        ObjectGroup group;
        if (!AuthorizationUtil.isReadPermitted(principal, this.store, this.labelOnum)) {
            return null;
        }
        GroupContainer groupContainer = this;
        synchronized (groupContainer) {
            group = this.group;
            glob = this.glob;
        }
        if (group != null) {
            return group;
        }
        return glob.decrypt(this.store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Glob getGlob() {
        if (this.glob != null) {
            return this.glob;
        }
        GroupContainer groupContainer = this;
        synchronized (groupContainer) {
            if (this.glob == null) {
                this.glob = new Glob(this.store, this.group, this.signingKey);
                this.group = null;
            }
            return this.glob;
        }
    }
}

