/*
 * Decompiled with CFR 0.152.
 */
package fabric.store.db;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import fabric.common.FastSerializable;
import fabric.common.Logging;
import fabric.common.Resources;
import fabric.common.SerializedObject;
import fabric.common.exceptions.AccessException;
import fabric.common.exceptions.InternalError;
import fabric.common.util.Cache;
import fabric.common.util.LongKeyCache;
import fabric.common.util.OidKeyHashMap;
import fabric.lang.Object;
import fabric.lang.security.NodePrincipal;
import fabric.store.SubscriptionManager;
import fabric.store.db.ObjectDB;
import fabric.worker.remote.RemoteWorker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.logging.Level;

public class BdbDB
extends ObjectDB {
    private Environment env;
    private Database meta;
    private Database db;
    private Database prepared;
    private final DatabaseEntry initializationStatus;
    private final DatabaseEntry onumCounter;
    private long nextOnum;
    private long lastReservedOnum;
    private final LongKeyCache<Integer> cachedVersions;
    private final Cache<ByteArray, ObjectDB.PendingTransaction> preparedTransactions;
    private final long ONUM_RESERVE_SIZE = 10240L;

    public BdbDB(String name) {
        super(name);
        String path = Resources.relpathRewrite("var", "bdb", name);
        new File(path).mkdirs();
        try {
            EnvironmentConfig conf = new EnvironmentConfig();
            conf.setAllowCreate(true);
            conf.setTransactional(true);
            this.env = new Environment(new File(path), conf);
            Logging.STORE_DB_LOGGER.info("Bdb env opened");
            DatabaseConfig dbconf = new DatabaseConfig();
            dbconf.setAllowCreate(true);
            dbconf.setTransactional(true);
            this.db = this.env.openDatabase(null, "store", dbconf);
            this.prepared = this.env.openDatabase(null, "prepared", dbconf);
            this.meta = this.env.openDatabase(null, "meta", dbconf);
            this.initRwCount();
            Logging.STORE_DB_LOGGER.info("Bdb databases opened");
        }
        catch (DatabaseException e) {
            Logging.STORE_DB_LOGGER.log(Level.SEVERE, "Bdb error in <init>: ", e);
            throw new InternalError(e);
        }
        try {
            this.initializationStatus = new DatabaseEntry("initialization_status".getBytes("UTF-8"));
            this.onumCounter = new DatabaseEntry("onum_counter".getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e);
        }
        this.nextOnum = -1L;
        this.lastReservedOnum = -2L;
        this.cachedVersions = new LongKeyCache();
        this.preparedTransactions = new Cache();
    }

    @Override
    public void finishPrepare(long tid, NodePrincipal worker) {
        OidKeyHashMap submap = (OidKeyHashMap)this.pendingByTid.get(tid);
        ObjectDB.PendingTransaction pending = (ObjectDB.PendingTransaction)submap.remove((Object)worker);
        if (submap.isEmpty()) {
            this.pendingByTid.remove(tid);
        }
        try {
            Transaction txn = this.env.beginTransaction(null, null);
            byte[] key = this.toBytes(tid, worker);
            DatabaseEntry data = new DatabaseEntry(this.toBytes(pending));
            this.prepared.put(txn, new DatabaseEntry(key), data);
            txn.commit();
            this.preparedTransactions.put(new ByteArray(key), pending);
            Logging.STORE_DB_LOGGER.finer("Bdb prepare success tid " + tid);
        }
        catch (DatabaseException e) {
            Logging.STORE_DB_LOGGER.log(Level.SEVERE, "Bdb error in finishPrepare: ", e);
            throw new InternalError(e);
        }
    }

    @Override
    public void commit(long tid, RemoteWorker workerNode, NodePrincipal workerPrincipal, SubscriptionManager sm) {
        Logging.STORE_DB_LOGGER.finer("Bdb commit begin tid " + tid);
        try {
            Transaction txn = this.env.beginTransaction(null, null);
            ObjectDB.PendingTransaction pending = this.remove(workerPrincipal, txn, tid);
            if (pending != null) {
                for (SerializedObject o : pending.modData) {
                    long onum = o.getOnum();
                    Logging.STORE_DB_LOGGER.finest("Bdb committing onum " + onum);
                    DatabaseEntry onumData = new DatabaseEntry(this.toBytes(onum));
                    DatabaseEntry objData = new DatabaseEntry(this.toBytes(o));
                    this.db.put(txn, onumData, objData);
                    this.notifyCommittedUpdate(sm, this.toLong(onumData.getData()), workerNode);
                    this.cachedVersions.put(onum, o.getVersion());
                }
            } else {
                txn.abort();
                Logging.STORE_DB_LOGGER.warning("Bdb commit not found tid " + tid);
                throw new InternalError("Unknown transaction id " + tid);
            }
            txn.commit();
            Logging.STORE_DB_LOGGER.finer("Bdb commit success tid " + tid);
        }
        catch (DatabaseException e) {
            this.cachedVersions.clear();
            Logging.STORE_DB_LOGGER.log(Level.SEVERE, "Bdb error in commit: ", e);
            throw new InternalError(e);
        }
    }

    @Override
    public void rollback(long tid, NodePrincipal worker) {
        Logging.STORE_DB_LOGGER.finer("Bdb rollback begin tid " + tid);
        try {
            Transaction txn = this.env.beginTransaction(null, null);
            this.remove(worker, txn, tid);
            txn.commit();
            Logging.STORE_DB_LOGGER.finer("Bdb rollback success tid " + tid);
        }
        catch (DatabaseException e) {
            Logging.STORE_DB_LOGGER.log(Level.SEVERE, "Bdb error in rollback: ", e);
            throw new InternalError(e);
        }
    }

    @Override
    public SerializedObject read(long onum) {
        Logging.STORE_DB_LOGGER.finest("Bdb read onum " + onum);
        DatabaseEntry key = new DatabaseEntry(this.toBytes(onum));
        DatabaseEntry data = new DatabaseEntry();
        try {
            if (this.db.get(null, key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                SerializedObject result = this.toSerializedObject(data.getData());
                if (result != null) {
                    this.cachedVersions.put(onum, result.getVersion());
                }
                return result;
            }
        }
        catch (DatabaseException e) {
            Logging.STORE_DB_LOGGER.log(Level.SEVERE, "Bdb error in read: ", e);
            throw new InternalError(e);
        }
        return null;
    }

    @Override
    public int getVersion(long onum) throws AccessException {
        Integer ver = this.cachedVersions.get(onum);
        if (ver != null) {
            return ver;
        }
        return super.getVersion(onum);
    }

    @Override
    public boolean exists(long onum) {
        DatabaseEntry key = new DatabaseEntry(this.toBytes(onum));
        DatabaseEntry data = new DatabaseEntry();
        try {
            if (this.rwLocks.get(onum) != null || this.db.get(null, key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                return true;
            }
        }
        catch (DatabaseException e) {
            Logging.STORE_DB_LOGGER.log(Level.SEVERE, "Bdb error in exists: ", e);
            throw new InternalError(e);
        }
        return false;
    }

    @Override
    public long[] newOnums(int num) {
        Logging.STORE_DB_LOGGER.fine("Bdb new onums begin");
        try {
            long[] onums = new long[num];
            for (int i = 0; i < num; ++i) {
                if (this.nextOnum > this.lastReservedOnum) {
                    Transaction txn = this.env.beginTransaction(null, null);
                    DatabaseEntry data = new DatabaseEntry();
                    this.nextOnum = 2L;
                    if (this.meta.get(txn, this.onumCounter, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                        this.nextOnum = this.toLong(data.getData());
                    }
                    this.lastReservedOnum = this.nextOnum + 10240L + (long)num - (long)i - 1L;
                    data.setData(this.toBytes(this.lastReservedOnum + 1L));
                    this.meta.put(txn, this.onumCounter, data);
                    txn.commit();
                    Logging.STORE_DB_LOGGER.fine("Bdb reserved onums " + this.nextOnum + "--" + this.lastReservedOnum);
                }
                ++this.nextOnum;
            }
            return onums;
        }
        catch (DatabaseException e) {
            Logging.STORE_DB_LOGGER.log(Level.SEVERE, "Bdb error in newOnums: ", e);
            throw new InternalError(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.db != null) {
                this.db.close();
            }
            if (this.prepared != null) {
                this.prepared.close();
            }
            if (this.env != null) {
                this.env.close();
            }
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    @Override
    public boolean isInitialized() {
        Logging.STORE_DB_LOGGER.fine("Bdb is initialized begin");
        try {
            Transaction txn = this.env.beginTransaction(null, null);
            DatabaseEntry data = new DatabaseEntry();
            boolean result = false;
            if (this.meta.get(txn, this.initializationStatus, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                result = this.toBoolean(data.getData());
            }
            txn.commit();
            return result;
        }
        catch (DatabaseException e) {
            Logging.STORE_DB_LOGGER.log(Level.SEVERE, "Bdb error in isInitialized: ", e);
            throw new InternalError(e);
        }
    }

    @Override
    public void setInitialized() {
        Logging.STORE_DB_LOGGER.fine("Bdb set initialized begin");
        try {
            Transaction txn = this.env.beginTransaction(null, null);
            DatabaseEntry data = new DatabaseEntry(this.toBytes(true));
            this.meta.put(txn, this.initializationStatus, data);
            txn.commit();
        }
        catch (DatabaseException e) {
            Logging.STORE_DB_LOGGER.log(Level.SEVERE, "Bdb error in isInitialized: ", e);
            throw new InternalError(e);
        }
    }

    private void initRwCount() {
    }

    private ObjectDB.PendingTransaction remove(NodePrincipal worker, Transaction txn, long tid) throws DatabaseException {
        byte[] key = this.toBytes(tid, worker);
        DatabaseEntry bdbKey = new DatabaseEntry(key);
        DatabaseEntry data = new DatabaseEntry();
        ObjectDB.PendingTransaction pending = this.preparedTransactions.remove(new ByteArray(key));
        if (pending == null && this.prepared.get(txn, bdbKey, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            pending = this.toPendingTransaction(data.getData());
        }
        if (pending == null) {
            return null;
        }
        this.prepared.delete(txn, bdbKey);
        this.unpin(pending);
        return pending;
    }

    private byte[] toBytes(boolean b) {
        byte[] result = new byte[]{(byte)(b ? 1 : 0)};
        return result;
    }

    private boolean toBoolean(byte[] data) {
        return data[0] == 1;
    }

    private byte[] toBytes(long i) {
        byte[] data = new byte[8];
        for (int j = 0; j < 8; ++j) {
            data[7 - j] = (byte)(i & 0xFFL);
            i >>>= 8;
        }
        return data;
    }

    private byte[] toBytes(long tid, NodePrincipal worker) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeLong(tid);
            if (worker != null) {
                dos.writeUTF(worker.$getStore().name());
                dos.writeLong(worker.$getOnum());
            }
            dos.flush();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    private long toLong(byte[] data) {
        long i = 0L;
        for (int j = 0; j < 8; ++j) {
            i <<= 8;
            i |= (long)(data[j] & 0xFF);
        }
        return i;
    }

    private byte[] toBytes(FastSerializable obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            obj.write(oos);
            oos.flush();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    private ObjectDB.PendingTransaction toPendingTransaction(byte[] data) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return new ObjectDB.PendingTransaction(ois);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    private SerializedObject toSerializedObject(byte[] data) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return new SerializedObject(ois);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    private static class ByteArray {
        private final byte[] data;

        public ByteArray(byte[] data) {
            this.data = data;
        }

        public boolean equals(java.lang.Object obj) {
            if (!(obj instanceof ByteArray)) {
                return false;
            }
            byte[] data = ((ByteArray)obj).data;
            return Arrays.equals(data, ((ByteArray)obj).data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

