/*
 * Decompiled with CFR 0.152.
 */
package fabric.store;

import fabric.common.AuthorizationUtil;
import fabric.common.Logging;
import fabric.common.ObjectGroup;
import fabric.common.SerializedObject;
import fabric.common.exceptions.AccessException;
import fabric.common.util.LongHashSet;
import fabric.common.util.LongIterator;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.common.util.LongSet;
import fabric.common.util.Pair;
import fabric.dissemination.Glob;
import fabric.lang.DefaultStatistics;
import fabric.lang.Object;
import fabric.lang.Statistics;
import fabric.lang.security.Label;
import fabric.lang.security.NodePrincipal;
import fabric.store.MessageHandlerThread;
import fabric.store.PrepareRequest;
import fabric.store.SessionAttributes;
import fabric.store.SubscriptionManager;
import fabric.store.db.GroupContainer;
import fabric.store.db.ObjectDB;
import fabric.worker.RemoteStore;
import fabric.worker.TransactionCommitFailedException;
import fabric.worker.TransactionPrepareFailedException;
import fabric.worker.Worker;
import fabric.worker.remote.RemoteWorker;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class TransactionManager {
    private static final int INITIAL_OBJECT_VERSION_NUMBER = 1;
    private static final int MAX_GROUP_SIZE = 75;
    private static final Random rand = new Random();
    private final ObjectDB database;
    private final SubscriptionManager sm;
    private final PrivateKey signingKey;
    private final LongKeyMap<Statistics> objectStats;

    public TransactionManager(ObjectDB database, PrivateKey signingKey) {
        this.database = database;
        this.signingKey = signingKey;
        this.objectStats = new LongKeyHashMap<Statistics>();
        this.sm = new SubscriptionManager(database.getName(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTransaction(NodePrincipal worker, long transactionID) throws AccessException {
        ObjectDB objectDB = this.database;
        synchronized (objectDB) {
            this.database.rollback(transactionID, worker);
            Logging.STORE_TRANSACTION_LOGGER.fine("Aborted transaction " + transactionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(RemoteWorker workerNode, NodePrincipal workerPrincipal, long transactionID) throws TransactionCommitFailedException {
        ObjectDB objectDB = this.database;
        synchronized (objectDB) {
            try {
                this.database.commit(transactionID, workerNode, workerPrincipal, this.sm);
                Logging.STORE_TRANSACTION_LOGGER.fine("Committed transaction " + transactionID);
            }
            catch (AccessException e) {
                throw new TransactionCommitFailedException("Insufficient Authorization");
            }
            catch (RuntimeException e) {
                throw new TransactionCommitFailedException("something went wrong; store experienced a runtime exception during commit: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepare(NodePrincipal worker, PrepareRequest req) throws TransactionPrepareFailedException {
        long tid = req.tid;
        boolean result = false;
        RemoteStore store = Worker.getWorker().getStore(this.database.getName());
        if (worker == null || worker.$getStore() != store || worker.$getOnum() != 1L) {
            try {
                this.checkPerms(worker, req.reads.keySet(), req.writes);
            }
            catch (AccessException e) {
                throw new TransactionPrepareFailedException(e.getMessage());
            }
        }
        ObjectDB e = this.database;
        synchronized (e) {
            try {
                this.database.beginTransaction(tid, worker);
            }
            catch (AccessException e2) {
                throw new TransactionPrepareFailedException("Insufficient privileges");
            }
        }
        try {
            Pair<Statistics, Boolean> pair;
            LongKeyHashMap<SerializedObject> versionConflicts = new LongKeyHashMap<SerializedObject>();
            for (SerializedObject o : req.writes) {
                int workerVersion;
                SerializedObject storeCopy;
                long onum = o.getOnum();
                ObjectDB objectDB = this.database;
                synchronized (objectDB) {
                    if (this.database.isPrepared(onum, tid)) {
                        throw new TransactionPrepareFailedException("Object " + onum + " has been locked by an uncommitted transaction");
                    }
                    storeCopy = this.database.read(onum);
                    this.database.registerUpdate(tid, worker, o);
                }
                if (storeCopy.getExpiry() > req.commitTime) {
                    throw new TransactionPrepareFailedException("Update to object" + onum + " violates an outstanding promise");
                }
                int storeVersion = storeCopy.getVersion();
                if (storeVersion != (workerVersion = o.getVersion())) {
                    versionConflicts.put(onum, storeCopy);
                    continue;
                }
                pair = this.ensureStatistics(onum, req.tid);
                ((Statistics)pair.first).commitWrote();
                result |= ((Boolean)pair.second).booleanValue();
                o.setVersion(storeVersion + 1);
            }
            Iterator<LongKeyMap.Entry<Integer>> i$ = this.database;
            synchronized (i$) {
                for (SerializedObject o : req.creates) {
                    long onum = o.getOnum();
                    if (this.database.isPrepared(onum, tid)) {
                        throw new TransactionPrepareFailedException(versionConflicts, "Object " + onum + " has been locked by an " + "uncommitted transaction");
                    }
                    if (this.database.exists(onum)) {
                        throw new TransactionPrepareFailedException(versionConflicts, "Object " + onum + " already exists");
                    }
                    o.setVersion(1);
                    this.database.registerUpdate(tid, worker, o);
                }
            }
            for (LongKeyMap.Entry<Integer> entry : req.reads.entrySet()) {
                long onum = entry.getKey();
                int version = entry.getValue();
                ObjectDB objectDB = this.database;
                synchronized (objectDB) {
                    int curVersion;
                    if (this.database.isWritten(onum)) {
                        throw new TransactionPrepareFailedException(versionConflicts, "Object " + onum + " has been locked by an uncommitted " + "transaction");
                    }
                    try {
                        curVersion = this.database.getVersion(onum);
                    }
                    catch (AccessException e3) {
                        throw new TransactionPrepareFailedException(versionConflicts, e3.getMessage());
                    }
                    if (curVersion != version) {
                        versionConflicts.put(onum, this.database.read(onum));
                        continue;
                    }
                    pair = this.ensureStatistics(onum, req.tid);
                    ((Statistics)pair.first).commitRead();
                    result |= ((Boolean)pair.second).booleanValue();
                    this.database.registerRead(tid, worker, onum);
                }
            }
            if (!versionConflicts.isEmpty()) {
                throw new TransactionPrepareFailedException(versionConflicts);
            }
            ObjectDB objectDB = this.database;
            synchronized (objectDB) {
                this.database.finishPrepare(tid, worker);
            }
            Logging.STORE_TRANSACTION_LOGGER.fine("Prepared transaction " + tid);
            return result;
        }
        catch (TransactionPrepareFailedException e2) {
            ObjectDB objectDB = this.database;
            synchronized (objectDB) {
                this.database.abortPrepare(tid, worker);
                throw e2;
            }
        }
        catch (RuntimeException e3) {
            ObjectDB objectDB = this.database;
            synchronized (objectDB) {
                e3.printStackTrace();
                this.database.abortPrepare(tid, worker);
                throw e3;
            }
        }
    }

    private void checkPerms(final NodePrincipal worker, final LongSet reads, final Collection<SerializedObject> writes) throws AccessException {
        Worker.Code<AccessException> checker = new Worker.Code<AccessException>(){

            @Override
            public AccessException run() {
                RemoteStore store = Worker.getWorker().getStore(TransactionManager.this.database.getName());
                LongIterator it = reads.iterator();
                while (it.hasNext()) {
                    long onum = it.next();
                    Object._Proxy storeCopy = new Object._Proxy(store, onum);
                    Label label = storeCopy.get$label();
                    if (AuthorizationUtil.isReadPermitted(worker, label.$getStore(), label.$getOnum())) continue;
                    return new AccessException("Insufficient privileges to read object " + onum);
                }
                for (SerializedObject o : writes) {
                    long onum = o.getOnum();
                    Object._Proxy storeCopy = new Object._Proxy(store, onum);
                    Label label = storeCopy.get$label();
                    if (AuthorizationUtil.isWritePermitted(worker, label.$getStore(), label.$getOnum())) continue;
                    return new AccessException("Insufficient privileges to write object " + onum);
                }
                return null;
            }
        };
        AccessException failure = Worker.runInTransaction(null, checker);
        if (failure != null) {
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupContainer getGroupContainerAndSubscribe(long onum, RemoteWorker subscriber, boolean dissemSubscribe, MessageHandlerThread handler) throws AccessException {
        ObjectGroup group;
        GroupContainer container;
        ObjectDB objectDB = this.database;
        synchronized (objectDB) {
            container = this.database.getCachedGroupContainer(onum);
            if (container != null) {
                if (subscriber != null) {
                    this.sm.subscribe(onum, subscriber, dissemSubscribe);
                }
                return container;
            }
        }
        if (subscriber != null) {
            this.sm.subscribe(onum, subscriber, dissemSubscribe);
        }
        if ((group = this.readGroup(onum, handler)) == null) {
            throw new AccessException(this.database.getName(), onum);
        }
        RemoteStore store = Worker.getWorker().getStore(this.database.getName());
        container = new GroupContainer(store, this.signingKey, group);
        ObjectDB objectDB2 = this.database;
        synchronized (objectDB2) {
            this.database.cacheGroupContainer(group.objects().keySet(), container);
        }
        if (handler != null) {
            ((SessionAttributes)handler.getSession()).recordGlobCreated(group.objects().size());
        }
        return container;
    }

    public Glob getGlob(long onum, RemoteWorker subscriber, MessageHandlerThread handler) throws AccessException {
        return this.getGroupContainerAndSubscribe(onum, subscriber, true, handler).getGlob();
    }

    public ObjectGroup getGroup(NodePrincipal principal, RemoteWorker subscriber, long onum, MessageHandlerThread handler) throws AccessException {
        ObjectGroup group = this.getGroupContainerAndSubscribe(onum, subscriber, false, handler).getGroup(principal);
        if (group == null) {
            throw new AccessException(this.database.getName(), onum);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectGroup readGroup(long onum, MessageHandlerThread handler) {
        SerializedObject obj = this.read(onum);
        if (obj == null) {
            return null;
        }
        long headLabelOnum = obj.getLabelOnum();
        LongKeyHashMap<SerializedObject> group = new LongKeyHashMap<SerializedObject>(75);
        LinkedList<SerializedObject> toVisit = new LinkedList<SerializedObject>();
        LongHashSet seen = new LongHashSet();
        toVisit.add(obj);
        seen.add(onum);
        while (!toVisit.isEmpty()) {
            SerializedObject curObj = (SerializedObject)toVisit.remove();
            group.put(curObj.getOnum(), curObj);
            if (handler != null) {
                ((SessionAttributes)handler.getSession()).recordObjectSent(curObj.getClassName());
            }
            if (group.size() == 75) break;
            Iterator<Long> it = curObj.getIntraStoreRefIterator();
            while (it.hasNext()) {
                long relatedLabelOnum;
                long relatedOnum = it.next();
                if (seen.contains(relatedOnum)) continue;
                seen.add(relatedOnum);
                ObjectDB objectDB = this.database;
                synchronized (objectDB) {
                    if (this.database.getCachedGroupContainer(relatedOnum) != null) {
                        continue;
                    }
                }
                SerializedObject related = this.read(relatedOnum);
                if (related == null || headLabelOnum != (relatedLabelOnum = related.getLabelOnum())) continue;
                toVisit.add(related);
            }
        }
        return new ObjectGroup(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerializedObject read(long onum) {
        int promise;
        Statistics history;
        SerializedObject obj;
        ObjectDB objectDB = this.database;
        synchronized (objectDB) {
            obj = this.database.read(onum);
        }
        if (obj == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (obj.getExpiry() < now && (history = this.getStatistics(onum)) != null && (promise = history.generatePromise()) > 0) {
            NodePrincipal worker = Worker.getWorker().getPrincipal();
            ObjectDB objectDB2 = this.database;
            synchronized (objectDB2) {
                if (this.database.isWritten(onum)) {
                    return obj;
                }
                SerializedObject newObj = this.database.read(onum);
                long time = newObj.getExpiry();
                if (time < now + (long)promise) {
                    try {
                        newObj.setExpiry(now + (long)promise);
                        long tid = rand.nextLong();
                        this.database.beginTransaction(tid, worker);
                        this.database.registerUpdate(tid, worker, newObj);
                        this.database.finishPrepare(tid, worker);
                        this.database.commit(tid, null, worker, this.sm);
                    }
                    catch (AccessException exc) {
                        return obj;
                    }
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statistics getStatistics(long onum) {
        LongKeyMap<Statistics> longKeyMap = this.objectStats;
        synchronized (longKeyMap) {
            return this.objectStats.get(onum);
        }
    }

    private Pair<Statistics, Boolean> ensureStatistics(long onum, long tnum) {
        return new Pair<Statistics, Boolean>(DefaultStatistics.instance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] newOnums(NodePrincipal worker, int num) throws AccessException {
        ObjectDB objectDB = this.database;
        synchronized (objectDB) {
            return this.database.newOnums(num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] newOnums(int num) {
        ObjectDB objectDB = this.database;
        synchronized (objectDB) {
            return this.database.newOnums(num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SerializedObject> checkForStaleObjects(NodePrincipal worker, LongKeyMap<Integer> versions) throws AccessException {
        RemoteStore store = Worker.getWorker().getStore(this.database.getName());
        if (worker == null || worker.$getStore() != store || worker.$getOnum() != 1L) {
            this.checkPerms(worker, versions.keySet(), Collections.EMPTY_LIST);
        }
        ArrayList<SerializedObject> result = new ArrayList<SerializedObject>();
        for (LongKeyMap.Entry<Integer> entry : versions.entrySet()) {
            long onum = entry.getKey();
            int version = entry.getValue();
            ObjectDB objectDB = this.database;
            synchronized (objectDB) {
                int curVersion = this.database.getVersion(onum);
                if (curVersion != version) {
                    result.add(this.database.read(onum));
                }
            }
        }
        return result;
    }
}

