/*
 * Decompiled with CFR 0.152.
 */
package fabric.store;

import fabric.common.FabricThread;
import fabric.common.ObjectGroup;
import fabric.common.exceptions.AccessException;
import fabric.common.exceptions.InternalError;
import fabric.common.util.LongKeyCache;
import fabric.common.util.Pair;
import fabric.dissemination.Glob;
import fabric.net.UnreachableNodeException;
import fabric.store.TransactionManager;
import fabric.store.db.GroupContainer;
import fabric.worker.remote.RemoteWorker;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class SubscriptionManager
extends FabricThread.AbstractImpl {
    private final Set<Pair<Long, RemoteWorker>> updatedOnums;
    private final LongKeyCache<Set<Pair<RemoteWorker, Boolean>>> subscriptions;
    private final String store;
    private final TransactionManager tm;

    public SubscriptionManager(String store, TransactionManager tm) {
        super("subscription manager for store " + store);
        this.store = store;
        this.updatedOnums = new LinkedHashSet<Pair<Long, RemoteWorker>>();
        this.tm = tm;
        this.subscriptions = new LongKeyCache();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Glob glob;
            GroupContainer groupContainer;
            Set<Pair<RemoteWorker, Boolean>> subscribers;
            Pair<Long, RemoteWorker> updateEntry;
            Set<Pair<Long, RemoteWorker>> set = this.updatedOnums;
            synchronized (set) {
                if (this.updatedOnums.isEmpty()) {
                    try {
                        this.updatedOnums.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
                Iterator<Pair<Long, RemoteWorker>> updates = this.updatedOnums.iterator();
                updateEntry = updates.next();
                updates.remove();
            }
            long onum = (Long)updateEntry.first;
            RemoteWorker updater = (RemoteWorker)updateEntry.second;
            LongKeyCache<Set<Pair<RemoteWorker, Boolean>>> longKeyCache = this.subscriptions;
            synchronized (longKeyCache) {
                subscribers = this.subscriptions.remove(onum);
            }
            if (subscribers == null) continue;
            try {
                groupContainer = this.tm.getGroupContainerAndSubscribe(onum, null, false, null);
                glob = groupContainer.getGlob();
            }
            catch (AccessException e) {
                throw new InternalError(e);
            }
            HashSet<Pair<RemoteWorker, Boolean>> newSubscribers = new HashSet<Pair<RemoteWorker, Boolean>>();
            for (Pair<RemoteWorker, Boolean> subscriber : subscribers) {
                boolean resubscribe;
                RemoteWorker node = (RemoteWorker)subscriber.first;
                boolean isDissem = (Boolean)subscriber.second;
                if (node == updater && !isDissem) {
                    resubscribe = true;
                } else {
                    try {
                        ObjectGroup group;
                        resubscribe = isDissem ? node.notifyObjectUpdate(this.store, onum, glob) : (group = groupContainer.getGroup(node.getPrincipal())) != null && node.notifyObjectUpdate(onum, group);
                    }
                    catch (UnreachableNodeException e) {
                        resubscribe = false;
                    }
                }
                if (!resubscribe) continue;
                newSubscribers.add(subscriber);
            }
            this.subscribe(onum, newSubscribers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribe(long onum, Set<Pair<RemoteWorker, Boolean>> newSubscribers) {
        if (newSubscribers.isEmpty()) {
            return;
        }
        LongKeyCache<Set<Pair<RemoteWorker, Boolean>>> longKeyCache = this.subscriptions;
        synchronized (longKeyCache) {
            Set<Pair<RemoteWorker, Boolean>> subscribers = this.subscriptions.get(onum);
            if (subscribers == null) {
                this.subscriptions.put(onum, newSubscribers);
            } else {
                subscribers.addAll(newSubscribers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(long onum, RemoteWorker worker, boolean dissemSubscribe) {
        LongKeyCache<Set<Pair<RemoteWorker, Boolean>>> longKeyCache = this.subscriptions;
        synchronized (longKeyCache) {
            Set<Pair<RemoteWorker, Boolean>> subscribers = this.subscriptions.get(onum);
            if (subscribers == null) {
                subscribers = new HashSet<Pair<RemoteWorker, Boolean>>();
                this.subscriptions.put(onum, subscribers);
            }
            subscribers.add(new Pair<RemoteWorker, Boolean>(worker, dissemSubscribe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdate(long onum, RemoteWorker worker) {
        Set<Pair<Long, RemoteWorker>> set = this.updatedOnums;
        synchronized (set) {
            this.updatedOnums.add(new Pair<Long, RemoteWorker>(onum, worker));
            this.updatedOnums.notify();
        }
    }
}

