/*
 * Decompiled with CFR 0.152.
 */
package fabric.store;

import fabric.common.RefTypeEnum;
import fabric.common.SerializedObject;
import fabric.common.Util;
import fabric.common.util.ComparablePair;
import fabric.store.PrepareRequest;
import fabric.store.SurrogateManager;
import fabric.store.TransactionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class SimpleSurrogateManager
implements SurrogateManager {
    private TransactionManager tm;

    public SimpleSurrogateManager(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public void createSurrogates(PrepareRequest req) {
        TreeMap<ComparablePair<String, Long>, Long> cache = new TreeMap<ComparablePair<String, Long>, Long>();
        ArrayList<SerializedObject> surrogates = new ArrayList<SerializedObject>();
        for (SerializedObject obj : Util.chain(req.creates, req.writes)) {
            long labelOnum;
            Iterator<Long> intraStore = obj.getIntraStoreRefIterator();
            Iterator<ComparablePair<String, Long>> interStore = obj.getInterStoreRefIterator();
            boolean hadRemotes = false;
            ArrayList<Long> newrefs = new ArrayList<Long>(obj.getNumIntraStoreRefs() + obj.getNumInterStoreRefs() + 1);
            if (obj.labelRefIsInterStore()) {
                ComparablePair<String, Long> ref = obj.getInterStoreLabelRef();
                labelOnum = this.tm.newOnums(1)[0];
                surrogates.add(new SerializedObject(labelOnum, labelOnum, ref));
                cache.put(ref, labelOnum);
                hadRemotes = true;
                newrefs.add(labelOnum);
            } else {
                labelOnum = obj.getLabelOnum();
            }
            Iterator<RefTypeEnum> it = obj.getRefTypeIterator();
            while (it.hasNext()) {
                RefTypeEnum type = it.next();
                switch (type) {
                    case NULL: 
                    case INLINE: {
                        break;
                    }
                    case ONUM: {
                        newrefs.add(intraStore.next());
                        break;
                    }
                    case REMOTE: {
                        ComparablePair<String, Long> ref = interStore.next();
                        Long onum = (Long)cache.get(ref);
                        if (onum == null) {
                            onum = this.tm.newOnums(1)[0];
                            surrogates.add(new SerializedObject(onum, labelOnum, ref));
                            cache.put(ref, onum);
                        }
                        hadRemotes = true;
                        newrefs.add(onum);
                    }
                }
            }
            if (!hadRemotes) continue;
            obj.setRefs(newrefs);
        }
        req.creates.addAll(surrogates);
    }
}

