/*
 * Decompiled with CFR 0.152.
 */
package fabric.store;

import fabric.common.AbstractMessageHandlerThread;
import fabric.common.Logging;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.lang.security.NodePrincipal;
import fabric.store.Node;
import fabric.worker.Worker;
import fabric.worker.remote.RemoteWorker;
import java.security.PrivateKey;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

final class SessionAttributes
extends AbstractMessageHandlerThread.SessionAttributes {
    final boolean workerIsDissem;
    final Node.Store store;
    final RemoteWorker remoteNode;
    final String workerPrincipalName;
    final NodePrincipal workerPrincipal;
    final PrivateKey privateKey;
    private int numReads;
    int numObjectsSent;
    private int numGlobsSent;
    int numGlobbedObjects;
    int numGlobsCreated;
    private int numPrepares;
    private int numCommits;
    private int numCreates;
    private int numWrites;
    Map<String, Integer> numSendsByType;
    private final LongKeyMap<LogRecord> pendingLogs;

    SessionAttributes(Node.Store store, String workerName) {
        this.workerIsDissem = true;
        this.store = store;
        this.remoteNode = Worker.getWorker().getWorker(workerName);
        this.workerPrincipalName = null;
        this.workerPrincipal = null;
        this.privateKey = store.privateKey;
        this.pendingLogs = new LongKeyHashMap<LogRecord>();
        this.resetStats();
    }

    SessionAttributes(Node.Store store, String workerName, String workerPrincipalName, NodePrincipal worker) {
        this.workerIsDissem = false;
        this.store = store;
        this.remoteNode = Worker.getWorker().getWorker(workerName);
        this.workerPrincipalName = workerPrincipalName;
        this.workerPrincipal = worker;
        this.privateKey = store.privateKey;
        this.pendingLogs = new LongKeyHashMap<LogRecord>();
        this.resetStats();
    }

    private void resetStats() {
        this.numWrites = 0;
        this.numCreates = 0;
        this.numCommits = 0;
        this.numPrepares = 0;
        this.numGlobbedObjects = 0;
        this.numGlobsCreated = 0;
        this.numGlobsSent = 0;
        this.numObjectsSent = 0;
        this.numReads = 0;
        this.numSendsByType = new TreeMap<String, Integer>();
        this.pendingLogs.clear();
    }

    @Override
    public void endSession() {
        Logging.STORE_LOGGER.info(this.numReads + " read requests");
        Logging.STORE_LOGGER.info(this.numObjectsSent + " objects sent");
        Logging.STORE_LOGGER.info(this.numGlobsSent + " encrypted globs sent");
        Logging.STORE_LOGGER.info(this.numGlobsCreated + " encrypted globs created");
        if (this.numGlobsCreated != 0) {
            Logging.STORE_LOGGER.info("  " + this.numGlobbedObjects / this.numGlobsCreated + " objects per glob");
        }
        Logging.STORE_LOGGER.info(this.numPrepares + " prepare requests");
        Logging.STORE_LOGGER.info(this.numCommits + " commit requests");
        Logging.STORE_LOGGER.info(this.numCreates + " objects created");
        Logging.STORE_LOGGER.info(this.numWrites + " objects updated");
        for (Map.Entry<String, Integer> entry : this.numSendsByType.entrySet()) {
            Logging.log(Logging.STORE_LOGGER, Level.INFO, "\t{0} {1} sent", entry.getValue(), entry.getKey());
        }
    }

    protected synchronized void recordCommitAttempt() {
        ++this.numCommits;
    }

    protected synchronized void recordCommitSuccess(long transactionID) {
        LogRecord lr = this.pendingLogs.remove(transactionID);
        this.numCreates += lr.creates;
        this.numWrites += lr.writes;
    }

    protected synchronized void recordPrepare() {
        ++this.numPrepares;
    }

    protected synchronized void recordRead() {
        ++this.numReads;
    }

    protected synchronized void recordGlobSent() {
        ++this.numGlobsSent;
    }

    protected synchronized void recordGlobCreated(int globSize) {
        ++this.numGlobsCreated;
        this.numGlobbedObjects += globSize;
    }

    protected synchronized void recordObjectSent(String className) {
        int count = 0;
        ++this.numObjectsSent;
        if (this.numSendsByType.containsKey(className)) {
            count = this.numSendsByType.get(className);
        }
        this.numSendsByType.put(className, ++count);
    }

    protected synchronized void addPendingLog(long tid, int numCreates, int numWrites) {
        this.pendingLogs.put(tid, new LogRecord(numCreates, numWrites));
    }

    private class LogRecord {
        public int creates;
        public int writes;

        public LogRecord(int creates, int writes) {
            this.creates = creates;
            this.writes = writes;
        }
    }
}

