/*
 * Decompiled with CFR 0.152.
 */
package fabric.store;

import fabric.common.util.LongIterator;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.store.PrepareRequest;
import java.util.LinkedList;
import java.util.Queue;

public class ReadHistory {
    public static final long DEFAULT_LENGTH = 60000L;
    private final long length;
    private final LongKeyMap<Long> reads;
    private final Queue<PrepareRequest> history;
    private long currentSince;

    public ReadHistory() {
        this(60000L, System.currentTimeMillis());
    }

    public ReadHistory(long length, long beginning) {
        this.length = length;
        this.history = new LinkedList<PrepareRequest>();
        this.reads = new LongKeyHashMap<Long>();
        this.currentSince = beginning;
        new Cleaner().start();
    }

    public synchronized void record(PrepareRequest req) {
        LongIterator i = req.reads.keySet().iterator();
        while (i.hasNext()) {
            long oid = i.next();
            Long oldTime = this.reads.get(oid);
            if (oldTime != null && oldTime >= req.commitTime) continue;
            this.reads.put(oid, req.commitTime);
        }
        this.history.add(req);
    }

    private synchronized void clean(long now) {
        long cutoff = now - this.length;
        while (!this.history.isEmpty()) {
            PrepareRequest req = this.history.peek();
            if (req.commitTime > cutoff) break;
            LongIterator i = req.reads.keySet().iterator();
            while (i.hasNext()) {
                long oid = i.next();
                Long time = this.reads.get(oid);
                if (time == null || time >= cutoff) continue;
                this.reads.remove(oid);
            }
            this.history.poll();
        }
    }

    public synchronized boolean check(long oid, long time) {
        if (time < this.currentSince) {
            return false;
        }
        Long lastRead = this.reads.get(oid);
        return lastRead == null || lastRead < time;
    }

    private class Cleaner
    extends Thread {
        public Cleaner() {
            super("Read History Cleaner");
            this.setDaemon(true);
        }

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    this.wait(ReadHistory.this.length);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ReadHistory.this.clean(System.currentTimeMillis());
            }
        }
    }
}

