/*
 * Decompiled with CFR 0.152.
 */
package fabric.store;

import fabric.common.ConfigProperties;
import fabric.common.SSLSocketFactoryTable;
import fabric.common.exceptions.InternalError;
import fabric.store.ConnectionHandler;
import fabric.store.InProcessStore;
import fabric.store.Options;
import fabric.store.SimpleSurrogateManager;
import fabric.store.SurrogateManager;
import fabric.store.TransactionManager;
import fabric.store.db.ObjectDB;
import fabric.worker.RemoteStore;
import fabric.worker.Worker;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class Node {
    public Options opts;
    protected Store store;
    private final ConnectionHandler connectionHandler;

    public Node(Options opts) {
        this.opts = opts;
        this.connectionHandler = new ConnectionHandler(this);
        this.store = new Store(opts.storeName);
        this.startWorker();
        this.store.os.ensureInit();
        System.out.println("Store started");
    }

    private ObjectDB loadStore(ConfigProperties props) {
        try {
            final ObjectDB os = (ObjectDB)Class.forName(props.backendClass).getConstructor(String.class).newInstance(props.name);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            return os;
        }
        catch (Exception exc) {
            throw new InternalError("could not initialize store", exc);
        }
    }

    private void startWorker() {
        try {
            Map<String, RemoteStore> initStoreSet = Collections.singletonMap(this.store.name, new InProcessStore(this.store.name, this.store));
            Worker.initialize(this.store.name, "fab://" + this.store.name + "/" + 1L, initStoreSet);
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    public Store getStore(String name) {
        return name.equals(this.store.name) ? this.store : null;
    }

    public TransactionManager getTransactionManager(String storeName) {
        return storeName.equals(this.store.name) ? this.store.tm : null;
    }

    public SSLSocketFactory getSSLSocketFactory(String storeName) {
        return storeName.equals(this.store.name) ? this.store.factory : null;
    }

    public SurrogateManager getSurrogateManager(String storeName) {
        return storeName.equals(this.store.name) ? this.store.sm : null;
    }

    public PrivateKey getPrivateKey(String storeName) {
        return storeName.equals(this.store.name) ? this.store.privateKey : null;
    }

    public void start() throws IOException {
        ServerSocketChannel server = ServerSocketChannel.open();
        server.configureBlocking(true);
        server.socket().bind(new InetSocketAddress(this.store.port));
        while (true) {
            SocketChannel connection = server.accept();
            this.connectionHandler.handle(connection);
        }
    }

    protected class Store {
        public final String name;
        public final SSLSocketFactory factory;
        public final TransactionManager tm;
        public final SurrogateManager sm;
        public final ObjectDB os;
        public final Certificate[] certificateChain;
        public final PublicKey publicKey;
        public final PrivateKey privateKey;
        public final int port;

        private Store(String name) {
            KeyStore keyStore;
            this.name = name;
            ConfigProperties props = new ConfigProperties(name);
            char[] password = props.password;
            FileInputStream in = null;
            try {
                keyStore = KeyStore.getInstance("JKS");
                in = new FileInputStream(props.keystore);
                keyStore.load(in, password);
                in.close();
            }
            catch (KeyStoreException e) {
                throw new InternalError("Unable to open key store.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalError(e);
            }
            catch (CertificateException e) {
                throw new InternalError("Unable to open key store.", e);
            }
            catch (FileNotFoundException e) {
                throw new InternalError("File not found: " + e.getMessage());
            }
            catch (IOException e) {
                if (e.getCause() instanceof UnrecoverableKeyException) {
                    throw new InternalError("Unable to open key store: invalid password.");
                }
                throw new InternalError("Unable to open key store.", e);
            }
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(keyStore, password);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                tmf.init(keyStore);
                TrustManager[] tm = tmf.getTrustManagers();
                sslContext.init(kmf.getKeyManagers(), tm, null);
                this.factory = sslContext.getSocketFactory();
                this.certificateChain = keyStore.getCertificateChain(name);
                Certificate publicKeyCert = keyStore.getCertificate(name);
                this.publicKey = publicKeyCert.getPublicKey();
                this.privateKey = (PrivateKey)keyStore.getKey(name, password);
                SSLSocketFactoryTable.register(name, this.factory);
            }
            catch (KeyManagementException e) {
                throw new InternalError("Unable to initialise key manager factory.", e);
            }
            catch (UnrecoverableKeyException e1) {
                throw new InternalError("Unable to open key store.", e1);
            }
            catch (NoSuchAlgorithmException e1) {
                throw new InternalError(e1);
            }
            catch (KeyStoreException e1) {
                throw new InternalError("Unable to initialise key manager factory.", e1);
            }
            this.os = Node.this.loadStore(props);
            this.tm = new TransactionManager(this.os, this.privateKey);
            this.sm = new SimpleSurrogateManager(this.tm);
            this.port = props.storePort;
        }
    }
}

