/*
 * Decompiled with CFR 0.152.
 */
package fabric.store;

import fabric.common.AbstractMessageHandlerThread;
import fabric.common.Logging;
import fabric.common.ObjectGroup;
import fabric.common.SerializedObject;
import fabric.common.exceptions.AccessException;
import fabric.common.exceptions.ProtocolError;
import fabric.common.util.LongKeyMap;
import fabric.dissemination.Glob;
import fabric.messages.AbortTransactionMessage;
import fabric.messages.AllocateMessage;
import fabric.messages.CommitTransactionMessage;
import fabric.messages.DissemReadMessage;
import fabric.messages.GetCertificateChainMessage;
import fabric.messages.PrepareTransactionMessage;
import fabric.messages.ReadMessage;
import fabric.messages.StalenessCheckMessage;
import fabric.messages.UnauthenticatedAbortTransactionMessage;
import fabric.messages.UnauthenticatedCommitTransactionMessage;
import fabric.messages.UnauthenticatedPrepareTransactionMessage;
import fabric.store.PrepareRequest;
import fabric.store.SessionAttributes;
import fabric.worker.TransactionCommitFailedException;
import fabric.worker.TransactionPrepareFailedException;
import fabric.worker.transaction.TransactionManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public class MessageHandlerThread
extends AbstractMessageHandlerThread<SessionAttributes, MessageHandlerThread> {
    private MessageHandlerThread(AbstractMessageHandlerThread.Pool<MessageHandlerThread> pool) {
        super("Store message handler", pool);
        TransactionManager.startThread(this);
    }

    public void handle(AbortTransactionMessage message) throws AccessException, ProtocolError {
        if (((SessionAttributes)this.session).workerIsDissem) {
            throw new ProtocolError("Message not supported.");
        }
        Logging.log(Logging.STORE_REQUEST_LOGGER, Level.FINER, "Handling Abort Message from {0} for tid={1}", ((SessionAttributes)this.session).workerPrincipalName, message.tid.topTid);
        ((SessionAttributes)this.session).store.tm.abortTransaction(((SessionAttributes)this.session).workerPrincipal, message.tid.topTid);
    }

    public AllocateMessage.Response handle(AllocateMessage msg) throws AccessException, ProtocolError {
        if (((SessionAttributes)this.session).workerIsDissem) {
            throw new ProtocolError("Message not supported.");
        }
        Logging.STORE_REQUEST_LOGGER.log(Level.FINER, "Handling Allocate Message from {0}", ((SessionAttributes)this.session).workerPrincipalName);
        long[] onums = ((SessionAttributes)this.session).store.tm.newOnums(((SessionAttributes)this.session).workerPrincipal, msg.num);
        return new AllocateMessage.Response(onums);
    }

    public CommitTransactionMessage.Response handle(CommitTransactionMessage message) throws ProtocolError {
        if (((SessionAttributes)this.session).workerIsDissem) {
            throw new ProtocolError("Message not supported.");
        }
        try {
            this.commitTransaction(message.transactionID);
            return new CommitTransactionMessage.Response(true);
        }
        catch (TransactionCommitFailedException e) {
            return new CommitTransactionMessage.Response(false, e.getMessage());
        }
    }

    public PrepareTransactionMessage.Response handle(PrepareTransactionMessage msg) throws ProtocolError, TransactionPrepareFailedException {
        if (((SessionAttributes)this.session).workerIsDissem) {
            throw new ProtocolError("Message not supported.");
        }
        Logging.STORE_REQUEST_LOGGER.log(Level.FINER, "Handling Prepare Message, worker=" + ((SessionAttributes)this.session).workerPrincipalName + ", tid={0}", msg.tid);
        boolean subTransactionCreated = this.prepareTransaction(msg.tid, msg.commitTime, msg.serializedCreates, msg.serializedWrites, msg.reads);
        return new PrepareTransactionMessage.Response(subTransactionCreated);
    }

    public ReadMessage.Response handle(ReadMessage msg) throws AccessException, ProtocolError {
        if (((SessionAttributes)this.session).workerIsDissem) {
            throw new ProtocolError("Message not supported.");
        }
        Logging.STORE_REQUEST_LOGGER.log(Level.FINER, "Handling Read Message from {0}, onum=" + msg.onum, ((SessionAttributes)this.session).workerPrincipalName);
        ((SessionAttributes)this.session).recordRead();
        ObjectGroup group = ((SessionAttributes)this.session).store.tm.getGroup(((SessionAttributes)this.session).workerPrincipal, ((SessionAttributes)this.session).remoteNode, msg.onum, this);
        return new ReadMessage.Response(group);
    }

    public DissemReadMessage.Response handle(DissemReadMessage msg) throws AccessException {
        Logging.STORE_REQUEST_LOGGER.log(Level.FINER, "Handling DissemRead message from {0}, onum=" + msg.onum, ((SessionAttributes)this.session).remoteNode);
        ((SessionAttributes)this.session).recordRead();
        Glob glob = ((SessionAttributes)this.session).store.tm.getGlob(msg.onum, ((SessionAttributes)this.session).remoteNode, this);
        if (glob != null) {
            ((SessionAttributes)this.session).recordGlobSent();
        }
        return new DissemReadMessage.Response(glob);
    }

    public UnauthenticatedPrepareTransactionMessage.Response handle(UnauthenticatedPrepareTransactionMessage msg) {
        Logging.log(Logging.STORE_REQUEST_LOGGER, Level.FINER, "Handling Unauthenticated Prepare Message from {0}, tid={1}", ((SessionAttributes)this.session).remoteNode, msg.tid);
        try {
            List<SerializedObject> EMPTY_COLLECTION = Collections.emptyList();
            boolean subTransactionCreated = this.prepareTransaction(msg.tid, msg.commitTime, EMPTY_COLLECTION, EMPTY_COLLECTION, msg.reads);
            return new UnauthenticatedPrepareTransactionMessage.Response(subTransactionCreated);
        }
        catch (TransactionPrepareFailedException e) {
            return new UnauthenticatedPrepareTransactionMessage.Response(e.getMessage(), e.versionConflicts);
        }
    }

    public GetCertificateChainMessage.Response handle(GetCertificateChainMessage msg) {
        Logging.STORE_REQUEST_LOGGER.log(Level.FINER, "Handling request for SSL cert chain, worker={0}", ((SessionAttributes)this.session).remoteNode);
        return new GetCertificateChainMessage.Response(((SessionAttributes)this.session).store.certificateChain);
    }

    private boolean prepareTransaction(long tid, long commitTime, Collection<SerializedObject> serializedCreates, Collection<SerializedObject> serializedWrites, LongKeyMap<Integer> reads) throws TransactionPrepareFailedException {
        ((SessionAttributes)this.session).recordPrepare();
        PrepareRequest req = new PrepareRequest(tid, commitTime, serializedCreates, serializedWrites, reads);
        ((SessionAttributes)this.session).store.sm.createSurrogates(req);
        boolean subTransactionCreated = ((SessionAttributes)this.session).store.tm.prepare(((SessionAttributes)this.session).workerPrincipal, req);
        ((SessionAttributes)this.session).addPendingLog(req.tid, serializedCreates.size(), serializedWrites.size());
        return subTransactionCreated;
    }

    public UnauthenticatedCommitTransactionMessage.Response handle(UnauthenticatedCommitTransactionMessage message) {
        Logging.log(Logging.STORE_REQUEST_LOGGER, Level.FINER, "Handling Unauthenticated Commit Message from {0}, tid={1}", ((SessionAttributes)this.session).remoteNode, message.transactionID);
        try {
            this.commitTransaction(message.transactionID);
            return new UnauthenticatedCommitTransactionMessage.Response(true);
        }
        catch (TransactionCommitFailedException e) {
            return new UnauthenticatedCommitTransactionMessage.Response(false, e.getMessage());
        }
    }

    private void commitTransaction(long transactionID) throws TransactionCommitFailedException {
        ((SessionAttributes)this.session).recordCommitAttempt();
        ((SessionAttributes)this.session).store.tm.commitTransaction(((SessionAttributes)this.session).remoteNode, ((SessionAttributes)this.session).workerPrincipal, transactionID);
        ((SessionAttributes)this.session).recordCommitSuccess(transactionID);
    }

    public void handle(UnauthenticatedAbortTransactionMessage message) throws AccessException {
        Logging.STORE_REQUEST_LOGGER.log(Level.FINER, "Handling Abort Message from {0}", ((SessionAttributes)this.session).remoteNode);
        ((SessionAttributes)this.session).store.tm.abortTransaction(((SessionAttributes)this.session).workerPrincipal, message.tid.topTid);
    }

    public List<SerializedObject> handle(StalenessCheckMessage message) throws AccessException {
        Logging.STORE_REQUEST_LOGGER.log(Level.FINER, "Handling Staleness Check Message from {0}", ((SessionAttributes)this.session).remoteNode);
        return ((SessionAttributes)this.session).store.tm.checkForStaleObjects(((SessionAttributes)this.session).workerPrincipal, message.versions);
    }

    static class Factory
    implements AbstractMessageHandlerThread.Factory<MessageHandlerThread> {
        Factory() {
        }

        @Override
        public MessageHandlerThread createMessageHandler(AbstractMessageHandlerThread.Pool<MessageHandlerThread> pool) {
            return new MessageHandlerThread(pool);
        }
    }
}

