/*
 * Decompiled with CFR 0.152.
 */
package fabric.store;

import fabric.common.Logging;
import fabric.common.Version;
import fabric.common.exceptions.TerminationException;
import fabric.common.exceptions.UsageError;
import fabric.store.Node;
import fabric.store.Options;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;

public class Main {
    public static void main(String[] args) {
        try {
            Main.start(args);
        }
        catch (TerminationException te) {
            if (te.getMessage() != null) {
                (te.exitCode == 0 ? System.out : System.err).println(te.getMessage());
            }
            System.exit(te.exitCode);
        }
    }

    public static void start(String[] args) {
        Options opts;
        Logging.STORE_LOGGER.info("Store node");
        Logging.STORE_LOGGER.log(Level.CONFIG, "Fabric version {0}", new Version());
        Logging.STORE_LOGGER.info("");
        try {
            opts = new Options(args);
        }
        catch (UsageError ue) {
            PrintStream out;
            PrintStream printStream = out = ue.exitCode == 0 ? System.out : System.err;
            if (ue.getMessage() != null && ue.getMessage().length() > 0) {
                out.println(ue.getMessage());
                out.println();
            }
            Options.usage(out);
            throw new TerminationException(ue.exitCode);
        }
        try {
            Node node = new Node(opts);
            node.start();
        }
        catch (IOException e) {
            throw new TerminationException(e.getMessage(), 1);
        }
    }
}

