/*
 * Decompiled with CFR 0.152.
 */
package fabric.store;

import fabric.common.ObjectGroup;
import fabric.common.SerializedObject;
import fabric.common.TransactionID;
import fabric.common.exceptions.AccessException;
import fabric.common.exceptions.FetchException;
import fabric.common.exceptions.InternalError;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.lang.Object;
import fabric.store.Node;
import fabric.store.PrepareRequest;
import fabric.store.SurrogateManager;
import fabric.store.TransactionManager;
import fabric.worker.RemoteStore;
import fabric.worker.TransactionCommitFailedException;
import fabric.worker.TransactionPrepareFailedException;
import fabric.worker.Worker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InProcessStore
extends RemoteStore {
    protected final TransactionManager tm;
    protected final SurrogateManager sm;

    public InProcessStore(String name, Node.Store c) {
        super(name, c.publicKey);
        this.tm = c.tm;
        this.sm = c.sm;
    }

    @Override
    public void abortTransaction(boolean useAuthentication, TransactionID tid) {
        try {
            this.tm.abortTransaction(Worker.getWorker().getPrincipal(), tid.topTid);
        }
        catch (AccessException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public void commitTransaction(boolean useAuthentication, long transactionID) throws TransactionCommitFailedException {
        this.tm.commitTransaction(null, Worker.getWorker().getPrincipal(), transactionID);
    }

    @Override
    public long createOnum() {
        try {
            return this.tm.newOnums(Worker.getWorker().getPrincipal(), 1)[0];
        }
        catch (AccessException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public boolean prepareTransaction(boolean useAuthentication, long tid, long commitTime, Collection<Object._Impl> toCreate, LongKeyMap<Integer> reads, Collection<Object._Impl> writes) throws TransactionPrepareFailedException {
        ArrayList<SerializedObject> serializedCreates = new ArrayList<SerializedObject>(toCreate.size());
        ArrayList<SerializedObject> serializedWrites = new ArrayList<SerializedObject>(writes.size());
        for (Object._Impl o : toCreate) {
            serializedCreates.add(new SerializedObject(o));
        }
        for (Object._Impl o : writes) {
            serializedWrites.add(new SerializedObject(o));
        }
        PrepareRequest req = new PrepareRequest(tid, commitTime, serializedCreates, serializedWrites, reads);
        this.sm.createSurrogates(req);
        return this.tm.prepare(Worker.getWorker().getPrincipal(), req);
    }

    @Override
    public ObjectGroup readObjectFromStore(long onum) throws FetchException {
        LongKeyHashMap<SerializedObject> map = new LongKeyHashMap<SerializedObject>();
        SerializedObject obj = this.tm.read(onum);
        if (obj == null) {
            throw new FetchException(new AccessException(this, onum));
        }
        map.put(onum, obj);
        return new ObjectGroup(map);
    }

    @Override
    protected List<SerializedObject> getStaleObjects(LongKeyMap<Integer> reads) {
        try {
            return this.tm.checkForStaleObjects(this.getPrincipal(), reads);
        }
        catch (AccessException e) {
            throw new InternalError(e);
        }
    }
}

