/*
 * Decompiled with CFR 0.152.
 */
package fabric.parse;

import fabric.ast.FabricNodeFactory;
import jif.ast.ConstArrayTypeNode;
import jif.ast.LabeledTypeNode;
import jif.parse.Grm;
import polyglot.ast.TypeNode;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class Array
extends jif.parse.Array {
    protected final boolean isNative;

    public Array(Grm parser, Position pos, TypeNode prefix) {
        this(parser, pos, prefix, false);
    }

    public Array(Grm parser, Position pos, TypeNode prefix, boolean isConst) {
        this(parser, pos, prefix, isConst, false);
    }

    public Array(Grm parser, Position pos, TypeNode prefix, boolean isConst, boolean isNative) {
        super(parser, pos, prefix, isConst);
        this.isNative = isNative;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public TypeNode toType() {
        TypeNode base = this.prefix;
        if (base instanceof LabeledTypeNode) {
            base = ((LabeledTypeNode)base).typePart();
        }
        boolean isConst = this.isConst() || base instanceof ConstArrayTypeNode;
        boolean isFabric = !this.isNative();
        FabricNodeFactory nf = (FabricNodeFactory)this.parser.nf;
        if (isConst && isFabric) {
            throw new InternalCompilerError("Const fabric arrays not yet supported" + base.position());
        }
        if (isConst && !isFabric) {
            return nf.ConstArrayTypeNode(this.pos, this.prefix);
        }
        if (!isConst && isFabric) {
            return nf.FabricArrayTypeNode(this.pos, this.prefix);
        }
        if (!isConst && !isFabric) {
            return nf.ArrayTypeNode(this.pos, this.prefix);
        }
        throw new InternalCompilerError("This line should be unreachable");
    }
}

